/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.client.gui;

import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.FruitProbeData;
import com.elytradev.fruitphone.FruitRenderer;
import com.elytradev.fruitphone.FruitSounds;
import com.elytradev.fruitphone.Gravity;
import com.elytradev.fruitphone.capability.FruitEquipmentCapability;
import com.elytradev.fruitphone.item.ItemFruitPassive;
import com.elytradev.fruitphone.proxy.ClientProxy;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.common.Rendering;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.IUnit;
import com.elytradev.probe.api.UnitDictionary;
import com.elytradev.probe.api.impl.ProbeData;
import com.elytradev.probe.api.impl.Unit;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenConfigureGlasses
extends GuiScreen {
    private static final ResourceLocation CHECKBOX = new ResourceLocation("fruitphone", "textures/gui/checkbox.png");
    private static final ResourceLocation HANDLE = new ResourceLocation("fruitphone", "textures/gui/resize_handle.png");
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final float[] CLAMP_REGION_SNAP_POINTS = new float[]{0.25f, 0.33333334f, 0.5f, 0.6666667f, 0.75f, 1.0f};
    private boolean snapToGuides = true;
    private DragTarget dragTarget;
    private boolean dragSnapped = false;
    private boolean dragSnappedX = false;
    private boolean dragSnappedY = false;
    private int lastMouseX;
    private int lastMouseY;
    private Gravity dragGravity;
    private int dragX;
    private int dragY;
    private int overlayHandleX;
    private int overlayHandleY;
    private int clampHandleX;
    private int clampHandleY;
    private int checkboxX;
    private int checkboxY;
    private int x;
    private int y;
    private int objWidth;
    private int objHeight;
    private ScaledResolution res;
    private ItemStack iron = new ItemStack(Blocks.field_150366_p, 0);
    private ItemStack gold = new ItemStack(Blocks.field_150352_o, 0);
    private ItemStack coal = new ItemStack(Items.field_151044_h, 0);
    private ItemStack diamond = new ItemStack(Items.field_151045_i, 0);
    private ItemStack cobble = new ItemStack(Blocks.field_150347_e, 0);
    private ItemStack furnaceCoal = new ItemStack(Items.field_151044_h, Integer.MAX_VALUE);
    private ItemStack furnaceCobble = new ItemStack(Blocks.field_150347_e, Integer.MAX_VALUE);
    private ItemStack furnaceStone = new ItemStack(Blocks.field_150348_b, 0);
    private long energy = Long.MAX_VALUE;
    private Supplier<List<IProbeData>> probeDataSupplier = this::magicBoxData;
    private ItemStack[] chestData = new ItemStack[54];
    private Random rand = new Random();

    public ScreenConfigureGlasses() {
        Arrays.fill(this.chestData, ItemStack.field_190927_a);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Gravity g = FruitPhone.inst.glassesGravity.opposite();
        if (!g.isCorner()) {
            if (this.field_146292_n.isEmpty()) {
                g = Gravity.SOUTH_EAST;
            } else {
                return;
            }
        }
        this.field_146292_n.clear();
        int confX = g.resolveX(10, this.field_146294_l, 108);
        int confY = g.resolveY(10, this.field_146295_m, 64);
        this.func_189646_b((GuiButton)new GuiButtonExt(0, confX, confY + 22, 108, 20, I18n.func_135052_a((String)"fruitphone.gui.restoreDefaults", (Object[])new Object[0])));
        this.func_189646_b((GuiButton)new GuiButtonExt(1, confX, confY + 44, 108, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.func_189646_b((GuiButton)new GuiButtonExt(2, confX, confY, 20, 20, ""));
        this.func_189646_b((GuiButton)new GuiButtonExt(3, confX + 22, confY, 20, 20, ""));
        this.func_189646_b((GuiButton)new GuiButtonExt(4, confX + 44, confY, 20, 20, ""));
        this.func_189646_b((GuiButton)new GuiButtonExt(5, confX + 66, confY, 20, 20, ""));
        this.func_189646_b((GuiButton)new GuiButtonExt(6, confX + 88, confY, 20, 20, ""));
        this.checkboxX = g.flipVertical().resolveX(10, this.field_146294_l, 10);
        this.checkboxY = g.flipVertical().resolveY(10, this.field_146295_m, 10);
        this.res = new ScaledResolution(Minecraft.func_71410_x());
    }

    private List<IProbeData> magicBoxData() {
        return ImmutableList.of((Object)new ProbeData().withLabel("Magic Box").withInventory(ImmutableList.of((Object)new ItemStack(Blocks.field_150339_S))).withBar(0.0, (double)((int)(ClientProxy.ticks % 200.0f) / 2), 100.0, (IUnit)UnitDictionary.PERCENT), (Object)new ProbeData().withBar(0.0, (double)this.energy, 9.223372036854776E18, (IUnit)UnitDictionary.DANKS), (Object)new ProbeData().withInventory(ImmutableList.of((Object)this.iron, (Object)this.gold, (Object)this.coal, (Object)this.diamond, (Object)this.cobble)));
    }

    private List<IProbeData> grassData() {
        return ImmutableList.of((Object)new ProbeData().withLabel(new ItemStack((Block)Blocks.field_150349_c).func_82833_r()).withInventory(ImmutableList.of((Object)new ItemStack((Block)Blocks.field_150349_c))));
    }

    private List<IProbeData> chestData() {
        return ImmutableList.of((Object)new ProbeData().withLabel(new ItemStack((Block)Blocks.field_150486_ae).func_82833_r()).withInventory(ImmutableList.of((Object)new ItemStack((Block)Blocks.field_150486_ae))), (Object)new ProbeData().withInventory(ImmutableList.copyOf((Object[])this.chestData)));
    }

    private List<IProbeData> furnaceData() {
        return ImmutableList.of((Object)new FruitProbeData().withInventory(ImmutableList.of((Object)new ItemStack(Blocks.field_150460_al))).withLabel(new ItemStack(Blocks.field_150460_al).func_82833_r()), (Object)new ProbeData().withLabel((ITextComponent)new TextComponentTranslation("fruitphone.furnace.fuel", new Object[0])).withBar(0.0, (double)(1600.0f - ClientProxy.ticks % 1600.0f), 1600.0, (IUnit)UnitDictionary.TICKS), (Object)new ProbeData().withLabel((ITextComponent)new TextComponentTranslation("fruitphone.furnace.progress", new Object[0])).withBar(0.0, (double)(ClientProxy.ticks % 200.0f / 2.0f), 100.0, (IUnit)UnitDictionary.PERCENT), (Object)new ProbeData().withInventory(ImmutableList.of((Object)this.furnaceCobble, (Object)this.furnaceCoal, (Object)this.furnaceStone)));
    }

    private List<IProbeData> tankData() {
        return ImmutableList.of((Object)new ProbeData().withLabel("Tank").withInventory(ImmutableList.of((Object)new ItemStack(Blocks.field_150359_w))), (Object)new ProbeData().withBar(0.0, (double)(ClientProxy.ticks % 4000.0f) / 1000.0, 4.0, UnitDictionary.getInstance().getUnit(FluidRegistry.LAVA)), (Object)new ProbeData().withBar(0.0, (double)((ClientProxy.ticks + 1283.0f) % 4000.0f) / 1000.0, 4.0, UnitDictionary.getInstance().getUnit(FluidRegistry.WATER)));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            FruitPhone.inst.glassesGravity = Gravity.NORTH_WEST;
            FruitPhone.inst.glassesScale = 1.0f;
            FruitPhone.inst.glassesXOffset = 10;
            FruitPhone.inst.glassesYOffset = 10;
            FruitPhone.inst.maxGlassesHeight = 0.6666667f;
            FruitPhone.inst.maxGlassesWidth = 0.33333334f;
            this.func_73866_w_();
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)FruitSounds.DRILL, (float)(0.875f + this.rand.nextFloat() * 0.25f)));
            this.field_146297_k.func_147108_a(null);
        } else if (button.field_146127_k == 2) {
            this.probeDataSupplier = this::magicBoxData;
        } else if (button.field_146127_k == 3) {
            this.probeDataSupplier = this::grassData;
        } else if (button.field_146127_k == 4) {
            Arrays.fill(this.chestData, ItemStack.field_190927_a);
            this.probeDataSupplier = this::chestData;
        } else if (button.field_146127_k == 5) {
            this.probeDataSupplier = this::furnaceData;
        } else if (button.field_146127_k == 6) {
            this.probeDataSupplier = this::tankData;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack glasses;
        int checkboxTextW;
        int checkboxTextX;
        if (this.field_146297_k == null) {
            return;
        }
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String checkboxStr = I18n.func_135052_a((String)"fruitphone.gui.snapToGuides", (Object[])new Object[0]);
        int checkboxTextCol = -1;
        int v = 10;
        if (mouseX >= this.checkboxX && mouseX <= this.checkboxX + 10 + this.field_146289_q.func_78256_a(checkboxStr) + 2 && mouseY >= this.checkboxY && mouseY <= this.checkboxY + 10) {
            v = 20;
            checkboxTextCol = -96;
        }
        RenderHelper.func_74520_c();
        this.drawButtonIcon((GuiButton)this.field_146292_n.get(2), new ItemStack(Blocks.field_150339_S));
        this.drawButtonIcon((GuiButton)this.field_146292_n.get(3), new ItemStack((Block)Blocks.field_150349_c));
        this.drawButtonIcon((GuiButton)this.field_146292_n.get(4), new ItemStack((Block)Blocks.field_150486_ae));
        this.drawButtonIcon((GuiButton)this.field_146292_n.get(5), new ItemStack(Blocks.field_150460_al));
        this.drawButtonIcon((GuiButton)this.field_146292_n.get(6), new ItemStack(Blocks.field_150359_w));
        RenderHelper.func_74518_a();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Rendering.bindTexture(CHECKBOX);
        ScreenConfigureGlasses.func_146110_a((int)this.checkboxX, (int)this.checkboxY, (float)0.0f, (float)v, (int)10, (int)10, (float)20.0f, (float)30.0f);
        if (this.snapToGuides) {
            ScreenConfigureGlasses.func_146110_a((int)this.checkboxX, (int)this.checkboxY, (float)10.0f, (float)v, (int)10, (int)10, (float)20.0f, (float)30.0f);
        }
        if ((checkboxTextX = this.checkboxX + 12) + (checkboxTextW = this.field_146289_q.func_78256_a(checkboxStr)) >= this.field_146294_l) {
            checkboxTextX = this.checkboxX - checkboxTextW - 2;
        }
        this.field_146289_q.func_175063_a(checkboxStr, (float)checkboxTextX, (float)(this.checkboxY + 1), checkboxTextCol);
        int color = -1;
        if (Minecraft.func_71410_x().field_71439_g.hasCapability(FruitPhone.CAPABILITY_EQUIPMENT, null) && (glasses = ((FruitEquipmentCapability)Minecraft.func_71410_x().field_71439_g.getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)).glasses).func_77973_b() instanceof ItemFruitPassive) {
            ItemFruitPassive item = (ItemFruitPassive)glasses.func_77973_b();
            color = item.getColor(glasses);
        }
        Gravity g = FruitPhone.inst.glassesGravity;
        int xOfs = FruitPhone.inst.glassesXOffset;
        int yOfs = FruitPhone.inst.glassesYOffset;
        float confScale = FruitPhone.inst.glassesScale;
        float maxWidthRaw = (float)this.field_146294_l * FruitPhone.inst.maxGlassesWidth;
        float maxHeightRaw = (float)this.field_146295_m * FruitPhone.inst.maxGlassesHeight;
        int maxWidth = (int)(maxWidthRaw / confScale);
        int maxHeight = (int)(maxHeightRaw / confScale);
        if (this.dragTarget != DragTarget.OVERLAY_POSITION) {
            int regionWidth = (int)Math.min((float)this.field_146294_l, maxWidthRaw);
            int regionHeight = (int)Math.min((float)this.field_146295_m, maxHeightRaw);
            int regionX = g.resolveX(xOfs, this.field_146294_l, regionWidth);
            int regionY = g.resolveY(yOfs, this.field_146295_m, regionHeight);
            Gui.func_73734_a((int)regionX, (int)regionY, (int)(regionX + regionWidth), (int)(regionY + regionHeight), (int)-2002081110);
            this.clampHandleX = regionX + g.opposite().resolveX(0, regionWidth, 10);
            this.clampHandleY = regionY + g.opposite().resolveY(0, regionHeight, 10);
            String clampStr = I18n.func_135052_a((String)"fruitphone.gui.clampRegion", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(clampStr, regionX + g.opposite().resolveX(12, regionWidth, this.field_146289_q.func_78256_a(clampStr)), regionY + g.opposite().resolveY(1, regionHeight, 8), -1);
        }
        if (this.snapToGuides) {
            if (this.dragTarget == DragTarget.CLAMP_REGION_SIZE) {
                for (float snap : CLAMP_REGION_SNAP_POINTS) {
                    this.func_73730_a(0, this.field_146294_l, g.resolveY((int)(snap * (float)this.field_146295_m) + yOfs, this.field_146295_m, 0), 1442840480);
                    this.func_73728_b(g.resolveX((int)(snap * (float)this.field_146294_l) + xOfs, this.field_146294_l, 0), 0, this.field_146295_m, 1442840480);
                }
            } else if (this.dragTarget != DragTarget.OVERLAY_SIZE && this.dragTarget == DragTarget.OVERLAY_POSITION) {
                this.func_73730_a(0, this.field_146294_l, this.field_146295_m / 2, 1442840480);
                this.func_73728_b(this.field_146294_l / 2, 0, this.field_146295_m, 1442840480);
                if (!g.isVerticalCenter()) {
                    this.func_73730_a(0, this.field_146294_l, g.resolveY(10, this.field_146295_m, 1), 1442840480);
                }
                if (!g.isHorizontalCenter()) {
                    this.func_73728_b(g.resolveX(10, this.field_146294_l, 1), 0, this.field_146295_m, 1442840480);
                }
                if (g.isCorner()) {
                    float ang;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)g.resolveX(0, this.field_146294_l, 0), (float)g.resolveY(0, this.field_146295_m, 0), (float)0.0f);
                    switch (g) {
                        case NORTH_WEST: {
                            ang = 45.0f;
                            break;
                        }
                        case NORTH_EAST: {
                            ang = 135.0f;
                            break;
                        }
                        case SOUTH_EAST: {
                            ang = 225.0f;
                            break;
                        }
                        case SOUTH_WEST: {
                            ang = 315.0f;
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Missing case for " + (Object)((Object)g)));
                        }
                    }
                    GlStateManager.func_179114_b((float)ang, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.func_73730_a(0, (int)((double)Math.min(this.field_146294_l, this.field_146295_m) * SQRT2), 0, 1442840480);
                    GlStateManager.func_179121_F();
                }
            }
        }
        List probeData = (List)this.probeDataSupplier.get();
        GlStateManager.func_179094_E();
        FruitRenderer.DataSize actual = FruitRenderer.calculatePreferredDataSize(probeData, 90, 50, maxWidth, maxHeight);
        FruitRenderer.DataSize clamped = new FruitRenderer.DataSize();
        clamped.setWidth(Math.min(maxWidth, actual.getWidth()));
        clamped.setHeight(Math.min(maxHeight, actual.getHeight()));
        if (clamped.getWidth() > 0 && clamped.getHeight() > 0) {
            float scale = FruitRenderer.getContainScale(clamped.getWidth(), clamped.getHeight(), actual.getWidth(), actual.getHeight());
            float xScale = 1.0f;
            float yScale = 1.0f;
            if (clamped.getWidth() < clamped.getHeight()) {
                xScale = scale;
            } else if (clamped.getHeight() < clamped.getWidth()) {
                yScale = scale;
            } else {
                xScale = yScale = scale;
            }
            this.objWidth = (int)((float)clamped.getWidth() * (xScale *= confScale)) + 10;
            this.objHeight = (int)((float)clamped.getHeight() * (yScale *= confScale)) + 10;
            this.x = g.resolveX(xOfs, this.field_146294_l, this.objWidth);
            this.y = g.resolveY(yOfs, this.field_146295_m, this.objHeight);
            this.overlayHandleX = this.x + g.opposite().resolveX(0, this.objWidth, 10);
            this.overlayHandleY = this.y + g.opposite().resolveY(0, this.objHeight, 10);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
            Gui.func_73734_a((int)0, (int)0, (int)this.objWidth, (int)this.objHeight, (int)color);
            Gui.func_73734_a((int)1, (int)1, (int)(this.objWidth - 1), (int)(this.objHeight - 1), (int)-15984331);
            GlStateManager.func_179109_b((float)5.0f, (float)5.0f, (float)40.0f);
            GlStateManager.func_179152_a((float)confScale, (float)confScale, (float)1.0f);
            FruitRenderer.render(probeData, clamped.getWidth(), clamped.getHeight(), true, actual);
            GlStateManager.func_179121_F();
            int overlayHandleColor = 0x55FFFFFF;
            int clampHandleColor = 0x55FFFFFF;
            if (this.dragTarget == DragTarget.OVERLAY_SIZE) {
                overlayHandleColor = -1426063456;
            } else if (this.dragTarget == DragTarget.CLAMP_REGION_SIZE) {
                clampHandleColor = -1426063456;
            } else if (Mouse.isInsideWindow()) {
                if (mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.objWidth && mouseY <= this.y + this.objHeight && mouseX >= this.overlayHandleX && mouseY >= this.overlayHandleY && mouseX <= this.overlayHandleX + 10 && mouseY <= this.overlayHandleY + 10) {
                    overlayHandleColor = -1426063456;
                }
                if (mouseX >= this.clampHandleX && mouseY >= this.clampHandleY && mouseX <= this.clampHandleX + 10 && mouseY <= this.clampHandleY + 10) {
                    clampHandleColor = -1426063456;
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
            Rendering.bindTexture(HANDLE);
            int handleU = g.opposite().ordinal() % 3 * 10;
            int handleV = g.opposite().ordinal() / 3 * 10;
            Rendering.color4(overlayHandleColor);
            ScreenConfigureGlasses.func_146110_a((int)this.overlayHandleX, (int)this.overlayHandleY, (float)handleU, (float)handleV, (int)10, (int)10, (float)30.0f, (float)30.0f);
            if (this.dragTarget != DragTarget.OVERLAY_POSITION) {
                Rendering.color4(clampHandleColor);
                ScreenConfigureGlasses.func_146110_a((int)this.clampHandleX, (int)this.clampHandleY, (float)handleU, (float)handleV, (int)10, (int)10, (float)30.0f, (float)30.0f);
            }
            ArrayList tt = Lists.newArrayList();
            if (this.dragTarget == DragTarget.OVERLAY_SIZE) {
                tt.add((this.dragSnapped ? "\u00a7e" : "") + Unit.FORMAT_STANDARD.format(FruitPhone.inst.glassesScale * 100.0f) + "%");
            } else if (this.dragTarget == DragTarget.OVERLAY_POSITION) {
                tt.add((this.dragSnapped ? "\u00a7e" : "") + I18n.func_135052_a((String)("fruitphone.gravity." + (Keyboard.isKeyDown((int)41) ? "egg." : "") + this.dragGravity.toString()), (Object[])new Object[0]));
                tt.add((this.dragSnappedX ? "\u00a7e" : "") + FruitPhone.inst.glassesXOffset + "\u00a7r, " + (this.dragSnappedY ? "\u00a7e" : "") + FruitPhone.inst.glassesYOffset);
            } else if (this.dragTarget == DragTarget.CLAMP_REGION_SIZE) {
                tt.add((this.dragSnappedX ? "\u00a7e" : "") + Unit.FORMAT_STANDARD.format(FruitPhone.inst.maxGlassesWidth * 100.0f) + "%\u00a7r x " + (this.dragSnappedY ? "\u00a7e" : "") + Unit.FORMAT_STANDARD.format(FruitPhone.inst.maxGlassesHeight * 100.0f) + "%");
            }
            if (!tt.isEmpty()) {
                this.func_146283_a(tt, mouseX, mouseY);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void drawButtonIcon(GuiButton button, ItemStack is) {
        Minecraft.func_71410_x().func_175599_af().func_180450_b(is, button.field_146128_h + 2, button.field_146129_i + 2);
    }

    public void func_146281_b() {
        super.func_146281_b();
        FruitPhone.inst.saveConfig();
    }

    public void func_73876_c() {
        int idx;
        ItemStack is;
        super.func_73876_c();
        this.energy -= 300L;
        if ((int)ClientProxy.ticks % 200 == 0) {
            this.energy -= 1000000L;
            this.cobble.func_190920_e(this.cobble.func_190916_E() + (this.rand.nextInt(100) + 1));
            if (this.rand.nextInt(4) == 0) {
                this.coal.func_190920_e(this.coal.func_190916_E() + 1);
            }
            if (this.rand.nextInt(8) == 0) {
                this.iron.func_190920_e(this.iron.func_190916_E() + 1);
            }
            if (this.rand.nextInt(12) == 0) {
                this.gold.func_190920_e(this.gold.func_190916_E() + 1);
            }
            if (this.rand.nextInt(24) == 0) {
                this.diamond.func_190920_e(this.diamond.func_190916_E() + 1);
            }
            this.furnaceCobble.func_190920_e(this.furnaceCobble.func_190916_E() - 1);
            this.furnaceStone.func_190920_e(this.furnaceStone.func_190916_E() + 1);
        }
        if ((int)ClientProxy.ticks % 1600 == 0) {
            this.furnaceCoal.func_190920_e(this.furnaceCoal.func_190916_E() - 1);
        }
        if ((is = this.chestData[idx = this.rand.nextInt(54)]).func_190926_b()) {
            Item item;
            while (!(item = (Item)Item.field_150901_e.func_186801_a(this.rand)).getRegistryName().func_110624_b().equals("minecraft")) {
            }
            try {
                NonNullList nnl = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), nnl);
                is = (ItemStack)nnl.get(this.rand.nextInt(nnl.size()));
                if (item.func_77645_m() && is.func_77958_k() > 0) {
                    is.func_77964_b(this.rand.nextInt(is.func_77958_k()));
                }
                this.chestData[idx] = is;
            }
            catch (Exception exception) {}
        } else if (is.func_77985_e()) {
            is.func_190920_e(is.func_190916_E() + 1);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        String str = I18n.func_135052_a((String)"fruitphone.gui.snapToCenter", (Object[])new Object[0]);
        if (mouseButton == 0) {
            if (mouseX >= this.checkboxX && mouseX <= this.checkboxX + 10 + this.field_146289_q.func_78256_a(str) + 2 && mouseY >= this.checkboxY && mouseY <= this.checkboxY + 10) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.snapToGuides = !this.snapToGuides;
            } else if (mouseX >= this.overlayHandleX && mouseY >= this.overlayHandleY && mouseX <= this.overlayHandleX + 10 && mouseY <= this.overlayHandleY + 10) {
                this.dragTarget = DragTarget.OVERLAY_SIZE;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            } else if (mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.objWidth && mouseY <= this.y + this.objHeight) {
                this.dragTarget = DragTarget.OVERLAY_POSITION;
                this.dragGravity = FruitPhone.inst.glassesGravity;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                this.dragX = FruitPhone.inst.glassesXOffset;
                this.dragY = FruitPhone.inst.glassesYOffset;
            } else if (mouseX >= this.clampHandleX && mouseY >= this.clampHandleY && mouseX <= this.clampHandleX + 10 && mouseY <= this.clampHandleY + 10) {
                this.dragTarget = DragTarget.CLAMP_REGION_SIZE;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (clickedMouseButton == 0) {
            if (this.dragTarget == DragTarget.OVERLAY_SIZE) {
                int xOfs = FruitPhone.inst.glassesXOffset - 5;
                int yOfs = FruitPhone.inst.glassesYOffset - 5;
                Gravity g = FruitPhone.inst.glassesGravity;
                int resolvedX = g.resolveX(mouseX, 0, 0);
                int resolvedY = g.resolveY(mouseY, 0, 0);
                if (g.isHorizontalCenter()) {
                    resolvedX = mouseX;
                }
                if (g.isVerticalCenter()) {
                    resolvedY = mouseY;
                }
                if (resolvedX < 0) {
                    resolvedX = this.field_146294_l + resolvedX;
                }
                if (resolvedY < 0) {
                    resolvedY = this.field_146295_m + resolvedY;
                }
                List probeData = (List)this.probeDataSupplier.get();
                int maxWidth = (int)((float)this.field_146294_l * FruitPhone.inst.maxGlassesWidth);
                int maxHeight = (int)((float)this.field_146295_m * FruitPhone.inst.maxGlassesHeight);
                FruitRenderer.DataSize actual = FruitRenderer.calculatePreferredDataSize(probeData, 90, 50, maxWidth, maxHeight);
                int w = Math.min(maxWidth, actual.getWidth()) + 10;
                int h = Math.min(maxHeight, actual.getHeight()) + 10;
                float max = (float)this.field_146294_l * FruitPhone.inst.maxGlassesWidth / (float)w;
                float min = 1.0f / (float)this.res.func_78325_e();
                int normalHandleX = xOfs + w;
                int normalHandleY = yOfs + h;
                int dist = Math.max(resolvedX - normalHandleX, resolvedY - normalHandleY);
                float scale = 1.0f + (float)dist / (float)w;
                this.dragSnapped = false;
                if (this.snapToGuides) {
                    int round = (int)scale;
                    float mult = (float)this.res.func_78325_e() * Math.max(1.0f, (float)round);
                    float tolerance = 0.025f;
                    int i = 0;
                    while ((float)i <= mult) {
                        float snap = (float)round + (float)i / mult;
                        if (Math.abs(scale - snap) < tolerance) {
                            scale = snap;
                            this.dragSnapped = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (scale < min) {
                    scale = min;
                    this.dragSnapped = true;
                } else if (scale > max) {
                    scale = max;
                    this.dragSnapped = true;
                }
                FruitPhone.inst.glassesScale = scale;
            } else if (this.dragTarget == DragTarget.CLAMP_REGION_SIZE) {
                int xOfs = FruitPhone.inst.glassesXOffset - 5;
                int yOfs = FruitPhone.inst.glassesYOffset - 5;
                Gravity g = FruitPhone.inst.glassesGravity;
                int resolvedX = g.resolveX(mouseX, 0, 0);
                int resolvedY = g.resolveY(mouseY, 0, 0);
                if (g.isHorizontalCenter()) {
                    resolvedX = mouseX;
                }
                if (g.isVerticalCenter()) {
                    resolvedY = mouseY;
                }
                if (resolvedX < 0) {
                    resolvedX = this.field_146294_l + resolvedX;
                }
                if (resolvedY < 0) {
                    resolvedY = this.field_146295_m + resolvedY;
                }
                float newWidth = (float)(resolvedX - xOfs) / (float)this.field_146294_l;
                float newHeight = (float)(resolvedY - yOfs) / (float)this.field_146295_m;
                this.dragSnappedX = false;
                this.dragSnappedY = false;
                if (this.snapToGuides) {
                    float toleranceX = newWidth > 0.75f ? 0.07f : 0.025f;
                    float toleranceY = newHeight > 0.75f ? 0.11f : 0.025f;
                    for (float snap : CLAMP_REGION_SNAP_POINTS) {
                        this.func_73730_a(0, this.field_146294_l, (int)(snap * (float)this.field_146295_m), 1442840480);
                        this.func_73728_b((int)(snap * (float)this.field_146294_l), 0, this.field_146295_m, 1442840480);
                        if (Math.abs(newWidth - snap) < toleranceX) {
                            newWidth = snap;
                            this.dragSnappedX = true;
                        }
                        if (!(Math.abs(newHeight - snap) < toleranceY)) continue;
                        newHeight = snap;
                        this.dragSnappedY = true;
                    }
                }
                FruitPhone.inst.maxGlassesWidth = newWidth;
                FruitPhone.inst.maxGlassesHeight = newHeight;
            } else if (this.dragTarget == DragTarget.OVERLAY_POSITION) {
                int movementX = mouseX - this.lastMouseX;
                int movementY = mouseY - this.lastMouseY;
                Gravity g = FruitPhone.inst.glassesGravity;
                int resolvedX = g.resolveX(movementX, 0, 0);
                int resolvedY = g.resolveY(movementY, 0, 0);
                if (g.isHorizontalCenter()) {
                    resolvedX = movementX;
                }
                if (g.isVerticalCenter()) {
                    resolvedY = movementY;
                }
                int newX = this.dragX += resolvedX;
                int newY = this.dragY += resolvedY;
                if (!g.isHorizontalCenter() && newX < 0) {
                    newX = 0;
                    this.dragSnappedX = true;
                }
                if (!g.isVerticalCenter() && newY < 0) {
                    newY = 0;
                    this.dragSnappedY = true;
                }
                this.dragSnapped = false;
                this.dragSnappedX = false;
                this.dragSnappedY = false;
                int tolerance = 2;
                if (this.snapToGuides) {
                    tolerance = 5;
                    if (Math.abs(newX - 10) < tolerance) {
                        newX = 10;
                        this.dragSnappedX = true;
                    }
                    if (Math.abs(newY - 10) < tolerance) {
                        newY = 10;
                        this.dragSnappedY = true;
                    }
                    if (g.isCorner() && Math.abs(newX - newY) < tolerance) {
                        newX = newY;
                        this.dragSnappedX = true;
                        this.dragSnappedY = true;
                    }
                }
                if (!g.isHorizontalCenter()) {
                    if (Math.abs(newX + this.objWidth / 2 - this.field_146294_l / 2) < tolerance) {
                        this.dragGravity = g.getHorizontalCenter();
                        this.dragSnapped = true;
                        this.dragX = 0;
                        newX = 0;
                    }
                } else if (Math.abs(newX) > tolerance) {
                    this.dragGravity = newX > 0 ? g.eastmost() : g.westmost();
                    this.dragX = newX = this.field_146294_l / 2 - this.objWidth / 2 - Math.abs(newX);
                } else {
                    this.dragSnapped = true;
                }
                if (!g.isVerticalCenter()) {
                    if (Math.abs(newY + this.objHeight / 2 - this.field_146295_m / 2) < tolerance) {
                        this.dragGravity = g.getVerticalCenter();
                        this.dragSnapped = true;
                        this.dragY = 0;
                        newY = 0;
                    }
                } else if (Math.abs(newY) > tolerance) {
                    this.dragGravity = newY > 0 ? g.southmost() : g.northmost();
                    this.dragY = newY = this.field_146295_m / 2 - this.objHeight / 2 - Math.abs(newY);
                } else {
                    this.dragSnapped = true;
                }
                if (newX > this.field_146294_l / 2) {
                    this.dragGravity = g.flipHorizontal();
                    newX -= this.objWidth;
                    this.dragX -= this.objWidth;
                }
                if (newY > this.field_146295_m / 2) {
                    this.dragGravity = g.flipVertical();
                    newY -= this.objHeight;
                    this.dragY -= this.objHeight;
                }
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                if (FruitPhone.inst.glassesGravity != this.dragGravity) {
                    FruitPhone.inst.glassesGravity = this.dragGravity;
                    this.func_73866_w_();
                }
                FruitPhone.inst.glassesXOffset = newX;
                FruitPhone.inst.glassesYOffset = newY;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            this.dragTarget = null;
        }
    }

    private static enum DragTarget {
        OVERLAY_SIZE,
        OVERLAY_POSITION,
        CLAMP_REGION_SIZE;

    }
}

