/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.network;

import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.capability.FruitEquipmentCapability;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class EquipmentDataPacket
extends Message {
    @MarshalledAs(value="i32")
    public int entityId;
    public NBTTagCompound tag;

    public EquipmentDataPacket(NetworkContext ctx) {
        super(ctx);
    }

    public EquipmentDataPacket(int entityId, NBTTagCompound tag) {
        super(FruitPhone.inst.NETWORK);
        this.entityId = entityId;
        this.tag = tag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        Entity entity = sender.field_70170_p.func_73045_a(this.entityId);
        if (entity.hasCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)) {
            ((FruitEquipmentCapability)entity.getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)).deserializeNBT(this.tag);
        }
    }

    public static Optional<EquipmentDataPacket> forEntity(Entity e) {
        if (e.hasCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)) {
            FruitEquipmentCapability fec = (FruitEquipmentCapability)e.getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null);
            return Optional.of(new EquipmentDataPacket(e.func_145782_y(), fec.serializeNBT()));
        }
        return Optional.empty();
    }
}

