/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.network;

import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.Marshaller;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.UnitDictionary;
import com.elytradev.probe.api.impl.ProbeData;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ProbeDataMarshaller
implements Marshaller<IProbeData> {
    public static final String NAME = "com.elytradev.fruitphone.network.ProbeDataMarshaller";
    public static final ProbeDataMarshaller INSTANCE = new ProbeDataMarshaller();
    private static final int BAR_BIT = 1;
    private static final int LABEL_BIT = 2;
    private static final int INVENTORY_BIT = 4;
    private static final int BAR_UNIT_BIT = 8;

    @Override
    public void marshal(ByteBuf out, IProbeData t) {
        int bits = 0;
        boolean bar = t.hasBar();
        boolean label = t.hasLabel();
        boolean inventory = t.hasInventory();
        boolean barHasUnit = false;
        if (bar) {
            boolean bl = barHasUnit = t.getBarUnit() != null;
        }
        if (bar) {
            bits |= 1;
        }
        if (label) {
            bits |= 2;
        }
        if (inventory) {
            bits |= 4;
        }
        if (barHasUnit) {
            bits |= 8;
        }
        out.writeByte(bits);
        if (bar) {
            out.writeDouble(t.getBarMinimum());
            out.writeDouble(t.getBarCurrent());
            out.writeDouble(t.getBarMaximum());
            if (barHasUnit) {
                ByteBufUtils.writeUTF8String((ByteBuf)out, (String)t.getBarUnit().getFullName());
            }
        }
        if (label) {
            ByteBufUtils.writeUTF8String((ByteBuf)out, (String)ITextComponent.Serializer.func_150696_a((ITextComponent)t.getLabel()));
        }
        if (inventory) {
            ImmutableList inv = t.getInventory();
            ByteBufUtils.writeVarInt((ByteBuf)out, (int)inv.size(), (int)5);
            for (ItemStack is : inv) {
                ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)is);
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)is.func_190916_E(), (int)5);
            }
        }
    }

    @Override
    public IProbeData unmarshal(ByteBuf in) {
        short bits = in.readUnsignedByte();
        boolean bar = (bits & 1) != 0;
        boolean label = (bits & 2) != 0;
        boolean inventory = (bits & 4) != 0;
        boolean barHasUnit = (bits & 8) != 0;
        ProbeData pd = new ProbeData();
        if (bar) {
            pd.withBar(in.readDouble(), in.readDouble(), in.readDouble(), barHasUnit ? UnitDictionary.getInstance().getUnit(ByteBufUtils.readUTF8String((ByteBuf)in)) : null);
        }
        if (label) {
            pd.withLabel(ITextComponent.Serializer.func_150699_a((String)ByteBufUtils.readUTF8String((ByteBuf)in)));
        }
        if (inventory) {
            int size = ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
            Object[] stacks = new ItemStack[size];
            for (int i = 0; i < size; ++i) {
                ItemStack is = ByteBufUtils.readItemStack((ByteBuf)in);
                is.func_190920_e(ByteBufUtils.readVarInt((ByteBuf)in, (int)5));
                stacks[i] = is;
            }
            pd.withInventory(ImmutableList.copyOf((Object[])stacks));
        }
        return pd;
    }
}

