/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.proxy;

import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.FruitRenderer;
import com.elytradev.fruitphone.Gravity;
import com.elytradev.fruitphone.capability.FruitEquipmentCapability;
import com.elytradev.fruitphone.client.gui.ScreenConfigureGlasses;
import com.elytradev.fruitphone.client.render.LayerFruitGlass;
import com.elytradev.fruitphone.item.FruitItems;
import com.elytradev.fruitphone.item.ItemFruit;
import com.elytradev.fruitphone.item.ItemFruitPassive;
import com.elytradev.fruitphone.proxy.Proxy;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.common.Rendering;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.accessor.Accessors;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.invoker.Invoker;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.invoker.Invokers;
import com.google.common.base.MoreObjects;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends Proxy {
    private static boolean isServerVanilla = false;
    public boolean alwaysOn = false;
    public static float ticks;
    public static float partialTicks;
    public static float ticksConsiderPaused;
    private final Accessor<Float> equippedProgressMainHand = Accessors.findField(ItemRenderer.class, "field_187469_f", "equippedProgressMainHand", "f");
    private final Accessor<Float> equippedProgressOffHand = Accessors.findField(ItemRenderer.class, "field_187471_h", "equippedProgressOffHand", "h");
    private final Accessor<Float> prevEquippedProgressMainHand = Accessors.findField(ItemRenderer.class, "field_187470_g", "prevEquippedProgressMainHand", "g");
    private final Accessor<Float> prevEquippedProgressOffHand = Accessors.findField(ItemRenderer.class, "field_187472_i", "prevEquippedProgressOffHand", "i");
    private final Invoker setLightmap = Invokers.findMethod(ItemRenderer.class, "setLightmap", "func_187464_b", new Class[0]);
    private final Invoker rotateArroundXAndY = Invokers.findMethod(ItemRenderer.class, "rotateArroundXAndY", "func_178101_a", Float.TYPE, Float.TYPE);
    private final Invoker transformSideFirstPerson = Invokers.findMethod(ItemRenderer.class, "transformSideFirstPerson", "func_187459_b", EnumHandSide.class, Float.TYPE);
    private final Invoker transformFirstPerson = Invokers.findMethod(ItemRenderer.class, "transformFirstPerson", "func_187453_a", EnumHandSide.class, Float.TYPE);
    private final Invoker rotateArm = Invokers.findMethod(ItemRenderer.class, "rotateArm", "func_187458_c", Float.TYPE);
    private final Invoker applyBobbing = Invokers.findMethod(EntityRenderer.class, "applyBobbing", "func_78475_f", Float.TYPE);
    private final Invoker hurtCameraEffect = Invokers.findMethod(EntityRenderer.class, "hurtCameraEffect", "func_78482_e", Float.TYPE);
    private Framebuffer fb;

    @Override
    public void postInit() {
        super.postInit();
        if (!FruitPhone.inst.optionalMode) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> ((ItemFruit)stack.func_77973_b()).getColor(stack), new Item[]{FruitItems.HANDHELD, FruitItems.PASSIVE});
            RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
            Map renders = manager.getSkinMap();
            for (RenderPlayer render : renders.values()) {
                render.func_177094_a((LayerRenderer)new LayerFruitGlass(render.func_177087_b().field_78116_c));
            }
        }
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        if (!FruitPhone.inst.optionalMode) {
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.HANDHELD, (int)0, (ModelResourceLocation)new ModelResourceLocation("fruitphone:handheld#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.HANDHELD, (int)1, (ModelResourceLocation)new ModelResourceLocation("fruitphone:handheld_mini#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.HANDHELD, (int)2, (ModelResourceLocation)new ModelResourceLocation("fruitphone:handheld_portrait#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.HANDHELD, (int)3, (ModelResourceLocation)new ModelResourceLocation("fruitphone:handheld_portrait_mini#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.PASSIVE, (int)0, (ModelResourceLocation)new ModelResourceLocation("fruitphone:passive#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.PASSIVE, (int)1, (ModelResourceLocation)new ModelResourceLocation("fruitphone:passive_invisible#inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)FruitItems.REMOVER, (int)0, (ModelResourceLocation)new ModelResourceLocation("fruitphone:remover#inventory"));
        }
    }

    @Override
    public void configureGlasses() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new ScreenConfigureGlasses());
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            partialTicks = e.renderTickTime;
            ticks = (float)((int)ticks) + e.renderTickTime;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ticksConsiderPaused = (float)((int)ticksConsiderPaused) + e.renderTickTime;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks += 1.0f;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ticksConsiderPaused += 1.0f;
            }
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        isServerVanilla = !e.getConnectionType().equals("MODDED");
    }

    @SubscribeEvent
    public void onRenderHud(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (Minecraft.func_71410_x().field_71462_r instanceof ScreenConfigureGlasses) {
                return;
            }
            ItemStack glasses = null;
            if (FruitPhone.inst.optionalMode || this.alwaysOn || !ClientProxy.doesServerHaveMod() || Minecraft.func_71410_x().field_71439_g.hasCapability(FruitPhone.CAPABILITY_EQUIPMENT, null) && !(glasses = ((FruitEquipmentCapability)Minecraft.func_71410_x().field_71439_g.getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)).glasses).func_190926_b()) {
                int color = -1;
                if (glasses != null && glasses.func_77973_b() instanceof ItemFruitPassive) {
                    ItemFruitPassive item = (ItemFruitPassive)glasses.func_77973_b();
                    color = item.getColor(glasses);
                }
                Gravity g = FruitPhone.inst.glassesGravity;
                int xOfs = FruitPhone.inst.glassesXOffset;
                int yOfs = FruitPhone.inst.glassesYOffset;
                float confScale = FruitPhone.inst.glassesScale;
                int maxWidth = (int)((float)e.getResolution().func_78326_a() * FruitPhone.inst.maxGlassesWidth / confScale);
                int maxHeight = (int)((float)e.getResolution().func_78328_b() * FruitPhone.inst.maxGlassesHeight / confScale);
                GlStateManager.func_179094_E();
                FruitRenderer.MultiDataSize mds = FruitRenderer.calculateAndSyncTarget(90, 50, maxWidth, maxHeight);
                if (mds.clamped.getWidth() > 0 && mds.clamped.getHeight() > 0) {
                    float scale = FruitRenderer.getContainScale(mds.clamped.getWidth(), mds.clamped.getHeight(), mds.actual.getWidth(), mds.actual.getHeight());
                    float xScale = 1.0f;
                    float yScale = 1.0f;
                    if (mds.clamped.getWidth() < mds.clamped.getHeight()) {
                        xScale = scale;
                    } else if (mds.clamped.getHeight() < mds.clamped.getWidth()) {
                        yScale = scale;
                    } else {
                        xScale = yScale = scale;
                    }
                    int objWidth = (int)((float)mds.clamped.getWidth() * (xScale *= confScale)) + 10;
                    int objHeight = (int)((float)mds.clamped.getHeight() * (yScale *= confScale)) + 10;
                    int x = g.resolveX(xOfs, e.getResolution().func_78326_a(), objWidth);
                    int y = g.resolveY(yOfs, e.getResolution().func_78328_b(), objHeight);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    Gui.func_73734_a((int)0, (int)0, (int)objWidth, (int)objHeight, (int)color);
                    Gui.func_73734_a((int)1, (int)1, (int)(objWidth - 1), (int)(objHeight - 1), (int)-15984331);
                    GlStateManager.func_179109_b((float)5.0f, (float)5.0f, (float)40.0f);
                    GlStateManager.func_179152_a((float)confScale, (float)confScale, (float)1.0f);
                    FruitRenderer.renderAndSyncTarget(mds.clamped.getWidth(), mds.clamped.getHeight(), true, mds.actual);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    public static boolean doesServerHaveMod() {
        return Item.field_150901_e.func_177774_c((Object)FruitItems.PASSIVE) != null && !isServerVanilla;
    }

    @SubscribeEvent
    public void onRenderHand(RenderSpecificHandEvent e) {
        if (FruitPhone.inst.optionalMode) {
            return;
        }
        if (e.getItemStack() != null && e.getItemStack().func_77973_b() == FruitItems.HANDHELD) {
            FruitRenderer.DataSize ds;
            float equippedProgress;
            float prevEquippedProgress;
            EnumHandSide handSide;
            Minecraft mc = Minecraft.func_71410_x();
            e.setCanceled(true);
            GlStateManager.func_179121_F();
            this.hurtCameraEffect.invoke(mc.field_71460_t, Float.valueOf(partialTicks));
            EntityPlayerSP p = mc.field_71439_g;
            EnumHand hand = e.getHand();
            ItemRenderer ir = mc.func_175597_ag();
            boolean isMain = hand == EnumHand.MAIN_HAND;
            EnumHandSide enumHandSide = handSide = isMain ? p.func_184591_cq() : p.func_184591_cq().func_188468_a();
            if (isMain) {
                prevEquippedProgress = this.prevEquippedProgressMainHand.get(ir).floatValue();
                equippedProgress = this.equippedProgressMainHand.get(ir).floatValue();
            } else {
                prevEquippedProgress = this.prevEquippedProgressOffHand.get(ir).floatValue();
                equippedProgress = this.equippedProgressOffHand.get(ir).floatValue();
            }
            float swingProgress = p.func_70678_g(partialTicks);
            EnumHand swingingHand = (EnumHand)MoreObjects.firstNonNull((Object)p.field_184622_au, (Object)EnumHand.MAIN_HAND);
            float interpPitch = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * partialTicks;
            float interpYaw = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * partialTicks;
            float swing = swingingHand == hand ? swingProgress : 0.0f;
            float equip = 1.0f - (prevEquippedProgress + (equippedProgress - prevEquippedProgress) * partialTicks);
            this.rotateArroundXAndY.invoke(ir, Float.valueOf(interpPitch), Float.valueOf(interpYaw));
            this.setLightmap.invoke(ir, new Object[0]);
            this.rotateArm.invoke(ir, Float.valueOf(partialTicks));
            GlStateManager.func_179091_B();
            GlStateManager.func_179094_E();
            FruitRenderer.DataSize portraitSize = FruitRenderer.calculateAndSyncTargetUnclamped(50, 90, 50, 90);
            FruitRenderer.DataSize landscapeSize = FruitRenderer.calculateAndSyncTargetUnclamped(90, 50, 90, 50);
            float portraitContain = FruitRenderer.getContainScale(50, 90, portraitSize.getWidth(), portraitSize.getHeight());
            float landscapeContain = FruitRenderer.getContainScale(90, 50, landscapeSize.getWidth(), landscapeSize.getHeight());
            boolean portraitMode = false;
            if (portraitContain > landscapeContain) {
                portraitMode = true;
                ds = portraitSize;
            } else {
                ds = landscapeSize;
            }
            float screenAspect = (float)mc.field_71440_d / (float)mc.field_71443_c;
            if (screenAspect > 0.5625f) {
                float dist = screenAspect - 0.5625f;
                if (handSide == EnumHandSide.RIGHT) {
                    dist *= -1.0f;
                }
                GlStateManager.func_179109_b((float)dist, (float)0.0f, (float)0.0f);
            }
            ItemStack is = e.getItemStack();
            if (portraitMode) {
                is = is.func_77946_l();
                is.func_77964_b(is.func_77952_i() + 2);
            }
            ir.func_187457_a((AbstractClientPlayer)p, partialTicks, interpPitch, hand, swing, is, equip);
            ItemCameraTransforms.TransformType transform = handSide == EnumHandSide.RIGHT ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            IBakedModel model = mc.func_175599_af().func_184393_a(is, (World)mc.field_71441_e, (EntityLivingBase)p);
            float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * (float)Math.PI));
            float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * ((float)Math.PI * 2)));
            float f2 = -0.2f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
            int i = isMain ? 1 : -1;
            GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
            this.transformSideFirstPerson.invoke(ir, handSide, Float.valueOf(equip));
            this.transformFirstPerson.invoke(ir, handSide, Float.valueOf(swing));
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transform, (handSide == EnumHandSide.LEFT ? 1 : 0) != 0);
            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.03225f);
            GlStateManager.func_179139_a((double)0.00625, (double)-0.00625, (double)1.0E-6f);
            float oldLightmapX = OpenGlHelper.lastBrightnessX;
            float oldLightmapY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179109_b((float)30.0f, (float)50.0f, (float)40.0f);
            Gui.func_73734_a((int)0, (int)0, (int)100, (int)60, (int)-2011746716);
            GlStateManager.func_179109_b((float)5.0f, (float)5.0f, (float)40.0f);
            if (ds.getWidth() > 0 && ds.getWidth() > 0) {
                if (OpenGlHelper.func_148822_b()) {
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179094_E();
                    int size = (int)((double)Math.max(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d) * 0.3);
                    if (this.fb == null || this.fb.field_147621_c != size) {
                        if (this.fb != null) {
                            this.fb.func_147608_a();
                        }
                        this.fb = new Framebuffer(size, size, true);
                        this.fb.func_147607_a(9729);
                    } else {
                        this.fb.func_147610_a(true);
                    }
                    GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179086_m((int)16640);
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179130_a((double)0.0, (double)90.0, (double)90.0, (double)0.0, (double)1000.0, (double)3000.0);
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                    if (portraitMode) {
                        FruitRenderer.renderAndSyncTarget(50, 90, false, ds);
                    } else {
                        FruitRenderer.renderAndSyncTarget(90, 50, false, ds);
                    }
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179128_n((int)5889);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    this.fb.func_147612_c();
                    if (portraitMode) {
                        if (handSide == EnumHandSide.RIGHT) {
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GlStateManager.func_179109_b((float)0.0f, (float)-90.0f, (float)0.0f);
                        } else {
                            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GlStateManager.func_179109_b((float)-50.0f, (float)0.0f, (float)0.0f);
                        }
                    }
                    Rendering.drawTexturedRect(0.0, 0.0, 90.0, 90.0, 1.0f, 0.0f, 0.0f, 1.0f, -1);
                } else if (portraitMode) {
                    if (handSide == EnumHandSide.RIGHT) {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-90.0f, (float)0.0f);
                    } else {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)-50.0f, (float)0.0f, (float)0.0f);
                    }
                    FruitRenderer.renderAndSyncTarget(50, 90, false, ds);
                } else {
                    FruitRenderer.renderAndSyncTarget(90, 50, false, ds);
                }
            }
            if (!OpenGlHelper.func_148822_b()) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b("LEGACY MODE", 40, 56, ~Minecraft.func_71410_x().getItemColors().func_186728_a(is, 0));
            }
            GL11.glEnable((int)2896);
            GlStateManager.func_179145_e();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)oldLightmapX, (float)oldLightmapY);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            this.setLightmap.invoke(ir, new Object[0]);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179094_E();
            this.hurtCameraEffect.invoke(mc.field_71460_t, Float.valueOf(partialTicks));
            if (mc.field_71474_y.field_74336_f) {
                this.applyBobbing.invoke(mc.field_71460_t, Float.valueOf(partialTicks));
            }
        }
    }
}

