/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.recipe;

import com.elytradev.fruitphone.item.FruitItems;
import com.elytradev.fruitphone.recipe.FruitUpgradeRecipe;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FruitRecipes {
    public static List<Integer> craftableColors = Lists.newArrayList();

    @SubscribeEvent
    public static void register(RegistryEvent.Register<IRecipe> registryEvent) {
        IForgeRegistry registry = registryEvent.getRegistry();
        OreDictionary.registerOre((String)"blockObsidian", (Block)Blocks.field_150343_Z);
        OreDictionary.registerOre((String)"clay", (Item)Items.field_151119_aD);
        OreDictionary.registerOre((String)"listAllfruit", (Item)Items.field_151034_e);
        OreDictionary.registerOre((String)"listAllfruit", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"listAllfruit", (Item)Items.field_185161_cS);
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "create_handheld"), FruitItems.HANDHELD, "ingotIron", "listAllfruit"));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "create_passive"), FruitItems.PASSIVE, "/ /", "ghg", Character.valueOf('/'), "ingotIron", Character.valueOf('g'), "blockGlass", Character.valueOf('h'), new ItemStack((Item)FruitItems.HANDHELD, 1, Short.MAX_VALUE)));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "convert_pad_phone"), new ItemStack((Item)FruitItems.HANDHELD, 1, 0), "p", Character.valueOf('p'), new ItemStack((Item)FruitItems.HANDHELD, 1, 1)));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "convert_phone_pad"), new ItemStack((Item)FruitItems.HANDHELD, 1, 1), "p", Character.valueOf('p'), new ItemStack((Item)FruitItems.HANDHELD, 1, 0)));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "convert_glasses_contacts"), new ItemStack((Item)FruitItems.PASSIVE, 1, 0), "p", Character.valueOf('p'), new ItemStack((Item)FruitItems.PASSIVE, 1, 1)));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "convert_contacts_glasses"), new ItemStack((Item)FruitItems.PASSIVE, 1, 1), "p", Character.valueOf('p'), new ItemStack((Item)FruitItems.PASSIVE, 1, 0)));
        registry.register((IForgeRegistryEntry)new FruitUpgradeRecipe(new ResourceLocation("fruitphone", "create_remover"), FruitItems.REMOVER, "i ", "/w", Character.valueOf('/'), "stickWood", Character.valueOf('w'), "plankWood", Character.valueOf('i'), "ingotIron"));
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 0x2C2D2D, "ingotTungsten");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 0x2C2D2D, "dyeBlack", "ingotIron");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 3288388, "blockObsidian");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 3288388, "dyeBlack", "dyePurple");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 0xCDCDCD, "ingotSilver");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 0xCDCDCD, "dyeLightGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 0xFFFFFF, "dyeWhite");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11621747, "dustRedstone");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11621747, "dyeRed", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11294102, "dyeMagenta", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 8933804, "cropLavender");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 8933804, "dyePurple", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 5593009, "dyeBlue", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 5605809, "ingotSteel");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 5605809, "dyeLightBlue", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 5614001, "dyeGreen", "dyeCyan", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 5615504, "dyeCyan", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 7582037, "dyeGreen", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 10268757, "dyeLime", "dyeGreen", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 12102221, "dustSulfur");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 12102221, "dustSulphur");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 12102221, "dyeYellow", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11633237, "dyeBrown", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11629397, "clay");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11629397, "dyeBrown", "dyeOrange", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11490388, "dyeRed", "dyeGray");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16580685, "dustGlowstone", "dyeRed");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 14876927, "dustGlowstone", "dyeMagenta");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 10223871, "dustGlowstone", "dyePurple");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 1776620, "dustGlowstone", "dyeBlue");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 30975, "dustGlowstone", "dyeLightBlue");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 47871, "dustGlowstone", "dyeCyan");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 65484, "dustGlowstone", "dyeLime");
        Item misc = Item.func_111206_d((String)"correlated:misc");
        if (misc != null) {
            ItemStack lum = new ItemStack(misc, 1, 3);
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 65484, lum);
        } else {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 65484, "dustGlowstone", "enderpearl");
        }
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 9174784, "dustGlowstone", "dyeGreen");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13434368, "dustGlowstone", "dyeLime", "dyeLime");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16180992, "dustGlowstone", "cropMustard");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16180992, "dustGlowstone", "seedMustard");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16180992, "dustGlowstone", "dyeYellow", "dyeBrown");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16696577, "dustGlowstone", "dyeYellow");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16751616, "dustGlowstone", "dyeOrange");
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 16735232, "dustGlowstone", "dyeOrange", "dyeRed");
        if (FruitRecipes.doesOreExist("ingotCopper")) {
            if (FruitRecipes.doesOreExist("ingotSilver")) {
                FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "ingotGold", "ingotSilver", "ingotCopper");
                FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "dustGold", "dustSilver", "dustCopper");
            } else {
                FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "ingotGold", "ingotCopper");
                FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "dustGold", "dustCopper");
            }
        } else {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "ingotGold", "dyeRed");
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 15713983, "dustGold", "dyeRed");
        }
        if (FruitRecipes.doesOreExist("ingotPlatinum")) {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "ingotPlatinum");
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "dustPlatinum");
        } else if (FruitRecipes.doesOreExist("ingotSilver")) {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "ingotSilver", "gemDiamond");
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "dustSilver", "gemDiamond");
        } else {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "ingotIron", "gemDiamond", "gemDiamond");
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 13226706, "dustIron", "gemDiamond", "gemDiamond");
        }
        if (FruitRecipes.doOresExist("cropTomato", "cropChilipepper", "cropGarlic", "foodVinegar")) {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11738626, "cropTomato", "cropChilipepper", "cropGarlic", "foodVinegar");
        } else if (FruitRecipes.doOresExist("cropTomato", "cropGarlic")) {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11738626, "cropTomato", "cropGarlic");
        } else {
            FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 11738626, "dyeRed", "dyeRed", "dyeRed");
        }
        FruitRecipes.colorRecipe((IForgeRegistry<IRecipe>)registry, 2458740, "enderpearl");
    }

    private static boolean doesOreExist(String ore) {
        return !OreDictionary.getOres((String)ore, (boolean)false).isEmpty();
    }

    private static boolean doOresExist(String ... ores) {
        for (String s : ores) {
            if (FruitRecipes.doesOreExist(s)) continue;
            return false;
        }
        return true;
    }

    private static void colorRecipe(IForgeRegistry<IRecipe> registry, int color, Object ... ingredients) {
        if (!craftableColors.contains(color)) {
            craftableColors.add(color);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("fruitphone:color", color);
        ItemStack handheld = new ItemStack((Item)FruitItems.HANDHELD);
        ItemStack handheldMini = new ItemStack((Item)FruitItems.HANDHELD, 1, 1);
        ItemStack passive = new ItemStack((Item)FruitItems.PASSIVE);
        ItemStack passiveInvisible = new ItemStack((Item)FruitItems.PASSIVE, 1, 1);
        handheld.func_77982_d(tag.func_74737_b());
        handheldMini.func_77982_d(tag.func_74737_b());
        passive.func_77982_d(tag.func_74737_b());
        passiveInvisible.func_77982_d(tag.func_74737_b());
        Object[] handheldIngredients = new Object[ingredients.length + 1];
        Object[] handheldMiniIngredients = new Object[ingredients.length + 1];
        Object[] passiveIngredients = new Object[ingredients.length + 1];
        Object[] passiveInvisibleIngredients = new Object[ingredients.length + 1];
        handheldIngredients[0] = FruitItems.HANDHELD;
        handheldMiniIngredients[0] = new ItemStack((Item)FruitItems.HANDHELD, 1, 1);
        passiveIngredients[0] = FruitItems.PASSIVE;
        passiveInvisibleIngredients[0] = new ItemStack((Item)FruitItems.PASSIVE, 1, 1);
        System.arraycopy(ingredients, 0, handheldIngredients, 1, ingredients.length);
        System.arraycopy(ingredients, 0, handheldMiniIngredients, 1, ingredients.length);
        System.arraycopy(ingredients, 0, passiveIngredients, 1, ingredients.length);
        System.arraycopy(ingredients, 0, passiveInvisibleIngredients, 1, ingredients.length);
        String suffix = String.valueOf(color);
        int variant = 0;
        while (registry.containsKey(new ResourceLocation("fruitphone", "dye_handheld_" + suffix))) {
            suffix = color + "_variant_" + variant;
            ++variant;
        }
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "dye_handheld_" + suffix), handheld, handheldIngredients));
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "dye_handheld_mini_" + suffix), handheldMini, handheldMiniIngredients));
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "dye_passive_" + suffix), passive, passiveIngredients));
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "dye_passive_invisible_" + suffix), passiveInvisible, passiveInvisibleIngredients));
        Object[] handheldDirectIngredients = new Object[ingredients.length + 2];
        handheldDirectIngredients[0] = "ingotIron";
        handheldDirectIngredients[1] = "listAllfruit";
        System.arraycopy(ingredients, 0, handheldDirectIngredients, 2, ingredients.length);
        registry.register((IForgeRegistryEntry)FruitRecipes.createOreRecipe(new ResourceLocation("fruitphone", "dye_direct_handheld_" + suffix), handheld, handheldDirectIngredients));
    }

    private static ShapelessOreRecipe createOreRecipe(ResourceLocation location, Item out, Object ... in) {
        return (ShapelessOreRecipe)new ShapelessOreRecipe(null, out, in).setRegistryName(location);
    }

    private static ShapelessOreRecipe createOreRecipe(ResourceLocation location, ItemStack out, Object ... in) {
        return (ShapelessOreRecipe)new ShapelessOreRecipe(null, out, in).setRegistryName(location);
    }
}

