/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.repackage.com.elytradev.concrete.common;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum EnumAnyRotation implements IStringSerializable
{
    NORTH_UP,
    NORTH_EAST,
    NORTH_WEST,
    NORTH_DOWN,
    EAST_UP,
    EAST_NORTH,
    EAST_SOUTH,
    EAST_DOWN,
    SOUTH_UP,
    SOUTH_WEST,
    SOUTH_EAST,
    SOUTH_DOWN,
    WEST_UP,
    WEST_SOUTH,
    WEST_NORTH,
    WEST_DOWN,
    UP_NORTH,
    UP_EAST,
    UP_SOUTH,
    UP_WEST,
    DOWN_NORTH,
    DOWN_EAST,
    DOWN_SOUTH,
    DOWN_WEST;

    public static final ImmutableList<EnumAnyRotation> VALUES;
    private final EnumFacing front;
    private final EnumFacing top;
    private final String lowerName;

    private EnumAnyRotation() {
        List split = Splitter.on((char)'_').splitToList((CharSequence)this.name());
        this.front = EnumFacing.valueOf((String)((String)split.get(0)));
        this.top = EnumFacing.valueOf((String)((String)split.get(1)));
        this.lowerName = this.name().toLowerCase(Locale.ROOT);
    }

    public String func_176610_l() {
        return this.lowerName;
    }

    public EnumFacing getFront() {
        return this.front;
    }

    public EnumFacing getTop() {
        return this.top;
    }

    public static EnumAnyRotation fromFrontTop(EnumFacing front, EnumFacing top) {
        for (EnumAnyRotation ear : VALUES) {
            if (ear.front != front || ear.top != top) continue;
            return ear;
        }
        throw new IllegalArgumentException(front + "_" + top + " is not a legal facing");
    }

    public static EnumAnyRotation fromDispenserFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST_UP;
            }
            case NORTH: {
                return NORTH_UP;
            }
            case SOUTH: {
                return SOUTH_UP;
            }
            case WEST: {
                return WEST_UP;
            }
            case UP: {
                return UP_NORTH;
            }
            case DOWN: {
                return DOWN_SOUTH;
            }
        }
        throw new AssertionError((Object)("missing case for " + facing));
    }

    public static EnumAnyRotation fromHorizontalFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST_UP;
            }
            case NORTH: {
                return NORTH_UP;
            }
            case SOUTH: {
                return SOUTH_UP;
            }
            case WEST: {
                return WEST_UP;
            }
        }
        throw new IllegalArgumentException(facing + " is not a valid horizontal facing");
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])EnumAnyRotation.values());
    }
}

