/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.repackage.com.elytradev.concrete.network;

import com.elytradev.fruitphone.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.common.MoreByteBufUtils;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.Marshaller;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class DefaultMarshallers {
    public static final Marshaller<? extends Number> UINT8 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeByte, ByteBuf::readUnsignedByte);
    public static final Marshaller<? extends Number> INT8 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeByte, ByteBuf::readByte);
    public static final Marshaller<? extends Number> UINT16 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeShort, ByteBuf::readUnsignedShort);
    public static final Marshaller<Character> CHAR = new CharacterMarshaller();
    public static final Marshaller<? extends Number> INT16 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeShort, ByteBuf::readShort);
    public static final Marshaller<? extends Number> UINT24 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeMedium, ByteBuf::readUnsignedMedium);
    public static final Marshaller<? extends Number> INT24 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeMedium, ByteBuf::readMedium);
    public static final Marshaller<? extends Number> UINT32 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeInt, ByteBuf::readUnsignedInt);
    public static final Marshaller<? extends Number> INT32 = DefaultMarshallers.weld(Number::intValue, ByteBuf::writeInt, ByteBuf::readInt);
    public static final Marshaller<? extends Number> INT64 = DefaultMarshallers.weld(Number::longValue, ByteBuf::writeLong, ByteBuf::readLong);
    public static final Marshaller<? extends Number> FLOAT = DefaultMarshallers.weld(Number::floatValue, ByteBuf::writeFloat, ByteBuf::readFloat);
    public static final Marshaller<? extends Number> DOUBLE = DefaultMarshallers.weld(Number::doubleValue, ByteBuf::writeDouble, ByteBuf::readDouble);
    public static final Marshaller<? extends Number> VARINT = new VarIntMarshaller();
    public static final Marshaller<? extends Number> VARINT_ZIGZAG = new VarIntZigZagMarshaller();
    public static final Marshaller<NBTTagCompound> NBT = DefaultMarshallers.weld(ByteBufUtils::writeTag, ByteBufUtils::readTag);
    public static final Marshaller<BlockPos> BLOCKPOS = new BlockPosMarshaller();
    public static final Marshaller<String> STRING = DefaultMarshallers.weld(ByteBufUtils::writeUTF8String, ByteBufUtils::readUTF8String);
    public static final Marshaller<ItemStack> ITEMSTACK = DefaultMarshallers.weld(ByteBufUtils::writeItemStack, ByteBufUtils::readItemStack);
    public static final Marshaller<? extends ByteBuf> BYTEBUF = new ByteBufMarshaller();
    private static final Map<String, Marshaller<?>> byName = Maps.newHashMap();

    private static void put(Marshaller<?> m, String ... names) {
        for (String name : names) {
            byName.put(name, m);
        }
    }

    private static <F, R extends Number> Marshaller<? extends Number> weld(final Function<Number, F> converter, final Serializer<F> serializer, final Deserializer<R> deserializer) {
        return new Marshaller<Number>(){

            @Override
            public void marshal(ByteBuf out, Number number) {
                serializer.serialize(out, converter.apply(number));
            }

            @Override
            public R unmarshal(ByteBuf in) {
                return (Number)deserializer.deserialize(in);
            }
        };
    }

    private static <T> Marshaller<T> weld(final Serializer<T> serializer, final Deserializer<T> deserializer) {
        return new Marshaller<T>(){

            @Override
            public void marshal(ByteBuf out, T t) {
                serializer.serialize(out, t);
            }

            @Override
            public T unmarshal(ByteBuf in) {
                return deserializer.deserialize(in);
            }
        };
    }

    public static <T> Marshaller<T> getByName(String name) {
        Marshaller marshaller;
        block9: {
            if (name.endsWith("-list")) {
                Marshaller<T> m = DefaultMarshallers.getByName(name = name.substring(0, name.length() - 5));
                if (m != null) {
                    return new ListMarshaller<T>(m);
                }
                return null;
            }
            if (byName.containsKey(name.toLowerCase(Locale.ROOT))) {
                return byName.get(name.toLowerCase(Locale.ROOT));
            }
            marshaller = null;
            try {
                Class<?> clazz = Class.forName(name);
                if (!Marshaller.class.isAssignableFrom(clazz)) break block9;
                try {
                    Field inst = clazz.getDeclaredField("INSTANCE");
                    inst.setAccessible(true);
                    marshaller = (Marshaller)inst.get(null);
                }
                catch (Exception e) {
                    ConcreteLog.warn(clazz.getName() + " does not appear to define an INSTANCE field, but it should");
                }
                if (marshaller != null) break block9;
                try {
                    Constructor<?> cons = clazz.getConstructor(new Class[0]);
                    marshaller = (Marshaller)cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new BadMessageException("Cannot instanciate marshaller class " + clazz.getName());
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return marshaller;
    }

    public static <T> Marshaller<T> getByType(Class<T> type) {
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return CHAR;
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return FLOAT;
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return DOUBLE;
        }
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (BlockPos.class.isAssignableFrom(type)) {
            return BLOCKPOS;
        }
        if (NBTTagCompound.class.isAssignableFrom(type)) {
            return NBT;
        }
        if (type.isEnum()) {
            return new EnumMarshaller<T>(type);
        }
        if (ItemStack.class.isAssignableFrom(type)) {
            return ITEMSTACK;
        }
        if (ByteBuf.class.isAssignableFrom(type)) {
            return BYTEBUF;
        }
        return null;
    }

    private DefaultMarshallers() {
    }

    static {
        DefaultMarshallers.put(UINT8, "u8", "uint8", "ubyte");
        DefaultMarshallers.put(INT8, "i8", "int8", "byte");
        DefaultMarshallers.put(UINT16, "u16", "uint16", "ushort");
        DefaultMarshallers.put(CHAR, "char");
        DefaultMarshallers.put(INT16, "i16", "int16", "short");
        DefaultMarshallers.put(UINT24, "u24", "uint24", "umedium");
        DefaultMarshallers.put(INT24, "i24", "int24", "medium");
        DefaultMarshallers.put(UINT32, "u32", "uint32", "uint", "uinteger");
        DefaultMarshallers.put(INT32, "i32", "int32", "int", "integer");
        DefaultMarshallers.put(INT64, "i64", "int64", "long");
        DefaultMarshallers.put(FLOAT, "f32", "float");
        DefaultMarshallers.put(DOUBLE, "f64", "double");
        DefaultMarshallers.put(VARINT, "varint");
        DefaultMarshallers.put(VARINT_ZIGZAG, "varint-zigzag", "zigzag");
        DefaultMarshallers.put(NBT, "nbt");
        DefaultMarshallers.put(BLOCKPOS, "blockpos");
        DefaultMarshallers.put(STRING, "string", "str", "utf8");
        DefaultMarshallers.put(ITEMSTACK, "item", "stack", "itemstack");
    }

    private static interface Deserializer<T> {
        public T deserialize(ByteBuf var1);
    }

    private static interface Serializer<T> {
        public void serialize(ByteBuf var1, T var2);
    }

    private static class CharacterMarshaller
    implements Marshaller<Character> {
        private CharacterMarshaller() {
        }

        @Override
        public Character unmarshal(ByteBuf in) {
            return Character.valueOf(in.readChar());
        }

        @Override
        public void marshal(ByteBuf out, Character t) {
            out.writeChar((int)t.charValue());
        }
    }

    private static class ByteBufMarshaller
    implements Marshaller<ByteBuf> {
        private ByteBufMarshaller() {
        }

        @Override
        public ByteBuf unmarshal(ByteBuf in) {
            int length = ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
            return in.readBytes(length);
        }

        @Override
        public void marshal(ByteBuf out, ByteBuf t) {
            if (t != null) {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)t.readableBytes(), (int)5);
                out.writeBytes(t.readBytes(t.readableBytes()));
            } else {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)0, (int)5);
            }
        }
    }

    private static class EnumMarshaller<T extends Enum<T>>
    implements Marshaller<T> {
        private final Class<T> clazz;
        private final T[] constants;

        public EnumMarshaller(Class<T> clazz) {
            this.clazz = clazz;
            this.constants = (Enum[])clazz.getEnumConstants();
        }

        @Override
        public T unmarshal(ByteBuf in) {
            int ordinal = this.constants.length < 256 ? in.readUnsignedByte() : (this.constants.length < 65536 ? in.readUnsignedShort() : (this.constants.length < 0x1000000 ? in.readUnsignedMedium() : Ints.checkedCast((long)in.readUnsignedInt())));
            return this.constants[ordinal];
        }

        @Override
        public void marshal(ByteBuf out, T t) {
            if (this.constants.length < 256) {
                out.writeByte(((Enum)t).ordinal());
            } else if (this.constants.length < 65536) {
                out.writeShort(((Enum)t).ordinal());
            } else if (this.constants.length < 0x1000000) {
                out.writeMedium(((Enum)t).ordinal());
            } else {
                out.writeInt(((Enum)t).ordinal());
            }
        }
    }

    private static class VarIntZigZagMarshaller
    implements Marshaller<Number> {
        private VarIntZigZagMarshaller() {
        }

        @Override
        public Number unmarshal(ByteBuf in) {
            return MoreByteBufUtils.readZigZagVarInt(in, 5);
        }

        @Override
        public void marshal(ByteBuf out, Number t) {
            MoreByteBufUtils.writeZigZagVarInt(out, t.intValue(), 5);
        }
    }

    private static class VarIntMarshaller
    implements Marshaller<Number> {
        private VarIntMarshaller() {
        }

        @Override
        public Number unmarshal(ByteBuf in) {
            return ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
        }

        @Override
        public void marshal(ByteBuf out, Number t) {
            ByteBufUtils.writeVarInt((ByteBuf)out, (int)t.intValue(), (int)5);
        }
    }

    private static class BlockPosMarshaller
    implements Marshaller<BlockPos> {
        private BlockPosMarshaller() {
        }

        @Override
        public BlockPos unmarshal(ByteBuf in) {
            return BlockPos.func_177969_a((long)in.readLong());
        }

        @Override
        public void marshal(ByteBuf out, BlockPos t) {
            out.writeLong(t.func_177986_g());
        }
    }

    public static class ListMarshaller<T>
    implements Marshaller<List<T>> {
        private final Marshaller<T> underlying;

        public ListMarshaller(Marshaller<T> underlying) {
            this.underlying = underlying;
        }

        @Override
        public List<T> unmarshal(ByteBuf in) {
            int size = ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
            ArrayList li = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                li.add(this.underlying.unmarshal(in));
            }
            return li;
        }

        @Override
        public void marshal(ByteBuf out, List<T> li) {
            if (li == null) {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)0, (int)5);
            } else {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)li.size(), (int)5);
                for (T t : li) {
                    this.underlying.marshal(out, t);
                }
            }
        }
    }
}

