/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.accessor;

import com.elytradev.fruitphone.repackage.com.elytradev.concrete.reflect.accessor.Accessor;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class MethodHandlesAccessor<T>
implements Accessor<T> {
    private final MethodHandle getter;
    private final MethodHandle setter;

    public MethodHandlesAccessor(Field f) {
        try {
            f.setAccessible(true);
            this.getter = MethodHandles.publicLookup().unreflectGetter(f);
            this.setter = MethodHandles.publicLookup().unreflectSetter(f);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public MethodHandlesAccessor(Method get, Method set) {
        try {
            get.setAccessible(true);
            set.setAccessible(true);
            this.getter = MethodHandles.publicLookup().unreflect(get);
            this.setter = MethodHandles.publicLookup().unreflect(set);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public T get(Object owner) {
        try {
            if (owner == null) {
                return (T)this.getter.invoke();
            }
            return (T)this.getter.invoke(owner);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void set(Object owner, T value) {
        try {
            if (owner == null) {
                this.setter.invoke(value);
            } else {
                this.setter.invoke(owner, value);
            }
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

