/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.vanilla;

import com.elytradev.fruitphone.vanilla.BeaconDataProvider;
import com.elytradev.fruitphone.vanilla.FurnaceDataProvider;
import com.elytradev.fruitphone.vanilla.JukeboxDataProvider;
import com.elytradev.fruitphone.vanilla.MobSpawnerDataProvider;
import com.elytradev.fruitphone.vanilla.NoteBlockDataProvider;
import com.elytradev.fruitphone.vanilla.VanillaDataProvider;
import com.elytradev.probe.api.IProbeData;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockJukebox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;

public class VanillaProviders {
    public static final VanillaDataProvider EMPTY_PROVIDER = (te, li) -> {};
    private static final Map<Class<? extends TileEntity>, VanillaDataProvider> map = Maps.newHashMap();

    public static <T extends TileEntity> VanillaDataProvider<T> getProvider(T te) {
        if (te == null) {
            return EMPTY_PROVIDER;
        }
        if (map.containsKey(te.getClass())) {
            return map.get(te.getClass());
        }
        return EMPTY_PROVIDER;
    }

    public static <T extends TileEntity> void provideProbeData(T te, List<IProbeData> li) {
        VanillaProviders.getProvider(te).provideProbeData(te, li);
    }

    static {
        map.put(TileEntityFurnace.class, new FurnaceDataProvider());
        map.put(BlockJukebox.TileEntityJukebox.class, new JukeboxDataProvider());
        map.put(TileEntityNote.class, new NoteBlockDataProvider());
        map.put(TileEntityBeacon.class, new BeaconDataProvider());
        map.put(TileEntityMobSpawner.class, new MobSpawnerDataProvider());
    }
}

