/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone;

import cofh.api.energy.IEnergyStorage;
import com.elytradev.fruitphone.FruitEquipmentProperties;
import com.elytradev.fruitphone.FruitPhone$$Lambda$1;
import com.elytradev.fruitphone.FruitPhone$$Lambda$2;
import com.elytradev.fruitphone.FruitPhone$$Lambda$3;
import com.elytradev.fruitphone.FruitPhone$$Lambda$4;
import com.elytradev.fruitphone.GameRulePoller;
import com.elytradev.fruitphone.Gravity;
import com.elytradev.fruitphone.compat.waila.WailaCompat;
import com.elytradev.fruitphone.item.FruitItems;
import com.elytradev.fruitphone.network.EquipmentDataPacket;
import com.elytradev.fruitphone.network.ProbeDataPacket;
import com.elytradev.fruitphone.network.SetAlwaysOnPacket;
import com.elytradev.fruitphone.proxy.ClientProxy;
import com.elytradev.fruitphone.proxy.Proxy;
import com.elytradev.fruitphone.recipe.FruitRecipes;
import com.elytradev.fruitphone.recipe.FruitUpgradeRecipe;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.NetworkContext;
import com.elytradev.fruitphone.vanilla.VanillaProviders;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.IProbeDataProvider;
import com.elytradev.probe.api.IUnit;
import com.elytradev.probe.api.UnitDictionary;
import com.elytradev.probe.api.impl.ProbeData;
import com.elytradev.probe.api.impl.SIUnit;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="fruitphone", name="Fruit Phone", version="1.7.10-0.1.7-exp1", dependencies="after:Waila")
public class FruitPhone {
    public static final String MODID = "fruitphone";
    public static final String NAME = "Fruit Phone";
    public static final String VERSION = "1.7.10-0.1.7-exp1";
    public static final String DEPENDENCIES = "after:Waila";
    public static final Logger log = LogManager.getLogger((String)"FruitPhone");
    public static CreativeTabs tab = new CreativeTabs("fruitphone"){
        private ItemStack icon;

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            int iTicks;
            if (this.icon == null) {
                this.icon = new ItemStack((Item)FruitItems.HANDHELD);
                this.icon.func_77982_d(new NBTTagCompound());
            }
            if ((iTicks = (int)ClientProxy.ticks) % 20 == 0) {
                int col = FruitRecipes.craftableColors.get(iTicks / 20 % FruitRecipes.craftableColors.size());
                this.icon.func_77978_p().func_74768_a("fruitphone:color", col);
            }
            return this.icon;
        }

        public Item func_78016_d() {
            return FruitItems.HANDHELD;
        }
    };
    @SidedProxy(clientSide="com.elytradev.fruitphone.proxy.ClientProxy", serverSide="com.elytradev.fruitphone.proxy.Proxy")
    public static Proxy proxy;
    @Mod.Instance
    public static FruitPhone inst;
    public Configuration config;
    public Gravity glassesGravity;
    public int glassesXOffset;
    public int glassesYOffset;
    public float maxGlassesWidth;
    public float maxGlassesHeight;
    public float glassesScale;
    public boolean optionalMode;
    public boolean disableWaila;
    public boolean showWailaInformation;
    public boolean synthesizeProbeInformation;
    public NetworkContext NETWORK;
    private final Field classToNameMap = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"field_145853_j", "classToNameMap", "g"});
    private Map<EntityPlayer, ProbeDataPacket> lastData = new WeakHashMap<EntityPlayer, ProbeDataPacket>();

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        this.config = new Configuration(e.getSuggestedConfigurationFile());
        this.optionalMode = this.config.getBoolean("optional", "General", false, "Don't register any items or blocks. If set to true on a server,\nFruit Phone will not be required to connect to the server. If\nset to true on a client, Fruit Phone will pretend you're\nwearing glasses at all times. Since this disables all of Fruit\nPhone's items, if you try to enable this on the client and\nconnect to a server with it disabled, you will get a 'Fatally\nmissing blocks and items' error and will not be able to connect.\n\nNot required to connect to servers that don't have Fruit\nPhone. The mod will pretend you're wearing glasses when\nconnected to servers that lack the mod.\n\nIf you just want to have the mod pretend you're wearing Fruit\nGlass at all times, use /gamerule fruitphone:alwaysOn true\n\n");
        this.disableWaila = this.config.getBoolean("disableWaila", "General", true, "If true and Waila is installed, Fruit Phone will disable it. Automatically turned off on first run.");
        this.showWailaInformation = this.config.getBoolean("showWailaInformation", "General", true, "If true and Waila is installed, Fruit Phone will display information from Waila plugins.");
        this.synthesizeProbeInformation = this.config.getBoolean("synthesizeProbeInformation", "General", true, "If true, Fruit Phone will look for known interfaces and add probe data (e.g. bars) for them. 1.7.10 exclusive option.");
        Gravity[] grav = Gravity.values();
        String[] valid = new String[grav.length];
        for (int i = 0; i < valid.length; ++i) {
            valid[i] = grav[i].toString();
        }
        this.glassesGravity = Gravity.valueOf(this.config.getString("gravity", "Glasses", "north_west", "The gravity for the glasses overlay.", valid).toUpperCase(Locale.ROOT));
        this.glassesXOffset = this.config.getInt("xOffset", "Glasses", 10, 0, 65535, "The X offset for the glasses overlay, dependent on gravity");
        this.glassesYOffset = this.config.getInt("yOffset", "Glasses", 10, 0, 65535, "The Y offset for the glasses overlay, dependent on gravity");
        this.maxGlassesWidth = this.config.getFloat("maxWidth", "Glasses", 33.333332f, 0.0f, 100.0f, "The maximum width for the glasses overlay, as a percentage of the screen width") / 100.0f;
        this.maxGlassesHeight = this.config.getFloat("maxHeight", "Glasses", 66.666664f, 0.0f, 100.0f, "The maximum height for the glasses overlay, as a percentage of the screen height") / 100.0f;
        this.glassesScale = this.config.getFloat("scale", "Glasses", 100.0f, 0.0f, 100000.0f, "The scale for the glasses overlay, as a percentage of the default") / 100.0f;
        this.config.setCategoryComment("Glasses", "Configuration for the glasses overlay. This can be configured ingame much more easily with the Power Drill.");
        if (!Loader.isModLoaded((String)"Waila")) {
            this.showWailaInformation = false;
            this.disableWaila = false;
        }
        this.config.save();
        if (!this.optionalMode) {
            RecipeSorter.register((String)"fruitphone:upgrade", FruitUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
            FruitItems.register();
            FruitRecipes.register();
            proxy.preInit();
        }
        this.NETWORK = NetworkContext.forChannel("FruitPhone").register(EquipmentDataPacket.class).register(SetAlwaysOnPacket.class).register(ProbeDataPacket.class);
        FMLCommonHandler.instance().bus().register((Object)proxy);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void saveConfig() {
        this.config.get("Glasses", "gravity", "north_west").set(this.glassesGravity.toString());
        this.config.get("Glasses", "xOffset", 10).set(this.glassesXOffset);
        this.config.get("Glasses", "yOffset", 10).set(this.glassesYOffset);
        this.config.get("Glasses", "maxWidth", 33.33333206176758).set((double)(this.maxGlassesWidth * 100.0f));
        this.config.get("Glasses", "maxHeight", 66.66666412353516).set((double)(this.maxGlassesHeight * 100.0f));
        this.config.get("Glasses", "scale", 100.0).set((double)(this.glassesScale * 100.0f));
        this.config.get("General", "optional", false).set(this.optionalMode);
        this.config.save();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        UnitDictionary dict = UnitDictionary.getInstance();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            SIUnit fluidUnit = new SIUnit("buckets_" + fluid.getName(), "B", fluid.getColor());
            dict.register(fluidUnit, fluid);
        }
        proxy.postInit();
        if (this.disableWaila) {
            WailaCompat.init();
            this.config.get("General", "disableWaila", true).set(false);
            this.config.save();
        }
    }

    @NetworkCheckHandler
    public boolean onConnectionOffered(Map<String, String> mods, Side offerer) {
        if (this.optionalMode) {
            return true;
        }
        if (offerer == Side.SERVER) {
            return true;
        }
        return mods.containsKey(MODID) && VERSION.equals(mods.get(MODID));
    }

    @SubscribeEvent
    public void onConstruct(EntityEvent.EntityConstructing e) {
        if (this.optionalMode) {
            return;
        }
        if (e.entity instanceof EntityPlayer) {
            e.entity.registerExtendedProperties("fruitphone:equipment", (IExtendedEntityProperties)new FruitEquipmentProperties());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking e) {
        EquipmentDataPacket.forEntity(e.target).transform(FruitPhone$$Lambda$1.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        new SetAlwaysOnPacket(e.player.field_70170_p.func_82736_K().func_82766_b("fruitphone:alwaysOn")).sendTo(e.player);
        EquipmentDataPacket.forEntity((Entity)e.player).transform(FruitPhone$$Lambda$2.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.world.func_82736_K().func_82766_b("fruitphone:alwaysOn")) {
            e.world.func_82736_K().func_82769_a("fruitphone:alwaysOn", "false");
        }
        World world = e.world;
        GameRulePoller.forBooleanRule("fruitphone:alwaysOn", world, FruitPhone$$Lambda$3.lambdaFactory$(world));
    }

    @SubscribeEvent
    public void onSwitchDimensions(PlayerEvent.PlayerChangedDimensionEvent e) {
        new SetAlwaysOnPacket(e.player.field_70170_p.func_82736_K().func_82766_b("fruitphone:alwaysOn")).sendTo(e.player);
        EquipmentDataPacket.forEntity((Entity)e.player).transform(FruitPhone$$Lambda$4.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone e) {
        if (!e.wasDeath) {
            FruitEquipmentProperties orig = (FruitEquipmentProperties)e.original.getExtendedProperties("fruitphone:equipment");
            FruitEquipmentProperties nw = (FruitEquipmentProperties)e.entityPlayer.getExtendedProperties("fruitphone:equipment");
            nw.glasses = orig.glasses;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            if (e.player.field_70170_p.field_72995_K) {
                return;
            }
            Vec3 eyes = Vec3.func_72443_a((double)e.player.field_70165_t, (double)(e.player.field_70163_u + (double)e.player.func_70047_e()), (double)e.player.field_70161_v);
            Vec3 look = e.player.func_70040_Z();
            double dist = 4.0;
            Vec3 max = eyes.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
            MovingObjectPosition rtr = e.player.field_70170_p.func_147447_a(eyes, max, false, false, false);
            if (rtr != null && rtr.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ArrayList list = Lists.newArrayList();
                int x = rtr.field_72311_b;
                int y = rtr.field_72312_c;
                int z = rtr.field_72309_d;
                TileEntity te = e.player.field_70170_p.func_147438_o(x, y, z);
                if (te != null) {
                    NBTTagCompound tag = this.generateProbeData(e.player, te, ForgeDirection.getOrientation((int)rtr.field_72310_e), list);
                    ProbeDataPacket pkt = new ProbeDataPacket(x, y, z, list, tag);
                    if (!Objects.equal((Object)pkt, (Object)this.lastData.get(e.player))) {
                        pkt.sendTo(e.player);
                    }
                    this.lastData.put(e.player, pkt);
                } else {
                    this.lastData.remove(e.player);
                }
            }
        }
    }

    public NBTTagCompound generateProbeData(EntityPlayer player, TileEntity te, ForgeDirection sideHit, List<IProbeData> list) {
        NBTTagCompound tag;
        block24: {
            tag = new NBTTagCompound();
            try {
                Map classToNameMap;
                if (!(player instanceof EntityPlayerMP) || !this.showWailaInformation) break block24;
                try {
                    classToNameMap = (Map)this.classToNameMap.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasBlockOrTile = false;
                if (ModuleRegistrar.instance().hasNBTProviders((Object)te.func_145838_q())) {
                    hasBlockOrTile = true;
                }
                if (ModuleRegistrar.instance().hasNBTProviders((Object)te)) {
                    hasBlockOrTile = true;
                }
                if (hasBlockOrTile) {
                    tag.func_74768_a("x", te.field_145851_c);
                    tag.func_74768_a("y", te.field_145848_d);
                    tag.func_74768_a("z", te.field_145849_e);
                    tag.func_74778_a("id", (String)classToNameMap.get(te.getClass()));
                    for (List li : ModuleRegistrar.instance().getNBTProviders((Object)te.func_145838_q()).values()) {
                        for (IWailaDataProvider iwdp : li) {
                            tag = iwdp.getNBTData((EntityPlayerMP)player, te, tag, player.field_70170_p, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                        }
                    }
                    for (List li : ModuleRegistrar.instance().getNBTProviders((Object)te).values()) {
                        for (IWailaDataProvider iwdp : li) {
                            tag = iwdp.getNBTData((EntityPlayerMP)player, te, tag, player.field_70170_p, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                        }
                    }
                }
                tag.func_74768_a("WailaX", te.field_145851_c);
                tag.func_74768_a("WailaY", te.field_145848_d);
                tag.func_74768_a("WailaZ", te.field_145849_e);
                tag.func_74778_a("WailaID", (String)classToNameMap.get(te.getClass()));
            }
            catch (Throwable t) {
                log.warn("Exception thrown while building Waila data for {}, {}, {} in DIM{}", new Object[]{te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g, t});
                tag = new NBTTagCompound();
                list.add(new ProbeData().withLabel((IChatComponent)new ChatComponentTranslation("fruitphone.wailaError", new Object[0])));
            }
        }
        if (!this.synthesizeProbeInformation) {
            return tag;
        }
        try {
            if (te instanceof IProbeDataProvider) {
                ((IProbeDataProvider)te).provideProbeData(list);
                return tag;
            }
        }
        catch (Throwable t) {
            log.warn("Exception thrown while building probe data for {}, {}, {} in DIM{}", new Object[]{te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g, t});
            list.clear();
            list.add(new ProbeData().withLabel((IChatComponent)new ChatComponentTranslation("fruitphone.probeError", new Object[0])));
            return new NBTTagCompound();
        }
        try {
            VanillaProviders.provideProbeData(te, list);
            if (te instanceof TileEntityChest) {
                TileEntityChest c = (TileEntityChest)te;
                Block b = te.func_145838_q();
                if (b instanceof BlockChest) {
                    c.func_145979_i();
                    this.addItemData(list, ((BlockChest)b).func_149951_m(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e));
                } else {
                    this.addItemData(list, (IInventory)te);
                }
            } else if (te instanceof IInventory) {
                this.addItemData(list, (IInventory)te);
            }
            if (te instanceof IEnergyStorage) {
                this.addEnergyData(list, (IEnergyStorage)te);
            }
            if (te instanceof IFluidHandler) {
                this.addFluidData(list, (IFluidHandler)te);
            }
            return tag;
        }
        catch (Throwable t) {
            log.warn("Exception thrown while building default probe data for {}, {}, {} in DIM{}", new Object[]{te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g, t});
            list.clear();
            list.add(new ProbeData().withLabel((IChatComponent)new ChatComponentTranslation("fruitphone.capError", new Object[0])));
            return new NBTTagCompound();
        }
    }

    private void addItemData(List<IProbeData> list, IInventory item) {
        ArrayList is = Lists.newArrayListWithCapacity((int)item.func_70302_i_());
        for (int i = 0; i < item.func_70302_i_(); ++i) {
            ItemStack stack = item.func_70301_a(i);
            is.add(stack == null ? null : stack.func_77946_l());
        }
        list.add(new ProbeData().withInventory(is));
    }

    private void addFluidData(List<IProbeData> list, IFluidHandler fluid) {
        for (FluidTankInfo tank : fluid.getTankInfo(ForgeDirection.UNKNOWN)) {
            int amt;
            IUnit unit;
            if (tank.fluid == null) {
                unit = UnitDictionary.BUCKETS_ANY;
                amt = 0;
            } else {
                unit = UnitDictionary.getInstance().getUnit(tank.fluid.getFluid());
                amt = tank.fluid.amount;
            }
            list.add(new ProbeData().withBar(0.0, (double)amt / 1000.0, (double)tank.capacity / 1000.0, unit));
        }
    }

    private void addEnergyData(List<IProbeData> list, IEnergyStorage energy) {
        list.add(new ProbeData().withBar(0.0, energy.getEnergyStored(), energy.getMaxEnergyStored(), UnitDictionary.FORGE_ENERGY));
    }

    @SubscribeEvent
    public void onDrops(PlayerDropsEvent e) {
        if (this.optionalMode) {
            return;
        }
        FruitEquipmentProperties props = (FruitEquipmentProperties)e.entityPlayer.getExtendedProperties("fruitphone:equipment");
        ItemStack glasses = props.glasses;
        if (glasses != null) {
            e.entityPlayer.func_70099_a(glasses, 1.2f);
        }
    }

    private static /* synthetic */ Class lambda$onSwitchDimensions$3(PlayerEvent.PlayerChangedDimensionEvent e, EquipmentDataPacket m) {
        m.sendTo(e.player);
        return Void.TYPE;
    }

    private static /* synthetic */ void lambda$onWorldLoad$2(World world, Boolean newValue) {
        log.info("Always-on mode {}abled", new Object[]{newValue != false ? "en" : "dis"});
        new SetAlwaysOnPacket(newValue).sendToAllIn(world);
    }

    private static /* synthetic */ Class lambda$onPlayerJoin$1(PlayerEvent.PlayerLoggedInEvent e, EquipmentDataPacket m) {
        m.sendTo(e.player);
        return Void.TYPE;
    }

    private static /* synthetic */ Class lambda$onStartTracking$0(PlayerEvent.StartTracking e, EquipmentDataPacket m) {
        m.sendTo(e.entityPlayer);
        return Void.TYPE;
    }

    static /* synthetic */ Class access$lambda$0(PlayerEvent.StartTracking startTracking, EquipmentDataPacket equipmentDataPacket) {
        return FruitPhone.lambda$onStartTracking$0(startTracking, equipmentDataPacket);
    }

    static /* synthetic */ Class access$lambda$1(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent, EquipmentDataPacket equipmentDataPacket) {
        return FruitPhone.lambda$onPlayerJoin$1(playerLoggedInEvent, equipmentDataPacket);
    }

    static /* synthetic */ void access$lambda$2(World world, Boolean bl) {
        FruitPhone.lambda$onWorldLoad$2(world, bl);
    }

    static /* synthetic */ Class access$lambda$3(PlayerEvent.PlayerChangedDimensionEvent playerChangedDimensionEvent, EquipmentDataPacket equipmentDataPacket) {
        return FruitPhone.lambda$onSwitchDimensions$3(playerChangedDimensionEvent, equipmentDataPacket);
    }
}

