/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone;

import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.FruitProbeData;
import com.elytradev.fruitphone.WailaProbeData;
import com.elytradev.fruitphone.client.render.Rendering;
import com.elytradev.fruitphone.proxy.ClientProxy;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.UnitDictionary;
import com.elytradev.probe.api.impl.ProbeData;
import com.elytradev.probe.api.impl.SIUnit;
import com.elytradev.probe.api.impl.Unit;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TipList;
import mcp.mobius.waila.cbcore.Layout;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FruitRenderer {
    private static final ResourceLocation SPINNER = new ResourceLocation("fruitphone", "textures/gui/spinner.png");
    private static final ResourceLocation SLOT = new ResourceLocation("fruitphone", "textures/gui/slot.png");
    public static boolean hasData = false;
    public static int currentDataPosX;
    public static int currentDataPosY;
    public static int currentDataPosZ;
    public static List<IProbeData> currentFormattedData;
    public static List<IProbeData> currentRawData;
    private static final Unit DUMMY_UNIT;
    private static Object mdp;

    public static void renderAndSyncTarget(int width, int height, boolean lit) {
        DataSize preferred = FruitRenderer.calculateAndSyncTargetUnclamped(width, height, width, height);
        FruitRenderer.renderAndSyncTarget(width, height, lit, preferred);
    }

    public static void renderAndSyncTarget(int width, int height, boolean lit, DataSize preferred) {
        GL11.glPushMatrix();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Vec3 eyes = player.func_70666_h(1.0f).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3 look = player.func_70676_i(ClientProxy.partialTicks);
        double dist = 4.0;
        Vec3 max = eyes.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        MovingObjectPosition rtr = player.field_70170_p.func_147447_a(eyes, max, false, false, false);
        if (rtr == null || rtr.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        int x = rtr.field_72311_b;
        int y = rtr.field_72312_c;
        int z = rtr.field_72309_d;
        if (!hasData || x != currentDataPosX || y != currentDataPosY || z != currentDataPosZ) {
            Block b = world.func_147439_a(x, y, z);
            if (FruitRenderer.isBlacklisted(b)) {
                return;
            }
            int meta = world.func_72805_g(x, y, z);
            if (!b.hasTileEntity(meta)) {
                hasData = true;
                currentDataPosX = x;
                currentDataPosY = y;
                currentDataPosZ = z;
                currentRawData = Collections.emptyList();
            } else {
                FruitRenderer.render(FruitRenderer.format(Collections.<IProbeData>emptyList(), x, y, z), width, height, lit, preferred);
                if (ClientProxy.doesServerHaveMod()) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glEnable((int)2929);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
                    FruitRenderer.renderSpinner(0, 0);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-500.0f);
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
                return;
            }
        }
        if (currentRawData != null) {
            currentFormattedData = FruitRenderer.format(currentRawData, currentDataPosX, currentDataPosY, currentDataPosZ);
            currentRawData = null;
        }
        FruitRenderer.render(currentFormattedData, width, height, lit, preferred);
        GL11.glPopMatrix();
    }

    public static MultiDataSize calculateAndSyncTarget(int preferredWidth, int preferredHeight, int maxWidth, int maxHeight) {
        DataSize actual = FruitRenderer.calculateAndSyncTargetUnclamped(preferredWidth, preferredHeight, maxWidth, maxHeight);
        DataSize clamped = new DataSize();
        clamped.setWidth(Math.min(maxWidth, actual.getWidth()));
        clamped.setHeight(Math.min(maxHeight, actual.getHeight()));
        return new MultiDataSize(clamped, actual);
    }

    public static DataSize calculateAndSyncTargetUnclamped(int preferredWidth, int preferredHeight, int maxWidth, int maxHeight) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Vec3 eyes = player.func_70666_h(1.0f).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3 look = player.func_70676_i(ClientProxy.partialTicks);
        double dist = 4.0;
        Vec3 max = eyes.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        MovingObjectPosition rtr = player.field_70170_p.func_147447_a(eyes, max, false, false, false);
        if (rtr == null || rtr.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return new DataSize();
        }
        int x = rtr.field_72311_b;
        int y = rtr.field_72312_c;
        int z = rtr.field_72309_d;
        if (!hasData || x != currentDataPosX || y != currentDataPosY || z != currentDataPosZ) {
            Block b = world.func_147439_a(x, y, z);
            if (FruitRenderer.isBlacklisted(b)) {
                return new DataSize();
            }
            int meta = world.func_72805_g(x, y, z);
            if (!b.hasTileEntity(meta)) {
                hasData = true;
                currentDataPosX = x;
                currentDataPosY = y;
                currentDataPosZ = z;
                currentRawData = Collections.emptyList();
            } else {
                return FruitRenderer.calculatePreferredDataSize(FruitRenderer.format(Collections.<IProbeData>emptyList(), x, y, z), preferredWidth, preferredHeight, maxWidth, maxHeight);
            }
        }
        if (currentRawData != null) {
            currentFormattedData = FruitRenderer.format(currentRawData, currentDataPosX, currentDataPosY, currentDataPosZ);
            currentRawData = null;
        }
        return FruitRenderer.calculatePreferredDataSize(currentFormattedData, preferredWidth, preferredHeight, maxWidth, maxHeight);
    }

    public static List<IProbeData> format(List<IProbeData> data, int srcX, int srcY, int srcZ) {
        ArrayList newData = Lists.newArrayList();
        Block b = Minecraft.func_71410_x().field_71441_e.func_147439_a(srcX, srcY, srcZ);
        if (FruitRenderer.isBlacklisted(b)) {
            return data;
        }
        ItemStack pickblock = b.getPickBlock(Minecraft.func_71410_x().field_71476_x, (World)Minecraft.func_71410_x().field_71441_e, srcX, srcY, srcZ, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        FruitProbeData ident = new FruitProbeData();
        if (pickblock != null) {
            ident.withInventory(Collections.singletonList(pickblock));
            ident.withLabel(pickblock.func_82833_r());
        }
        newData.add(ident);
        boolean first = true;
        for (IProbeData ipd : data) {
            if (ipd instanceof WailaProbeData) {
                newData.add(0, ipd);
            } else if (first && ipd.hasBar() && !ident.hasBar() && ipd.hasLabel() && ipd.getBarUnit() == null && !ipd.hasInventory()) {
                FruitProbeData nw = new FruitProbeData();
                ident.withBar(ipd.getBarMinimum(), ipd.getBarCurrent(), ipd.getBarMaximum(), ipd.getBarUnit());
                if (ipd.hasLabel()) {
                    if (ipd.getBarUnit() == null) {
                        ident.setBarLabel(ipd.getLabel().func_150254_d());
                    } else {
                        nw.withLabel(ipd.getLabel());
                    }
                }
                if (ipd.hasInventory()) {
                    nw.withInventory(ipd.getInventory());
                }
                newData.add(nw);
            } else {
                newData.add(ipd);
            }
            first = false;
        }
        return newData;
    }

    public static boolean isBlacklisted(Block b) {
        if (b == null) {
            return true;
        }
        return b.getClass().getName().startsWith("codechicken");
    }

    public static boolean isBlacklisted(TileEntity te) {
        if (te == null) {
            return false;
        }
        return te.getClass().getName().startsWith("codechicken");
    }

    public static DataSize calculatePreferredDataSize(List<IProbeData> data, int preferredWidth, int preferredHeight, int maxWidth, int maxHeight) {
        data = FruitRenderer.injectWailaData(data);
        DataSize ds = new DataSize();
        int x = 0;
        int y = 0;
        int slots = 0;
        boolean onlyOne = data.size() == 1;
        for (IProbeData d : data) {
            int lineSize = 0;
            if (!onlyOne) {
                y += 2;
            }
            boolean renderLabel = true;
            if (d.hasInventory() && !d.getInventory().isEmpty() && d.getInventory().get(0) != null && d.getInventory().size() == 1 && (d.hasLabel() || d.hasBar())) {
                ds.setWidthIfGreater(x + 16);
                y -= 2;
                x += 20;
                lineSize = Math.max(lineSize, 16);
            }
            if (d.hasBar()) {
                String str;
                if (d instanceof FruitProbeData && ((FruitProbeData)d).getBarLabel() != null) {
                    str = ((FruitProbeData)d).getBarLabel();
                } else if (d.hasLabel() && d.getBarUnit() == null) {
                    str = d.getLabel().func_150254_d();
                    renderLabel = false;
                } else {
                    str = d.getBarUnit() == null ? Unit.FORMAT_STANDARD.format(d.getBarCurrent()) : d.getBarUnit().format(d.getBarCurrent());
                }
                ds.setWidthIfGreater(preferredWidth);
                ds.setWidthIfGreater(x + 4 + Minecraft.func_71410_x().field_71466_p.func_78256_a(str));
                lineSize = Math.max(lineSize, d.hasLabel() ? 22 : 11);
            }
            if (renderLabel && d.hasLabel()) {
                ds.setWidthIfGreater(x + Minecraft.func_71410_x().field_71466_p.func_78256_a(d.getLabel().func_150254_d()));
                lineSize = Math.max(lineSize, 8);
            }
            if (d.hasInventory() && (!d.hasBar() && !d.hasLabel() || d.getInventory().size() > 1)) {
                y += lineSize + 2;
                if (d.getInventory().size() == 9) {
                    ds.setWidthIfGreater(54);
                    lineSize = 54;
                } else {
                    slots += d.getInventory().size();
                }
            }
            y += lineSize;
            x = 0;
        }
        ds.setWidthIfGreater(x);
        ds.setHeightIfGreater(y);
        int slotsPerRow = Math.max(Math.min(9, maxWidth / 18), 1);
        ds.setWidthIfGreater(x + (slots >= slotsPerRow ? 18 * slotsPerRow : 18 * slots));
        ds.addHeight(2 + slots / slotsPerRow * 18);
        if (slots % slotsPerRow > 0) {
            ds.addHeight(18);
        }
        return ds;
    }

    public static float getContainScale(int canvasWidth, int canvasHeight, int dataWidth, int dataHeight) {
        if (dataWidth <= canvasWidth && dataHeight <= canvasHeight) {
            return 1.0f;
        }
        return Math.min((float)canvasWidth / (float)dataWidth, (float)canvasHeight / (float)dataHeight);
    }

    public static void render(List<IProbeData> data, int width, int height, int maxWidth, int maxHeight, boolean glasses) {
        DataSize preferred = FruitRenderer.calculatePreferredDataSize(data, width, height, maxWidth, maxHeight);
        FruitRenderer.render(data, width, height, glasses, preferred);
    }

    public static void render(List<IProbeData> data, int width, int height, boolean glasses, DataSize preferred) {
        data = FruitRenderer.injectWailaData(data);
        float contain = FruitRenderer.getContainScale(width, height, preferred.width, preferred.height);
        if (!glasses) {
            preferred = FruitRenderer.calculatePreferredDataSize(data, (int)((float)width / contain), (int)((float)height / contain), (int)((float)width / contain), (int)((float)height / contain));
            contain = FruitRenderer.getContainScale(width, height, preferred.width, preferred.height);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            Gui.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)-16711936);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
        }
        GL11.glScalef((float)contain, (float)contain, (float)1.0f);
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            Gui.func_73734_a((int)0, (int)0, (int)preferred.width, (int)preferred.height, (int)-1426128896);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
        }
        int actualWidth = glasses ? width : (int)((float)width / contain);
        GL11.glEnable((int)32826);
        int x = 0;
        int y = 0;
        for (IProbeData d : data) {
            int lineSize = 0;
            int textPosY = y + 2;
            y += 2;
            boolean renderLabel = true;
            if (d.hasInventory() && !d.getInventory().isEmpty() && d.getInventory().get(0) != null) {
                RenderHelper.func_74520_c();
                if (d.getInventory().size() == 1 && (d.hasLabel() || d.hasBar())) {
                    RenderItem.getInstance().func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, d.getInventory().get(0), x, y - 2);
                    RenderItem.getInstance().func_94148_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, d.getInventory().get(0), x, y - 2, "");
                    x += 20;
                    textPosY = d.hasBar() ? (textPosY -= 2) : (textPosY += 2);
                    lineSize = Math.max(lineSize, 16);
                }
                RenderHelper.func_74518_a();
            }
            if (d.hasBar()) {
                String str;
                int barY = textPosY;
                if (d.hasLabel()) {
                    barY += 10;
                }
                double maxNormalized = d.getBarMaximum() - d.getBarMinimum();
                double currentNormalized = d.getBarCurrent() - d.getBarMinimum();
                double zero = d.getBarMinimum() < 0.0 ? -d.getBarMinimum() : 0.0;
                double startX = (double)(x + 1) + zero / maxNormalized * (double)(actualWidth - x - 2);
                double endX = (double)(x + 1) + currentNormalized / maxNormalized * (double)(actualWidth - x - 2);
                if (startX < (double)(x + 1)) {
                    startX = x + 1;
                } else if (startX > (double)(actualWidth - 1)) {
                    startX = actualWidth - 1;
                }
                if (endX > (double)(actualWidth - 1)) {
                    endX = actualWidth - 1;
                } else if (endX < (double)(x + 1)) {
                    endX = x + 1;
                }
                int color = d.getBarUnit() == null ? -5592406 : d.getBarUnit().getBarColor() | 0xFF000000;
                Rendering.drawRect(x, barY, actualWidth, barY + 11, -1);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
                Rendering.drawRect(x + 1, barY + 1, actualWidth - 1, barY + 10, -16777216);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
                if (d.getBarUnit() != null && UnitDictionary.getInstance().isFluid(d.getBarUnit())) {
                    Fluid f = UnitDictionary.getInstance().getFluid(d.getBarUnit());
                    IIcon tex = f.getStillIcon();
                    Rendering.bindTexture(TextureMap.field_110575_b);
                    int segments = (int)((endX - startX) / 16.0);
                    for (int i = 0; i < segments; ++i) {
                        Rendering.drawTexturedRect(startX + (double)(i * 16), barY + 1, startX + (double)((i + 1) * 16), barY + 10, tex);
                    }
                    Rendering.drawTexturedRect(startX + (double)(segments * 16), barY + 1, endX, barY + 10, tex);
                } else {
                    Rendering.drawRect(startX, (double)(barY + 1), endX, (double)(barY + 10), color);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)40.0f);
                if (d instanceof FruitProbeData && ((FruitProbeData)d).getBarLabel() != null) {
                    str = ((FruitProbeData)d).getBarLabel();
                } else if (d.hasLabel() && d.getBarUnit() == null) {
                    str = d.getLabel().func_150254_d();
                    renderLabel = false;
                } else {
                    str = d.getBarUnit() == null ? Unit.FORMAT_STANDARD.format(d.getBarCurrent()) : d.getBarUnit().format(d.getBarCurrent());
                }
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)775, (int)769, (int)770, (int)771);
                fr.func_85187_a(str, actualWidth - 1 - fr.func_78256_a(str), barY + 2, -1, false);
                GL11.glDisable((int)3042);
                lineSize = Math.max(lineSize, d.hasLabel() ? 22 : 11);
            }
            if (renderLabel && d.hasLabel()) {
                Minecraft.func_71410_x().field_71466_p.func_85187_a(d.getLabel().func_150254_d(), x, textPosY, -1, false);
                lineSize = Math.max(lineSize, 8);
            }
            if (d.hasInventory() && (!d.hasBar() && !d.hasLabel() || d.getInventory().size() > 1)) {
                y += lineSize + 2;
                lineSize = 0;
                int perRow = d.getInventory().size() == 9 ? 3 : Math.min(9, actualWidth / 18);
                int i = 0;
                for (ItemStack is : d.getInventory()) {
                    Rendering.bindTexture(SLOT);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
                    if (is != null) {
                        RenderHelper.func_74520_c();
                        int count = is.field_77994_a;
                        RenderItem.getInstance().func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, is, x + 1, y + 1);
                        RenderItem.getInstance().func_94148_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, is, x + 1, y + 1, count >= 100 ? "" : null);
                        RenderHelper.func_74518_a();
                        if (count >= 100) {
                            GL11.glPushMatrix();
                            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)400.0f);
                            String str = DUMMY_UNIT.format(count);
                            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                            fr.func_78261_a(str, x * 2 + 34 - fr.func_78256_a(str), y * 2 + 34 - fr.field_78288_b, -1);
                            GL11.glPopMatrix();
                        }
                    }
                    x += 18;
                    if (++i < perRow) continue;
                    i = 0;
                    x = 0;
                    y += 18;
                }
                if (i > 0) {
                    lineSize = 18;
                }
            }
            y += lineSize;
            x = 0;
        }
        GL11.glDisable((int)32826);
    }

    private static List<IProbeData> injectWailaData(List<IProbeData> data) {
        if (FruitPhone.inst.showWailaInformation) {
            ArrayList unchangedData = data;
            try {
                if (mdp == null) {
                    mdp = new MetaDataProvider();
                }
                MetaDataProvider mdp = (MetaDataProvider)FruitRenderer.mdp;
                data = Lists.newArrayList((Iterable)data);
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                DataAccessorCommon dac = DataAccessorCommon.instance;
                MovingObjectPosition rtr = Minecraft.func_71410_x().field_71476_x;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                NBTTagCompound wailaData = null;
                Iterator iter = data.iterator();
                while (iter.hasNext()) {
                    IProbeData ipd = (IProbeData)iter.next();
                    if (!(ipd instanceof WailaProbeData)) continue;
                    iter.remove();
                    wailaData = ((WailaProbeData)ipd).data;
                }
                dac.set((World)world, (EntityPlayer)player, rtr, null, (double)ClientProxy.partialTicks);
                dac.setNBTData(wailaData);
                ItemStack stack = mdp.identifyBlockHighlight((World)world, (EntityPlayer)player, rtr, dac);
                if (stack == null) {
                    stack = ((IProbeData)data.get(0)).hasInventory() ? ((IProbeData)data.get(0)).getInventory().get(0) : null;
                } else {
                    ((ProbeData)data.get(0)).withInventory(Collections.singletonList(stack)).withLabel(stack.func_82833_r());
                }
                List<String> wailaHead = Collections.emptyList();
                List wailaBody = mdp.handleBlockTextData(stack, (World)world, (EntityPlayer)player, rtr, dac, (List)new TipList(), Layout.BODY);
                List wailaTail = mdp.handleBlockTextData(stack, (World)world, (EntityPlayer)player, rtr, dac, (List)new TipList(), Layout.FOOTER);
                int idx = 1;
                for (String s : wailaHead) {
                    if ("<ERROR>".equals(s)) {
                        s = I18n.func_135052_a((String)"fruitphone.wailaError", (Object[])new Object[0]);
                    }
                    if (s.startsWith(SpecialChars.RENDER)) continue;
                    data.add(idx++, new ProbeData(s));
                }
                for (String s : wailaBody) {
                    if ("<ERROR>".equals(s)) {
                        s = I18n.func_135052_a((String)"fruitphone.wailaError", (Object[])new Object[0]);
                    }
                    if (s.startsWith(SpecialChars.RENDER)) continue;
                    data.add(idx++, new ProbeData(s));
                }
                for (String s : wailaTail) {
                    if ("<ERROR>".equals(s)) {
                        s = I18n.func_135052_a((String)"fruitphone.wailaError", (Object[])new Object[0]);
                    }
                    if (s.startsWith(SpecialChars.RENDER)) continue;
                    data.add(new ProbeData(s));
                }
            }
            catch (Throwable t) {
                data = Lists.newArrayList((Iterable)unchangedData);
                FruitPhone.log.info("Error while retreiving Waila data", t);
                unchangedData.add(new ProbeData((IChatComponent)new ChatComponentTranslation("fruitphone.wailaError", new Object[0])));
            }
        }
        return data;
    }

    public static void renderSpinner(int x, int y) {
        Rendering.bindTexture(SPINNER);
        int tocks = (int)(ClientProxy.ticksConsiderPaused / 2.0f);
        Gui.func_146110_a((int)x, (int)y, (float)(16 * tocks), (float)0.0f, (int)15, (int)16, (float)96.0f, (float)16.0f);
    }

    static {
        DUMMY_UNIT = new SIUnit("", "", 0, Unit.FORMAT_STANDARD, false);
    }

    public static class DataSize {
        private int width;
        private int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setWidthIfGreater(int width) {
            if (width > this.width) {
                this.width = width;
            }
        }

        public void addWidth(int width) {
            this.width += width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeightIfGreater(int height) {
            if (height > this.height) {
                this.height = height;
            }
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void addHeight(int height) {
            this.height += height;
        }
    }

    public static class MultiDataSize {
        public final DataSize clamped;
        public final DataSize actual;

        public MultiDataSize(DataSize clamped, DataSize actual) {
            this.clamped = clamped;
            this.actual = actual;
        }
    }
}

