/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone;

import java.util.Locale;

public enum Gravity {
    NORTH_WEST(0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f),
    NORTH(0.5f, 0.0f, -0.5f, 0.0f, 1.0f, 0.0f),
    NORTH_EAST(1.0f, -1.0f, -1.0f, 0.0f, 1.0f, 0.0f),
    WEST(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, -0.5f),
    CENTER(0.5f, 0.0f, -0.5f, 0.5f, 0.0f, -0.5f),
    EAST(1.0f, -1.0f, -1.0f, 0.5f, 0.0f, -0.5f),
    SOUTH_WEST(0.0f, 1.0f, 0.0f, 1.0f, -1.0f, -1.0f),
    SOUTH(0.5f, 0.0f, -0.5f, 1.0f, -1.0f, -1.0f),
    SOUTH_EAST(1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f);

    private final String lower = this.name().toLowerCase(Locale.ROOT);
    private final float xBase;
    private final float xMult;
    private final float xObjMult;
    private final float yBase;
    private final float yMult;
    private final float yObjMult;

    private Gravity(float xBase, float xMult, float xObjMult, float yBase, float yMult, float yObjMult) {
        this.xBase = xBase;
        this.xMult = xMult;
        this.xObjMult = xObjMult;
        this.yBase = yBase;
        this.yMult = yMult;
        this.yObjMult = yObjMult;
    }

    public boolean isCorner() {
        switch (this) {
            case CENTER: 
            case EAST: 
            case NORTH: 
            case WEST: 
            case SOUTH: {
                return false;
            }
            case NORTH_EAST: 
            case NORTH_WEST: 
            case SOUTH_EAST: 
            case SOUTH_WEST: {
                return true;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity getHorizontalCenter() {
        switch (this) {
            case CENTER: {
                return CENTER;
            }
            case EAST: {
                return CENTER;
            }
            case NORTH: {
                return NORTH;
            }
            case NORTH_EAST: {
                return NORTH;
            }
            case NORTH_WEST: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case SOUTH_EAST: {
                return SOUTH;
            }
            case SOUTH_WEST: {
                return SOUTH;
            }
            case WEST: {
                return CENTER;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public boolean isHorizontalCenter() {
        return this.getHorizontalCenter() == this;
    }

    public Gravity getVerticalCenter() {
        switch (this) {
            case CENTER: {
                return CENTER;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return CENTER;
            }
            case NORTH_EAST: {
                return EAST;
            }
            case NORTH_WEST: {
                return WEST;
            }
            case SOUTH: {
                return CENTER;
            }
            case SOUTH_EAST: {
                return EAST;
            }
            case SOUTH_WEST: {
                return WEST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public boolean isVerticalCenter() {
        return this.getVerticalCenter() == this;
    }

    public Gravity westmost() {
        switch (this) {
            case CENTER: {
                return WEST;
            }
            case EAST: {
                return WEST;
            }
            case NORTH: {
                return NORTH_WEST;
            }
            case NORTH_EAST: {
                return NORTH_WEST;
            }
            case NORTH_WEST: {
                return NORTH_WEST;
            }
            case SOUTH: {
                return SOUTH_WEST;
            }
            case SOUTH_EAST: {
                return SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return SOUTH_WEST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity eastmost() {
        switch (this) {
            case CENTER: {
                return EAST;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH_EAST;
            }
            case NORTH_EAST: {
                return NORTH_EAST;
            }
            case NORTH_WEST: {
                return NORTH_EAST;
            }
            case SOUTH: {
                return SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return SOUTH_EAST;
            }
            case SOUTH_WEST: {
                return SOUTH_EAST;
            }
            case WEST: {
                return EAST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity northmost() {
        switch (this) {
            case CENTER: {
                return NORTH;
            }
            case EAST: {
                return NORTH_EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case NORTH_EAST: {
                return NORTH_EAST;
            }
            case NORTH_WEST: {
                return NORTH_WEST;
            }
            case SOUTH: {
                return NORTH_WEST;
            }
            case SOUTH_EAST: {
                return NORTH_WEST;
            }
            case SOUTH_WEST: {
                return NORTH_WEST;
            }
            case WEST: {
                return NORTH_WEST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity southmost() {
        switch (this) {
            case CENTER: {
                return SOUTH;
            }
            case EAST: {
                return SOUTH_EAST;
            }
            case NORTH: {
                return SOUTH_EAST;
            }
            case NORTH_EAST: {
                return SOUTH_EAST;
            }
            case NORTH_WEST: {
                return SOUTH_EAST;
            }
            case SOUTH: {
                return SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return SOUTH_EAST;
            }
            case SOUTH_WEST: {
                return SOUTH_EAST;
            }
            case WEST: {
                return SOUTH_WEST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity opposite() {
        return this.flipHorizontal().flipVertical();
    }

    public Gravity flipHorizontal() {
        switch (this) {
            case CENTER: {
                return CENTER;
            }
            case EAST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case NORTH_EAST: {
                return NORTH_WEST;
            }
            case NORTH_WEST: {
                return NORTH_EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case SOUTH_EAST: {
                return SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return SOUTH_EAST;
            }
            case WEST: {
                return EAST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public Gravity flipVertical() {
        switch (this) {
            case CENTER: {
                return CENTER;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return SOUTH;
            }
            case NORTH_EAST: {
                return SOUTH_EAST;
            }
            case NORTH_WEST: {
                return SOUTH_WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case SOUTH_EAST: {
                return NORTH_EAST;
            }
            case SOUTH_WEST: {
                return NORTH_WEST;
            }
            case WEST: {
                return WEST;
            }
        }
        throw new AssertionError((Object)("Missing case for " + (Object)((Object)this)));
    }

    public int resolveX(int xofs, int width, int objwidth) {
        return (int)((float)width * this.xBase + (float)xofs * this.xMult + (float)objwidth * this.xObjMult);
    }

    public int resolveY(int yofs, int height, int objheight) {
        return (int)((float)height * this.yBase + (float)yofs * this.yMult + (float)objheight * this.yObjMult);
    }

    public String toString() {
        return this.lower;
    }
}

