/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.client.render;

import com.elytradev.fruitphone.FruitEquipmentProperties;
import com.elytradev.fruitphone.item.ItemFruitPassive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LayerFruitGlass {
    private static final ResourceLocation PASSIVE = new ResourceLocation("fruitphone", "textures/model/passive.png");
    private static final ResourceLocation PASSIVE_OVERLAY = new ResourceLocation("fruitphone", "textures/model/passive_overlay.png");
    private ModelRenderer bipedHead;
    private ModelBase humanoidHead = new ModelSkeletonHead(0, 0, 64, 64);

    public LayerFruitGlass(ModelRenderer bipedHead) {
        this.bipedHead = bipedHead;
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        FruitEquipmentProperties props = (FruitEquipmentProperties)player.getExtendedProperties("fruitphone:equipment");
        if (props == null) {
            return;
        }
        ItemStack itemstack = props.glasses;
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemFruitPassive) {
            ItemFruitPassive item = (ItemFruitPassive)itemstack.func_77973_b();
            if (item.isInvisible(itemstack)) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.01f, (float)0.0f);
            if (player.func_70093_af()) {
                GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            if (player.func_70631_g_()) {
                GL11.glTranslatef((float)0.0f, (float)(0.5f * scale), (float)0.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                GL11.glTranslatef((float)0.0f, (float)(16.0f * scale), (float)0.0f);
            }
            this.bipedHead.func_78794_c(0.0625f);
            int color = item.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor3f((float)r, (float)g, (float)b);
            GL11.glScalef((float)-1.03125f, (float)1.03125f, (float)-1.03125f);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)3008);
            ItemStack helmet = player.func_82169_q(3);
            if (helmet != null && helmet.func_77973_b() instanceof ItemSkull) {
                if (helmet.func_77960_j() == 4) {
                    GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
                    GL11.glTranslatef((float)0.0f, (float)-0.11f, (float)0.0f);
                } else if (helmet.func_77960_j() == 5) {
                    GL11.glScalef((float)1.75f, (float)1.75f, (float)1.75f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.075f);
                } else {
                    GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PASSIVE);
            this.render(limbSwing);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PASSIVE_OVERLAY);
            GL11.glScalef((float)1.03125f, (float)1.03125f, (float)1.03125f);
            GL11.glTranslatef((float)-0.015f, (float)0.025f, (float)0.015f);
            this.render(limbSwing);
            GL11.glPopMatrix();
        }
    }

    private void render(float limbSwing) {
        GL11.glPushMatrix();
        this.humanoidHead.func_78088_a((Entity)null, limbSwing, 0.0f, 0.0f, 180.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

