/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.client.render;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Rendering {
    private static final DummyScreen GUI = new DummyScreen();

    public static void bindTexture(ResourceLocation resloc) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resloc);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public static void color3(int color) {
        Rendering.color4(color | 0xFF000000);
    }

    public static void color4(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void drawRect(double left, double top, double right, double bottom, int color) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Rendering.color4(color);
        tessellator.func_78382_b();
        tessellator.func_78377_a(left, bottom, 0.0);
        tessellator.func_78377_a(right, bottom, 0.0);
        tessellator.func_78377_a(right, top, 0.0);
        tessellator.func_78377_a(left, top, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedRect(double left, double top, double right, double bottom, float minU, float minV, float maxU, float maxV, int color) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Rendering.color4(color);
        tessellator.func_78382_b();
        tessellator.func_78374_a(left, bottom, 0.0, (double)minU, (double)maxV);
        tessellator.func_78374_a(right, bottom, 0.0, (double)maxU, (double)maxV);
        tessellator.func_78374_a(right, top, 0.0, (double)maxU, (double)minV);
        tessellator.func_78374_a(left, top, 0.0, (double)minU, (double)minV);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedRect(double left, double top, double right, double bottom, IIcon textureSprite) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        double maxU = textureSprite.func_94209_e();
        double maxV = textureSprite.func_94206_g();
        double minU = textureSprite.func_94214_a(left - right);
        double minV = textureSprite.func_94207_b(top - bottom);
        tessellator.func_78382_b();
        tessellator.func_78374_a(left, bottom, 0.0, minU, maxV);
        tessellator.func_78374_a(right, bottom, 0.0, maxU, maxV);
        tessellator.func_78374_a(right, top, 0.0, maxU, minV);
        tessellator.func_78374_a(left, top, 0.0, minU, minV);
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GUI.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public static void drawHorizontalLine(int startX, int endX, int y, int color) {
        GUI.func_73730_a(startX, endX, y, color);
    }

    public static void drawHoveringText(List<String> textLines, int x, int y) {
        GUI.func_146283_a(textLines, x, y);
    }

    public static void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        GUI.drawHoveringText(textLines, x, y, font);
    }

    public static void drawVerticalLine(int x, int startY, int endY, int color) {
        GUI.func_73728_b(x, startY, endY, color);
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        GUI.func_146285_a(stack, x, y);
    }

    public static void drawBackground(int tint) {
        GUI.func_146278_c(tint);
    }

    public static void drawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        GUI.func_73732_a(fontRendererIn, text, x, y, color);
    }

    public static void drawDefaultBackground() {
        GUI.func_146276_q_();
    }

    public static void drawString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        GUI.func_73731_b(fontRendererIn, text, x, y, color);
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        GUI.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public static void drawWorldBackground(int tint) {
        GUI.func_146270_b(tint);
    }

    private Rendering() {
    }

    private static class DummyScreen
    extends GuiScreen {
        private DummyScreen() {
        }

        public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
            super.func_73733_a(left, top, right, bottom, startColor, endColor);
        }

        public void func_73730_a(int startX, int endX, int y, int color) {
            super.func_73730_a(startX, endX, y, color);
        }

        public void func_146283_a(List textLines, int x, int y) {
            super.func_146283_a(textLines, x, y);
        }

        public void drawHoveringText(List textLines, int x, int y, FontRenderer font) {
            super.drawHoveringText(textLines, x, y, font);
        }

        public void func_73728_b(int x, int startY, int endY, int color) {
            super.func_73728_b(x, startY, endY, color);
        }

        public void func_146285_a(ItemStack stack, int x, int y) {
            super.func_146285_a(stack, x, y);
        }
    }
}

