/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.network;

import com.elytradev.fruitphone.FruitEquipmentProperties;
import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.Message;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.NetworkContext;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.annotation.field.MarshalledAs;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.annotation.type.ReceivedOn;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

@ReceivedOn(value=Side.CLIENT)
public class EquipmentDataPacket
extends Message {
    @MarshalledAs(value="i32")
    public int entityId;
    public NBTTagCompound tag;

    public EquipmentDataPacket(NetworkContext ctx) {
        super(ctx);
    }

    public EquipmentDataPacket(int entityId, NBTTagCompound tag) {
        super(FruitPhone.inst.NETWORK);
        this.entityId = entityId;
        this.tag = tag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        Entity entity = sender.field_70170_p.func_73045_a(this.entityId);
        FruitEquipmentProperties props = (FruitEquipmentProperties)entity.getExtendedProperties("fruitphone:equipment");
        props.loadNBTData(this.tag);
    }

    public static Optional<EquipmentDataPacket> forEntity(Entity e) {
        FruitEquipmentProperties props = (FruitEquipmentProperties)e.getExtendedProperties("fruitphone:equipment");
        if (props == null) {
            return Optional.absent();
        }
        NBTTagCompound tag = new NBTTagCompound();
        props.saveNBTData(tag);
        return Optional.of((Object)new EquipmentDataPacket(e.func_145782_y(), tag));
    }
}

