/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.proxy;

import com.elytradev.fruitphone.FruitEquipmentProperties;
import com.elytradev.fruitphone.FruitPhone;
import com.elytradev.fruitphone.FruitRenderer;
import com.elytradev.fruitphone.Gravity;
import com.elytradev.fruitphone.client.gui.ScreenConfigureGlasses;
import com.elytradev.fruitphone.client.render.LayerFruitGlass;
import com.elytradev.fruitphone.item.FruitItems;
import com.elytradev.fruitphone.item.ItemFruitPassive;
import com.elytradev.fruitphone.proxy.Proxy;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends Proxy {
    private static boolean isServerVanilla = false;
    public boolean alwaysOn = false;
    public static float ticks;
    public static float partialTicks;
    public static float ticksConsiderPaused;
    private LayerFruitGlass layer;

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void postInit() {
        super.postInit();
        RenderPlayer rp = (RenderPlayer)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
        this.layer = new LayerFruitGlass(rp.field_77109_a.field_78116_c);
    }

    @Override
    public void configureGlasses() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new ScreenConfigureGlasses());
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Specials.Post e) {
        this.layer.doRenderLayer(e.entityPlayer, 0.0f, 0.0f, partialTicks, (float)e.entityPlayer.field_70173_aa + e.partialRenderTick, e.entityPlayer.field_70759_as, e.entityPlayer.field_70125_A, 0.0625f);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            partialTicks = e.renderTickTime;
            ticks = (float)((int)ticks) + e.renderTickTime;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ticksConsiderPaused = (float)((int)ticksConsiderPaused) + e.renderTickTime;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks += 1.0f;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ticksConsiderPaused += 1.0f;
            }
        }
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        isServerVanilla = !e.connectionType.equals("MODDED");
    }

    @SubscribeEvent
    public void onRenderHud(RenderGameOverlayEvent.Post e) {
        if (e.type == RenderGameOverlayEvent.ElementType.ALL) {
            if (Minecraft.func_71410_x().field_71462_r instanceof ScreenConfigureGlasses) {
                return;
            }
            ItemStack glasses = null;
            if (FruitPhone.inst.optionalMode || this.alwaysOn || !ClientProxy.doesServerHaveMod() || (glasses = ((FruitEquipmentProperties)Minecraft.func_71410_x().field_71439_g.getExtendedProperties((String)"fruitphone:equipment")).glasses) != null) {
                int color = -1;
                if (glasses != null && glasses.func_77973_b() instanceof ItemFruitPassive) {
                    ItemFruitPassive item = (ItemFruitPassive)glasses.func_77973_b();
                    color = item.getColor(glasses);
                }
                Gravity g = FruitPhone.inst.glassesGravity;
                int xOfs = FruitPhone.inst.glassesXOffset;
                int yOfs = FruitPhone.inst.glassesYOffset;
                float confScale = FruitPhone.inst.glassesScale;
                int maxWidth = (int)((float)e.resolution.func_78326_a() * FruitPhone.inst.maxGlassesWidth / confScale);
                int maxHeight = (int)((float)e.resolution.func_78328_b() * FruitPhone.inst.maxGlassesHeight / confScale);
                GL11.glPushMatrix();
                FruitRenderer.MultiDataSize mds = FruitRenderer.calculateAndSyncTarget(90, 50, maxWidth, maxHeight);
                if (mds.clamped.getWidth() > 0 && mds.clamped.getHeight() > 0) {
                    float scale = FruitRenderer.getContainScale(mds.clamped.getWidth(), mds.clamped.getHeight(), mds.actual.getWidth(), mds.actual.getHeight());
                    float xScale = 1.0f;
                    float yScale = 1.0f;
                    if (mds.clamped.getWidth() < mds.clamped.getHeight()) {
                        xScale = scale;
                    } else if (mds.clamped.getHeight() < mds.clamped.getWidth()) {
                        yScale = scale;
                    } else {
                        xScale = yScale = scale;
                    }
                    int objWidth = (int)((float)mds.clamped.getWidth() * (xScale *= confScale)) + 10;
                    int objHeight = (int)((float)mds.clamped.getHeight() * (yScale *= confScale)) + 10;
                    int x = g.resolveX(xOfs, e.resolution.func_78326_a(), objWidth);
                    int y = g.resolveY(yOfs, e.resolution.func_78328_b(), objHeight);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                    Gui.func_73734_a((int)0, (int)0, (int)objWidth, (int)objHeight, (int)color);
                    Gui.func_73734_a((int)1, (int)1, (int)(objWidth - 1), (int)(objHeight - 1), (int)-15984331);
                    GL11.glTranslatef((float)5.0f, (float)5.0f, (float)40.0f);
                    GL11.glScalef((float)confScale, (float)confScale, (float)1.0f);
                    FruitRenderer.renderAndSyncTarget(mds.clamped.getWidth(), mds.clamped.getHeight(), true, mds.actual);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            }
        }
    }

    public static boolean doesServerHaveMod() {
        return Item.field_150901_e.func_148750_c((Object)FruitItems.PASSIVE) != null && !isServerVanilla;
    }
}

