/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.repackage.com.elytradev.concrete;

import com.elytradev.fruitphone.repackage.com.elytradev.concrete.NetworkContext;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.annotation.type.ReceivedOn;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.exception.BadMessageException;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.exception.WrongSideException;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public abstract class Message {
    private static final Map<Class<?>, ClassInfo> classInfo = Maps.newHashMap();
    private final transient NetworkContext ctx;
    private final transient Side side;

    public Message(NetworkContext ctx) {
        this.ctx = ctx;
        ClassInfo ci = classInfo.get(this.getClass());
        if (ci == null) {
            ReceivedOn ro = this.getClass().getDeclaredAnnotation(ReceivedOn.class);
            if (ro == null) {
                throw new BadMessageException("Must specify @ReceivedOn");
            }
            this.side = ro.value();
            ci = new ClassInfo(this.side);
        } else {
            this.side = ci.side;
        }
    }

    @SideOnly(value=Side.CLIENT)
    void doHandleClient() {
        this.handle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    void doHandleServer(EntityPlayer sender) {
        this.handle(sender);
    }

    protected abstract void handle(EntityPlayer var1);

    Side getSide() {
        return this.side;
    }

    public final void sendTo(EntityPlayer player) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (player instanceof EntityPlayerMP) {
            for (Packet p : this.toClientboundVanillaPackets()) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a(p);
            }
        }
    }

    public final void sendToAllAround(World world, Entity entity, double radius) {
        this.sendToAllAround(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, radius);
    }

    public final void sendToAllAround(World world, int x, int y, int z, double radius) {
        this.sendToAllAround(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, radius);
    }

    public final void sendToAllAround(World world, double x, double y, double z, double radius) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        double sq = radius * radius;
        List<Packet> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.field_73010_i) {
            if (!(ep.func_70092_e(x, y, z) <= sq)) continue;
            for (Packet packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public final void sendToAllWatching(World world, int x, int y, int z) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (world instanceof WorldServer) {
            WorldServer srv = (WorldServer)world;
            Chunk c = srv.func_72938_d(x, z);
            if (srv.func_73040_p().func_152621_a(c.field_76635_g, c.field_76647_h)) {
                List<Packet> packets = this.toClientboundVanillaPackets();
                for (EntityPlayerMP ep : world.field_73010_i) {
                    if (!srv.func_73040_p().func_72694_a(ep, c.field_76635_g, c.field_76647_h)) continue;
                    for (Packet packet : packets) {
                        ep.field_71135_a.func_147359_a(packet);
                    }
                }
            }
        }
    }

    public final void sendToAllWatching(TileEntity te) {
        this.sendToAllWatching(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public final void sendToAllWatching(Entity e) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        if (e.field_70170_p instanceof WorldServer) {
            WorldServer srv = (WorldServer)e.field_70170_p;
            List<Packet> packets = this.toClientboundVanillaPackets();
            for (Packet packet : packets) {
                srv.func_73039_n().func_151247_a(e, packet);
            }
        }
    }

    public final void sendToAllIn(World world) {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        List<Packet> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.field_73010_i) {
            for (Packet packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public final void sendToEveryone() {
        if (this.side.isServer()) {
            this.wrongSide();
        }
        List<Packet> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            for (Packet packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void sendToServer() {
        NetHandlerPlayClient conn;
        if (this.side.isClient()) {
            this.wrongSide();
        }
        if ((conn = Minecraft.func_71410_x().func_147114_u()) == null) {
            throw new IllegalStateException("Cannot send a message while not connected");
        }
        conn.func_147297_a(this.toServerboundVanillaPacket());
    }

    public final Packet toServerboundVanillaPacket() {
        return this.ctx.getPacketFrom(this).toC17Packet();
    }

    public final List<Packet> toClientboundVanillaPackets() {
        return Collections.singletonList(this.ctx.getPacketFrom(this).toS3FPacket());
    }

    private void wrongSide() {
        throw new WrongSideException(this.getClass() + " cannot be sent from side " + this.side);
    }

    private static final class ClassInfo {
        public final Side side;

        public ClassInfo(Side side) {
            this.side = side;
        }
    }
}

