/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api;

import com.elytradev.probe.api.IUnit;
import com.elytradev.probe.api.impl.BinaryUnit;
import com.elytradev.probe.api.impl.SIUnit;
import com.elytradev.probe.api.impl.TicksUnit;
import com.elytradev.probe.api.impl.Unit;
import com.google.common.collect.HashBiMap;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;

public class UnitDictionary {
    private static UnitDictionary INSTANCE;
    public static final Unit BUCKETS_ANY;
    public static final BinaryUnit BYTES;
    public static final Unit FORGE_ENERGY;
    public static final Unit FU_PER_TICK;
    public static final Unit DANKS;
    public static final Unit DANKS_PER_TICK;
    public static final Unit KELVIN;
    public static final Unit PERCENT;
    public static final Unit TICKS;
    private HashMap<String, IUnit> registry = new HashMap();
    private HashBiMap<IUnit, Fluid> fluidUnits = HashBiMap.create();

    public static final UnitDictionary getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UnitDictionary();
        }
        return INSTANCE;
    }

    private UnitDictionary() {
        this.register(BUCKETS_ANY);
        this.register(BYTES);
        this.register(FORGE_ENERGY);
        this.register(FU_PER_TICK);
        this.register(DANKS);
        this.register(DANKS_PER_TICK);
        this.register(KELVIN);
        this.register(PERCENT);
        this.register(TICKS);
    }

    public void register(IUnit unit) {
        this.registry.put(unit.getFullName(), unit);
    }

    public void register(IUnit unit, Fluid fluid) {
        this.registry.put(unit.getFullName(), unit);
        this.fluidUnits.put((Object)unit, (Object)fluid);
    }

    @Nullable
    public IUnit getUnit(String fullName) {
        return this.registry.get(fullName);
    }

    public boolean isFluid(IUnit unit) {
        return this.fluidUnits.containsKey((Object)unit);
    }

    @Nullable
    public Fluid getFluid(IUnit unit) {
        return (Fluid)this.fluidUnits.get((Object)unit);
    }

    @Nullable
    public IUnit getUnit(Fluid fluid) {
        return (IUnit)this.fluidUnits.inverse().get((Object)fluid);
    }

    static {
        BUCKETS_ANY = new SIUnit("buckets", "B", 2635155);
        BYTES = new BinaryUnit("bytes", "B", 7798531);
        FORGE_ENERGY = new SIUnit("forge_energy", "FU", 0xD50000);
        FU_PER_TICK = new SIUnit("fu_per_tick", "FU/t", 0xD50000);
        DANKS = new SIUnit("danks", "Dk", 5320104);
        DANKS_PER_TICK = new SIUnit("danks_per_tick", "Dk/t", 5320104);
        KELVIN = new SIUnit("kelvin", "\u00b0K", 0xFF0000);
        PERCENT = new Unit("percent", "%", 0xAAAAAA, NumberFormat.getIntegerInstance(), false);
        TICKS = new TicksUnit("ticks", 0xAAAAAA);
    }
}

