/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api.impl;

import com.elytradev.probe.api.impl.Unit;
import java.text.NumberFormat;

public class BinaryUnit
extends Unit {
    private static final double KIBI = 1024.0;
    private static final double MEBI = 1048576.0;
    private static final double GIBI = 1.073741824E9;
    private static final double TEBI = 1.099511627776E12;
    private static final double PEBI = 1.125899906842624E15;
    private static final double EXBI = 1.152921504606847E18;
    private static final double ZEBI = 1.1805916207174113E21;
    private static final double YOBI = 1.2089258196146292E24;
    private static final double HEBI = 1.2379400392853803E27;

    public BinaryUnit(String name, String abbreviation, int barColor, NumberFormat nfmt, boolean spaceAfterNumber) {
        super(name, abbreviation, barColor, nfmt, spaceAfterNumber);
    }

    public BinaryUnit(String name, String abbreviation, int barColor) {
        super(name, abbreviation, barColor);
    }

    public BinaryUnit(String name, String abbreviation) {
        super(name, abbreviation);
    }

    @Override
    public String format(double d) {
        String space;
        String string = space = this.spaceAfterNumber ? " " : "";
        if (d == Double.POSITIVE_INFINITY) {
            return "\u221e" + space + this.getAbbreviation();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-\u221e" + space + this.getAbbreviation();
        }
        if (Double.isNaN(d)) {
            return "NaN" + space + this.getAbbreviation();
        }
        double magnitude = Math.abs(d);
        if (magnitude > 1.2379400392853803E27) {
            return this.format.format(d / 1.2379400392853803E27) + space + "Xi" + this.getAbbreviation();
        }
        if (magnitude > 1.2089258196146292E24) {
            return this.format.format(d / 1.2089258196146292E24) + space + "Yi" + this.getAbbreviation();
        }
        if (magnitude > 1.1805916207174113E21) {
            return this.format.format(d / 1.1805916207174113E21) + space + "Zi" + this.getAbbreviation();
        }
        if (magnitude > 1.152921504606847E18) {
            return this.format.format(d / 1.152921504606847E18) + space + "Ei" + this.getAbbreviation();
        }
        if (magnitude > 1.125899906842624E15) {
            return this.format.format(d / 1.125899906842624E15) + space + "Pi" + this.getAbbreviation();
        }
        if (magnitude > 1.099511627776E12) {
            return this.format.format(d / 1.099511627776E12) + space + "Ti" + this.getAbbreviation();
        }
        if (magnitude > 1.073741824E9) {
            return this.format.format(d / 1.073741824E9) + space + "Gi" + this.getAbbreviation();
        }
        if (magnitude > 1048576.0) {
            return this.format.format(d / 1048576.0) + space + "Mi" + this.getAbbreviation();
        }
        if (magnitude > 1024.0) {
            return this.format.format(d / 1024.0) + space + "Ki" + this.getAbbreviation();
        }
        return this.format.format(d) + space + this.getAbbreviation();
    }
}

