/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api.impl;

import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.IUnit;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ProbeData
implements IProbeData {
    private IChatComponent label = null;
    private double barMin = Double.NaN;
    private double barCur = Double.NaN;
    private double barMax = Double.NaN;
    private IUnit barUnit = null;
    private List<ItemStack> inventory = null;

    public ProbeData() {
    }

    public ProbeData(String label) {
        this.label = new ChatComponentText(label);
    }

    public ProbeData(IChatComponent label) {
        this.label = label;
    }

    public ProbeData withLabel(String label) {
        this.label = new ChatComponentText(label);
        return this;
    }

    public ProbeData withLabel(IChatComponent label) {
        this.label = label;
        return this;
    }

    public ProbeData withBar(double minimum, double current, double maximum, IUnit unit) {
        this.barMin = minimum;
        this.barCur = current;
        this.barMax = maximum;
        this.barUnit = unit;
        return this;
    }

    public ProbeData withInventory(@Nonnull List<ItemStack> inventory) {
        this.inventory = inventory;
        return this;
    }

    @Override
    public boolean hasLabel() {
        return this.label != null;
    }

    @Override
    public boolean hasBar() {
        return !Double.isNaN(this.barMin) && !Double.isNaN(this.barCur) && !Double.isNaN(this.barMax);
    }

    @Override
    @Nonnull
    public IChatComponent getLabel() {
        return this.label != null ? this.label : new ChatComponentText("");
    }

    @Override
    public double getBarMinimum() {
        return this.barMin;
    }

    @Override
    public double getBarCurrent() {
        return this.barCur;
    }

    @Override
    public double getBarMaximum() {
        return this.barMax;
    }

    @Override
    @Nullable
    public IUnit getBarUnit() {
        return this.barUnit;
    }

    @Override
    public boolean hasInventory() {
        return this.inventory != null;
    }

    @Override
    @Nullable
    public List<ItemStack> getInventory() {
        return this.inventory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.barCur);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.barMax);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.barMin);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.barUnit == null ? 0 : this.barUnit.hashCode());
        result = 31 * result + (this.inventory == null ? 0 : ProbeData.stackListHashCode(this.inventory));
        try {
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProbeData other = (ProbeData)obj;
        if (Double.doubleToLongBits(this.barCur) != Double.doubleToLongBits(other.barCur)) {
            return false;
        }
        if (Double.doubleToLongBits(this.barMax) != Double.doubleToLongBits(other.barMax)) {
            return false;
        }
        if (Double.doubleToLongBits(this.barMin) != Double.doubleToLongBits(other.barMin)) {
            return false;
        }
        if (this.barUnit == null ? other.barUnit != null : !this.barUnit.equals(other.barUnit)) {
            return false;
        }
        if (this.inventory == null ? other.inventory != null : !ProbeData.stackListsEqual(this.inventory, other.inventory)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    private static int stackListHashCode(List<ItemStack> li) {
        int result = 1;
        for (ItemStack is : li) {
            result = 31 * result + (is == null ? 0 : ProbeData.stackHashCode(is));
        }
        return result;
    }

    private static int stackHashCode(ItemStack is) {
        if (is == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + is.func_77973_b().hashCode();
        result = 31 * result + is.field_77994_a;
        result = 31 * result + is.func_77960_j();
        result = 31 * result + (is.func_77942_o() ? is.func_77978_p().hashCode() : 0);
        return result;
    }

    private static boolean stackListsEqual(List<ItemStack> a, List<ItemStack> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            ItemStack isb;
            ItemStack isa = a.get(i);
            if (ItemStack.func_77989_b((ItemStack)isa, (ItemStack)(isb = b.get(i)))) continue;
            return false;
        }
        return true;
    }
}

