/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api.impl;

import com.elytradev.probe.api.impl.Unit;
import java.text.NumberFormat;

public class SIUnit
extends Unit {
    private static final double HELLA = 1.0E27;
    private static final double YOTTA = 1.0E24;
    private static final double ZETTA = 1.0E21;
    private static final double EXA = 1.0E18;
    private static final double PETA = 1.0E15;
    private static final double TERA = 1.0E12;
    private static final double GIGA = 1.0E9;
    private static final double MEGA = 1000000.0;
    private static final double KILO = 1000.0;
    private static final double MILLI = 0.001;
    private static final double MICRO = 1.0E-6;
    private static final double NANO = 1.0E-9;
    private static final double PICO = 1.0E-12;

    public SIUnit(String name, String abbreviation, int barColor, NumberFormat nfmt, boolean spaceAfterNumber) {
        super(name, abbreviation, barColor, nfmt, spaceAfterNumber);
    }

    public SIUnit(String name, String abbreviation, int barColor) {
        super(name, abbreviation, barColor);
    }

    public SIUnit(String name, String abbreviation) {
        super(name, abbreviation);
    }

    @Override
    public String format(double d) {
        String space;
        String string = space = this.spaceAfterNumber ? " " : "";
        if (d == 0.0) {
            return this.format.format(d) + space + this.getAbbreviation();
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "\u221e" + space + this.getAbbreviation();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-\u221e" + space + this.getAbbreviation();
        }
        if (Double.isNaN(d)) {
            return "NaN" + space + this.getAbbreviation();
        }
        double magnitude = Math.abs(d);
        if (magnitude > 1.0E27) {
            return this.format.format(d / 1.0E27) + space + "X" + this.getAbbreviation();
        }
        if (magnitude > 1.0E24) {
            return this.format.format(d / 1.0E24) + space + "Y" + this.getAbbreviation();
        }
        if (magnitude > 1.0E21) {
            return this.format.format(d / 1.0E21) + space + "Z" + this.getAbbreviation();
        }
        if (magnitude > 1.0E18) {
            return this.format.format(d / 1.0E18) + space + "E" + this.getAbbreviation();
        }
        if (magnitude > 1.0E15) {
            return this.format.format(d / 1.0E15) + space + "P" + this.getAbbreviation();
        }
        if (magnitude > 1.0E12) {
            return this.format.format(d / 1.0E12) + space + "T" + this.getAbbreviation();
        }
        if (magnitude > 1.0E9) {
            return this.format.format(d / 1.0E9) + space + "G" + this.getAbbreviation();
        }
        if (magnitude > 1000000.0) {
            return this.format.format(d / 1000000.0) + space + "M" + this.getAbbreviation();
        }
        if (magnitude > 1000.0) {
            return this.format.format(d / 1000.0) + space + "k" + this.getAbbreviation();
        }
        if (magnitude < 1.0E-9) {
            return this.format.format(d / 1.0E-12) + space + "p" + this.getAbbreviation();
        }
        if (magnitude < 1.0E-6) {
            return this.format.format(d / 1.0E-9) + space + "n" + this.getAbbreviation();
        }
        if (magnitude < 0.001) {
            return this.format.format(d / 1.0E-6) + space + "\u00b5" + this.getAbbreviation();
        }
        if (magnitude < 1.0) {
            return this.format.format(d / 0.001) + space + "m" + this.getAbbreviation();
        }
        return this.format.format(d) + space + this.getAbbreviation();
    }
}

