/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api.impl;

import com.elytradev.fruitphone.proxy.ClientProxy;
import com.elytradev.probe.api.impl.Unit;

public class TicksUnit
extends Unit {
    public TicksUnit(String name, int barColor) {
        super(name, "t", barColor);
    }

    public TicksUnit(String name) {
        super(name, "t");
    }

    @Override
    public String format(double ticks) {
        if (ticks == Double.POSITIVE_INFINITY) {
            return "\u221e";
        }
        if (ticks == Double.NEGATIVE_INFINITY) {
            return "-\u221e";
        }
        if (Double.isNaN(ticks)) {
            return "NaN";
        }
        if ((ticks -= (double)ClientProxy.partialTicks) < 0.0) {
            ticks = 0.0;
        }
        int millisrem = (int)(ticks * 50.0 % 1000.0);
        long sec = (long)(ticks / 20.0);
        int secrem = (int)(sec % 60L);
        long min = (long)(ticks / 1200.0);
        String secstr = (secrem < 10 ? "0" : "") + secrem;
        String millisstr = (millisrem < 100 ? (millisrem < 10 ? "00" : "0") : "") + millisrem;
        return min + ":" + secstr + "." + millisstr;
    }
}

