/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.probe.api.impl;

import com.elytradev.probe.api.IUnit;
import java.text.NumberFormat;

public class Unit
implements IUnit {
    public static final NumberFormat FORMAT_STANDARD = NumberFormat.getNumberInstance();
    private final String name;
    private final String abbreviation;
    private final int barColor;
    protected final NumberFormat format;
    protected final boolean spaceAfterNumber;

    public Unit(String name, String abbreviation) {
        this(name, abbreviation, 0xAAAAAA, FORMAT_STANDARD, true);
    }

    public Unit(String name, String abbreviation, int barColor) {
        this(name, abbreviation, barColor, FORMAT_STANDARD, true);
    }

    public Unit(String name, String abbreviation, int barColor, NumberFormat nfmt, boolean spaceAfterNumber) {
        this.name = name;
        this.abbreviation = abbreviation;
        this.barColor = barColor;
        this.format = nfmt;
        this.spaceAfterNumber = spaceAfterNumber;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public int getBarColor() {
        return this.barColor;
    }

    @Override
    public String format(double d) {
        String space;
        String string = space = this.spaceAfterNumber ? " " : "";
        if (d == Double.POSITIVE_INFINITY) {
            return "\u221e" + space + this.getAbbreviation();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-\u221e" + space + this.getAbbreviation();
        }
        if (Double.isNaN(d)) {
            return "NaN" + space + this.getAbbreviation();
        }
        return this.format.format(d) + space + this.getAbbreviation();
    }

    static {
        FORMAT_STANDARD.setMinimumFractionDigits(0);
        FORMAT_STANDARD.setMaximumFractionDigits(2);
    }
}

