/*
 * Decompiled with CFR 0.152.
 */
package net.unknownuser.beaconrange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.unknownuser.beaconrange.BeaconRange;
import net.unknownuser.beaconrange.ConfigDeserializer;

public class Config
implements Serializable {
    public static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("beacon-range-extender.json").toFile();
    private static Config instance = null;
    @Expose
    protected final int rangePerLevel;
    @Expose
    protected final int baseRange;
    @Expose
    protected final Map<class_2960, Double> rangeMultipliers;
    private transient boolean hasError = false;

    public Config(int rangePerLevel, int baseRange, Map<class_2960, Double> rangeMultipliers) {
        this.rangePerLevel = rangePerLevel;
        this.baseRange = baseRange;
        this.rangeMultipliers = rangeMultipliers;
    }

    public void enableError() {
        this.hasError = true;
    }

    public static int rangePerLevel() {
        return Config.instance.rangePerLevel;
    }

    public static int baseOffset() {
        return Config.instance.baseRange;
    }

    public static double blockMultiplier(class_2960 identifier) {
        return Config.instance.rangeMultipliers.getOrDefault(identifier, 1.0);
    }

    private static Config getConfigFromFile() {
        Config cfg;
        if (CONFIG_FILE.exists()) {
            BeaconRange.LOGGER.info("using existing config file");
            cfg = Config.loadConfig();
        } else {
            BeaconRange.LOGGER.info("config file is missing, creating using default settings!");
            cfg = Defaults.defaultConfig();
            cfg.write();
        }
        return cfg;
    }

    private static Config loadConfig() {
        Config config;
        Gson gson = new GsonBuilder().registerTypeAdapter(Config.class, (Object)new ConfigDeserializer()).excludeFieldsWithoutExposeAnnotation().setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            Config config2 = (Config)gson.fromJson((Reader)reader, Config.class);
            if (config2.hasError) {
                BeaconRange.LOGGER.warn("config has errors, rewriting config file");
                config2.write();
            }
            config = config2;
        }
        catch (Throwable config2) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    config2.addSuppressed(throwable);
                }
                throw config2;
            }
            catch (IOException e) {
                BeaconRange.LOGGER.error("Could not read config file: {}", (Object)e.getMessage());
                BeaconRange.LOGGER.warn("Using default values for settings!");
                Config config3 = Defaults.defaultConfig();
                config3.write();
                return config3;
            }
            catch (JsonSyntaxException exc) {
                BeaconRange.LOGGER.error("The config file '{}' has errors!", (Object)CONFIG_FILE);
                BeaconRange.LOGGER.error("Aborting start to prevent errors or data loss!");
                throw exc;
            }
        }
        reader.close();
        return config;
    }

    public static void init() {
        instance = Config.getConfigFromFile();
    }

    public void write() {
        Gson gson = new Gson().newBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            BeaconRange.LOGGER.error("Could not write config file! Reason: %s", (Throwable)e);
        }
    }

    public static class Defaults {
        static final int RANGE_PER_LEVEL_MULTIPLIER = 10;
        static final int MINIMUM_RANGE = 10;
        static final Map<class_2960, Double> RANGE_EXTENDER_MULTIPLIER = new HashMap<class_2960, Double>();

        private Defaults() {
        }

        private static void initializeMultiplierTable() {
            RANGE_EXTENDER_MULTIPLIER.put(class_2960.method_12838((String)"minecraft:diamond_block", (char)':'), 2.0);
            RANGE_EXTENDER_MULTIPLIER.put(class_2960.method_12838((String)"minecraft:netherite_block", (char)':'), 4.0);
        }

        private static Config defaultConfig() {
            return new Config(10, 10, RANGE_EXTENDER_MULTIPLIER);
        }

        static {
            Defaults.initializeMultiplierTable();
        }
    }
}

