/*
 * Decompiled with CFR 0.152.
 */
package net.unknownuser.beaconrange;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.unknownuser.beaconrange.BeaconRange;
import net.unknownuser.beaconrange.Config;
import net.unknownuser.beaconrange.FieldGetter;

public class ConfigDeserializer
implements JsonDeserializer<Config> {
    public Config deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        FieldGetter getter = new FieldGetter(object);
        int rangePerLevel = getter.getInt("rangePerLevel", 10);
        int baseOffset = getter.getInt("baseRange", 10);
        Map<String, JsonElement> rawMultipliers = getter.getMap("rangeMultipliers");
        HashMap<class_2960, Double> multipliers = new HashMap<class_2960, Double>();
        for (Map.Entry<String, JsonElement> element : rawMultipliers.entrySet()) {
            try {
                class_2960 identifier = class_2960.method_12838((String)element.getKey(), (char)':');
                double multiplier = element.getValue().getAsDouble();
                multipliers.put(identifier, multiplier);
            }
            catch (class_151 exc) {
                BeaconRange.LOGGER.error("Invalid block identifier in config: '{}'", (Object)element.getKey());
                throw exc;
            }
            catch (UnsupportedOperationException exc) {
                BeaconRange.LOGGER.error("Identifier '{}' has invalid value '{}'", (Object)element.getKey(), (Object)element.getValue());
                throw exc;
            }
        }
        Config config = new Config(rangePerLevel, baseOffset, multipliers);
        if (getter.hasError()) {
            config.enableError();
        }
        return config;
    }
}

