/*
 * Decompiled with CFR 0.152.
 */
package net.unknownuser.beaconrange;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.unknownuser.beaconrange.BeaconRange;

class FieldGetter {
    private final JsonObject object;
    private boolean hasError;

    public FieldGetter(JsonObject object) {
        this.object = object;
        this.hasError = false;
    }

    private JsonElement get(String name) {
        JsonElement value = this.object.get(name);
        if (value == null) {
            this.hasError = true;
            return null;
        }
        return value;
    }

    public int getInt(String name, int fallback) {
        JsonElement element = this.get(name);
        if (element == null) {
            BeaconRange.LOGGER.warn("config entry '{}' is missing, using '{}' as value", (Object)name, (Object)fallback);
            return fallback;
        }
        return element.getAsInt();
    }

    public Map<String, JsonElement> getMap(String name) {
        JsonElement element = this.get(name);
        if (element == null) {
            return new HashMap<String, JsonElement>();
        }
        return element.getAsJsonObject().asMap();
    }

    public boolean hasError() {
        return this.hasError;
    }
}

