/*
 * Decompiled with CFR 0.152.
 */
package net.unknownuser.beaconrange.mixins;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.unknownuser.beaconrange.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2580.class})
public class BeaconMixin {
    @Unique
    private static double baseBlockFactor = 1.0;

    private BeaconMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"applyPlayerEffects"}, cancellable=true)
    private static void applyPlayerEffects(class_1937 world, class_2338 pos, int beaconLevel, class_6880<class_1291> primaryEffect, class_6880<class_1291> secondaryEffect, CallbackInfo ci) {
        ci.cancel();
        if (!world.method_8608() && primaryEffect != null) {
            double range = (double)(beaconLevel * Config.rangePerLevel()) * baseBlockFactor + (double)Config.baseOffset();
            int effectAmplifier = 0;
            if (beaconLevel >= 4 && Objects.equals(primaryEffect, secondaryEffect)) {
                effectAmplifier = 1;
            }
            int effectDuration = (9 + beaconLevel * 2) * 20;
            class_238 rangeBox = new class_238(pos).method_1014(range).method_1012(0.0, (double)world.method_31605(), 0.0);
            List players = world.method_18467(class_1657.class, rangeBox);
            for (class_1657 playerEntity : players) {
                playerEntity.method_6092(new class_1293(primaryEffect, effectDuration, effectAmplifier, true, true));
            }
            if (beaconLevel >= 4 && !Objects.equals(primaryEffect, secondaryEffect) && secondaryEffect != null) {
                for (class_1657 playerEntity : players) {
                    playerEntity.method_6092(new class_1293(secondaryEffect, effectDuration, 0, true, true));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLevel"}, cancellable=true)
    private static void updateLevel(class_1937 world, int x, int y, int z, CallbackInfoReturnable<Integer> cir) {
        int k;
        cir.cancel();
        int i = 0;
        double multiplier = 1.0;
        int j = 1;
        while (j <= 4 && (k = y - j) >= world.method_31607()) {
            boolean bl = true;
            boolean levelIsOnlySameBlock = true;
            class_2960 identifier = null;
            block1: for (int l = x - j; l <= x + j && bl; ++l) {
                for (int m = z - j; m <= z + j; ++m) {
                    class_2680 blockState = world.method_8320(new class_2338(l, k, m));
                    if (!blockState.method_26164(class_3481.field_22275)) {
                        bl = false;
                        continue block1;
                    }
                    if (identifier == null) {
                        identifier = class_7923.field_41175.method_10221((Object)blockState.method_26204());
                        continue;
                    }
                    if (!levelIsOnlySameBlock || identifier.equals((Object)class_7923.field_41175.method_10221((Object)blockState.method_26204()))) continue;
                    levelIsOnlySameBlock = false;
                }
            }
            if (levelIsOnlySameBlock) {
                multiplier *= Config.blockMultiplier(identifier);
            }
            if (!bl) break;
            i = j++;
        }
        baseBlockFactor = multiplier;
        cir.setReturnValue((Object)i);
    }
}

