/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractTriggerBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.joml.Vector4f;

public class MusicTriggerBlockEntity
extends AbstractTriggerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    List<? extends class_1309> lastContained = new ArrayList<class_1309>();
    String namespace;
    String soundName;
    float volume;
    float pitch;
    boolean stopAllMusic;
    boolean isSelfReset;
    List<String> triggeredPlayers;

    public MusicTriggerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends AbstractTriggerBlockEntity>)BlockEntityRegistry.MAP_MUSIC, pos, state);
        this.id = "musicTrigger";
        this.namespace = "minecraft";
        this.soundName = "music.game";
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.stopAllMusic = true;
        this.isSelfReset = true;
        this.triggeredPlayers = new ArrayList<String>();
        this.selfResetting = true;
        this.activateDelay = 1;
        this.targetThreshold = 0;
        this.inverted = false;
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.9f, 0.3f, 0.8f, 1.0f);
    }

    @Override
    public String getTexture() {
        return "music_trigger";
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("M-" + this.id));
    }

    @Override
    Class<? extends class_1309> getTargetClass() {
        return class_1657.class;
    }

    @Override
    void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            String actualSoundName;
            String actualNamespace;
            class_2960 soundId;
            class_3414 soundEvent;
            ArrayList<class_1309> entered = new ArrayList<class_1309>();
            for (class_1309 entity : this.containedEntities) {
                if (this.lastContained.contains(entity) || !(entity instanceof class_3222)) continue;
                class_3222 player = (class_3222)entity;
                String playerUuid = player.method_5845();
                if (!this.isSelfReset && this.triggeredPlayers.contains(playerUuid)) continue;
                entered.add(entity);
            }
            if (!entered.isEmpty() && (soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId = new class_2960(actualNamespace = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : "minecraft", actualSoundName = this.soundName != null && !this.soundName.isEmpty() ? this.soundName : "music.game"))) != null) {
                for (class_1309 entity : entered) {
                    String playerUuid;
                    if (!(entity instanceof class_3222)) continue;
                    class_3222 player = (class_3222)entity;
                    if (this.stopAllMusic) {
                        this.stopAllMusicForPlayer(player);
                    }
                    player.method_17356(soundEvent, class_3419.field_15253, this.volume, this.pitch);
                    if (this.isSelfReset || this.triggeredPlayers.contains(playerUuid = player.method_5845())) continue;
                    this.triggeredPlayers.add(playerUuid);
                    this.method_5431();
                }
            }
            this.lastContained = this.containedEntities;
        }
    }

    private void stopAllMusicForPlayer(class_3222 player) {
        class_2770 stopPacket = new class_2770(null, class_3419.field_15253);
        player.field_13987.method_14364((class_2596)stopPacket);
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        switch (s) {
            case "namespace": {
                this.namespace = value != null && !value.isEmpty() ? value : "minecraft";
                this.method_5431();
                break;
            }
            case "soundId": {
                this.soundName = value != null && !value.isEmpty() ? value : "music.game";
                this.method_5431();
                break;
            }
            case "volume": {
                this.volume = Math.max(0.0f, Float.parseFloat(value));
                this.method_5431();
                break;
            }
            case "pitch": {
                this.pitch = Math.max(0.1f, Math.min(2.0f, Float.parseFloat(value)));
                this.method_5431();
                break;
            }
            case "stopAllMusic": {
                this.stopAllMusic = Boolean.parseBoolean(value);
                this.method_5431();
                break;
            }
            case "isSelfReset": {
                this.isSelfReset = Boolean.parseBoolean(value);
                if (this.isSelfReset && this.triggeredPlayers != null) {
                    this.triggeredPlayers.clear();
                }
                this.method_5431();
            }
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        if (this.namespace == null) {
            this.namespace = "minecraft";
        }
        if (this.soundName == null) {
            this.soundName = "music.game";
        }
        if (this.triggeredPlayers == null) {
            this.triggeredPlayers = new ArrayList<String>();
        }
        return switch (attribute) {
            case "namespace" -> this.namespace;
            case "soundId" -> this.soundName;
            case "volume" -> String.valueOf(this.volume);
            case "pitch" -> String.valueOf(this.pitch);
            case "stopAllMusic" -> String.valueOf(this.stopAllMusic);
            case "isSelfReset" -> String.valueOf(this.isSelfReset);
            default -> null;
        };
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (this.triggeredPlayers == null) {
            this.triggeredPlayers = new ArrayList<String>();
        }
        this.namespace = nbt.method_10573("namespace", 8) ? nbt.method_10558("namespace") : "minecraft";
        this.soundName = nbt.method_10573("soundName", 8) ? nbt.method_10558("soundName") : "music.game";
        this.volume = nbt.method_10573("volume", 5) ? nbt.method_10583("volume") : 1.0f;
        this.pitch = nbt.method_10573("pitch", 5) ? nbt.method_10583("pitch") : 1.0f;
        this.stopAllMusic = nbt.method_10573("stopAllMusic", 1) ? nbt.method_10577("stopAllMusic") : true;
        this.isSelfReset = nbt.method_10573("isSelfReset", 1) ? nbt.method_10577("isSelfReset") : true;
        this.triggeredPlayers.clear();
        if (nbt.method_10573("triggeredPlayers", 10)) {
            class_2487 playersNbt = nbt.method_10562("triggeredPlayers");
            int count = playersNbt.method_10550("count");
            for (int i = 0; i < count; ++i) {
                String playerUuid = playersNbt.method_10558("player_" + i);
                if (playerUuid.isEmpty()) continue;
                this.triggeredPlayers.add(playerUuid);
            }
        }
        if (this.namespace == null) {
            this.namespace = "minecraft";
        }
        if (this.soundName == null) {
            this.soundName = "music.game";
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.triggeredPlayers == null) {
            this.triggeredPlayers = new ArrayList<String>();
        }
        nbt.method_10582("namespace", this.namespace != null && !this.namespace.isEmpty() ? this.namespace : "minecraft");
        nbt.method_10582("soundName", this.soundName != null && !this.soundName.isEmpty() ? this.soundName : "music.game");
        nbt.method_10548("volume", this.volume);
        nbt.method_10548("pitch", this.pitch);
        nbt.method_10556("stopAllMusic", this.stopAllMusic);
        nbt.method_10556("isSelfReset", this.isSelfReset);
        if (!this.triggeredPlayers.isEmpty()) {
            class_2487 playersNbt = new class_2487();
            playersNbt.method_10569("count", this.triggeredPlayers.size());
            for (int i = 0; i < this.triggeredPlayers.size(); ++i) {
                playersNbt.method_10582("player_" + i, this.triggeredPlayers.get(i));
            }
            nbt.method_10566("triggeredPlayers", (class_2520)playersNbt);
        }
    }

    @Override
    public void reset() {
        if (this.triggeredPlayers != null) {
            this.triggeredPlayers.clear();
        }
        super.reset();
    }

    static {
        attributes.add("namespace");
        attributes.add("soundId");
        attributes.add("volume");
        attributes.add("pitch");
        attributes.add("stopAllMusic");
        attributes.add("isSelfReset");
    }
}

