/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.FlagListener;
import lol.sefort.seengine.components.EngineComponents;
import lol.sefort.seengine.components.world.IDimensionDataComponent;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.joml.Vector4f;

public class RoomBlockEntity
extends AbstractMappingBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    static int i = 0;
    Map<class_2338, AbstractMappingBlockEntity> children = new HashMap<class_2338, AbstractMappingBlockEntity>();
    Map<String, Boolean> flags = new HashMap<String, Boolean>();
    boolean childCheckPending;
    boolean active;
    boolean suppressModifications = true;
    boolean initialized;
    int curResetCooldown;
    int maxResetCooldown = 6000;

    public RoomBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.MAP_ROOM, pos, state);
        this.id = "room-" + i;
        ++i;
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 ignored1, class_2680 ignored2, T instance) {
        if (instance instanceof RoomBlockEntity) {
            RoomBlockEntity room = (RoomBlockEntity)instance;
            if (!room.initialized && world != null) {
                ((IDimensionDataComponent)EngineComponents.DIMENSION_DATA.get((Object)world)).registerRoomMappingBlock(room.field_11867);
                room.initialized = true;
            }
            if (room.childCheckPending && world != null) {
                for (class_2338 pos : room.getChildren()) {
                    AbstractMappingBlockEntity block;
                    class_2586 class_25862 = world.method_8321(pos);
                    if (class_25862 instanceof AbstractMappingBlockEntity && (block = (AbstractMappingBlockEntity)class_25862).getParent() != null && block.getParent().equals((Object)room.method_11016())) {
                        room.registerChild(pos, block);
                        continue;
                    }
                    room.removeChild(pos);
                }
                room.childCheckPending = false;
            }
            room.tick();
        }
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("R-" + this.getID()));
    }

    @Override
    public String getFocusKey() {
        return "room";
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.25f, 0.25f, 0.25f, 0.2f);
    }

    @Override
    public boolean showCamLine() {
        return true;
    }

    @Override
    void tick() {
        boolean lastActive = this.active;
        boolean bl = this.active = !this.getContainedPlayers().isEmpty();
        if (this.active) {
            this.children.forEach((pos, entity) -> {
                AbstractMappingBlockEntity e;
                class_2586 patt2417$temp = this.field_11863.method_8321(pos.method_10081((class_2382)this.method_11016()));
                if (patt2417$temp instanceof AbstractMappingBlockEntity && !(e = (AbstractMappingBlockEntity)patt2417$temp).selfTicking() && !(e instanceof RoomBlockEntity)) {
                    e.tick();
                }
            });
        } else if (this.maxResetCooldown > 0) {
            if (lastActive) {
                this.curResetCooldown = this.maxResetCooldown;
            }
            if (this.curResetCooldown > 0) {
                --this.curResetCooldown;
                if (this.curResetCooldown == 0) {
                    this.reset();
                }
            }
        }
    }

    @Override
    public void reset() {
        for (String key : this.flags.keySet()) {
            this.setFlag(key, false);
        }
        ArrayList<class_2338> remove = new ArrayList<class_2338>();
        for (class_2338 pos : this.children.keySet()) {
            AbstractMappingBlockEntity child;
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10081((class_2382)pos));
            if (class_25862 instanceof AbstractMappingBlockEntity && (child = (AbstractMappingBlockEntity)class_25862).getParent().equals((Object)this.field_11867)) {
                child.reset();
                continue;
            }
            remove.add(pos);
        }
        remove.forEach(this::removeChild);
    }

    public void registerChild(class_2338 pos, AbstractMappingBlockEntity blockEntity) {
        this.children.put(pos.method_10059((class_2382)this.method_11016()), blockEntity);
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
        this.setID(this.id);
    }

    public void removeChild(class_2338 pos) {
        this.children.remove(pos.method_10059((class_2382)this.method_11016()));
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
        this.setID(this.id);
    }

    public List<class_2338> getChildren() {
        ArrayList<class_2338> out = new ArrayList<class_2338>();
        this.children.forEach((c, b) -> out.add(c.method_10081((class_2382)this.method_11016())));
        return out;
    }

    public void registerFlag(String id) {
        this.flags.put(id, false);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
    }

    public boolean removeFlag(String id) {
        boolean b;
        boolean bl = b = this.flags.remove(id) != null;
        if (b) {
            this.method_5431();
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        }
        return b;
    }

    public boolean checkFlag(String id) {
        return this.flags.getOrDefault(id, false);
    }

    public Set<String> getFlags() {
        return this.flags.keySet();
    }

    public boolean setFlag(String id, boolean state) {
        if (!this.flags.containsKey(id)) {
            return false;
        }
        this.flags.put(id, state);
        for (class_2338 pos : this.children.keySet()) {
            FlagListener listener;
            AbstractMappingBlockEntity abstractMappingBlockEntity = this.children.get(pos);
            if (!(abstractMappingBlockEntity instanceof FlagListener) || (listener = (FlagListener)((Object)abstractMappingBlockEntity)).isGlobal() || listener.getFlag() == null || !listener.getFlag().equals(id)) continue;
            if (state) {
                listener.onActivateFlag();
                continue;
            }
            listener.onDeactivateFlag();
        }
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        return true;
    }

    public boolean hasFlag(String id) {
        return this.flags.containsKey(id);
    }

    @Override
    public String getTexture() {
        return "root";
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        if (s.equals("resetCooldown")) {
            this.maxResetCooldown = value.equals("never") || value.equals("-1") || value.equals("null") ? -1 : Math.max(Integer.parseInt(value), 1);
        } else if (s.equals("suppressModifications")) {
            this.suppressModifications = Boolean.parseBoolean(value);
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        if (attribute.equals("resetCooldown")) {
            return this.maxResetCooldown == -1 ? "never" : String.valueOf(this.maxResetCooldown);
        }
        if (attribute.equals("suppressModifications")) {
            return String.valueOf(this.suppressModifications);
        }
        return null;
    }

    public boolean isSuppressModifications() {
        return this.suppressModifications;
    }

    public boolean resetIfEmpty() {
        if (!this.active) {
            this.reset();
        }
        return !this.active;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("flags", 10)) {
            this.flags = new HashMap<String, Boolean>();
            class_2487 flags = nbt.method_10562("flags");
            for (String key : flags.method_10541()) {
                this.flags.put(key, flags.method_10577(key));
            }
        }
        if (nbt.method_10573("children", 9)) {
            this.children = new HashMap<class_2338, AbstractMappingBlockEntity>();
            class_2499 list = nbt.method_10554("children", 4);
            for (class_2520 i : list) {
                class_2503 l;
                class_2338 pos;
                if (!(i instanceof class_2503) || (pos = class_2338.method_10092((long)(l = (class_2503)i).method_10699())) == null) continue;
                this.children.put(pos, null);
            }
            if (!list.isEmpty()) {
                this.childCheckPending = true;
            }
        }
        if (nbt.method_10573("resetCooldown", 3)) {
            this.maxResetCooldown = nbt.method_10550("resetCooldown");
        }
        if (nbt.method_10573("noMod", 1)) {
            this.suppressModifications = nbt.method_10577("noMod");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 flags = new class_2487();
        for (String id : this.getFlags()) {
            flags.method_10556(id, this.checkFlag(id));
        }
        nbt.method_10566("flags", (class_2520)flags);
        class_2499 children = new class_2499();
        for (class_2338 pos : this.children.keySet()) {
            children.add((Object)class_2503.method_23251((long)pos.method_10063()));
        }
        nbt.method_10566("children", (class_2520)children);
        nbt.method_10569("resetCooldown", this.maxResetCooldown);
        nbt.method_10556("noMod", this.suppressModifications);
    }

    @Override
    public void onBreakBlock() {
        if (this.field_11863 != null) {
            ((IDimensionDataComponent)EngineComponents.DIMENSION_DATA.get((Object)this.field_11863)).removeRoomMappingBlock(this.field_11867);
        }
        this.children.forEach((pos, entity) -> entity.setParent(null));
    }

    static {
        attributes.add("resetCooldown");
        attributes.add("suppressModifications");
    }
}

