/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractListenerBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class RedstoneListenerBlockEntity
extends AbstractListenerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    boolean powered = false;
    boolean inverted = false;
    int powerLevel = 15;

    public static <T extends class_2586> void tick(class_1937 world, class_2338 blockPos, class_2680 state, T t) {
        class_2586 class_25862 = world.method_8321(blockPos);
        if (class_25862 instanceof RedstoneListenerBlockEntity) {
            RedstoneListenerBlockEntity listener = (RedstoneListenerBlockEntity)class_25862;
            listener.tick();
        }
    }

    public RedstoneListenerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.MAP_REDSTONE, pos, state);
        this.id = "redstoneListener";
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(1.0f, 0.3f, 0.3f, 0.75f).lerp((Vector4fc)new Vector4f(0.5f, 1.0f, 0.5f, 1.0f), (float)this.pulseRenderTime / 10.0f);
    }

    @Override
    public String getTexture() {
        return "redstone_listener";
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("RS-" + this.flag + "->" + this.id));
    }

    @Override
    public float getAreaLabelSize() {
        return 2.0f;
    }

    @Override
    protected void onStateChanged(boolean newState) {
        this.powered = newState;
        if (this.inverted) {
            this.powered = !this.powered;
        }
        this.updateNeighbors();
        super.onStateChanged(newState);
    }

    @Override
    protected void updateNeighbors() {
        this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
        this.field_11863.method_8508(this.method_11016(), this.method_11010().method_26204(), null);
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void reset() {
        this.powered = false;
        super.reset();
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        switch (s) {
            case "delay": {
                this.activationDelay = Integer.parseInt(value);
                break;
            }
            case "invert": {
                this.inverted = Boolean.parseBoolean(value);
                break;
            }
            case "powerLevel": {
                this.powerLevel = Math.max(0, Math.min(15, Integer.parseInt(value)));
            }
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        return switch (attribute) {
            case "delay" -> String.valueOf(this.activationDelay);
            case "invert" -> String.valueOf(this.inverted);
            case "powerLevel" -> String.valueOf(this.powerLevel);
            default -> null;
        };
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("powered", 1)) {
            this.powered = nbt.method_10577("powered");
        }
        if (nbt.method_10573("invert", 1)) {
            this.inverted = nbt.method_10577("invert");
        }
        if (nbt.method_10573("powerLevel", 3)) {
            this.powerLevel = nbt.method_10550("powerLevel");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("powered", this.powered);
        nbt.method_10556("invert", this.inverted);
        nbt.method_10569("powerLevel", this.powerLevel);
    }

    static {
        attributes.add("delay");
        attributes.add("invert");
        attributes.add("powerLevel");
    }
}

