/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.FlagBindable;
import lol.sefort.seengine.block.mapping.RoomBlockEntity;
import lol.sefort.seengine.components.EngineComponents;
import lol.sefort.seengine.components.player.IEditorComponent;
import lol.sefort.seengine.components.world.IDimensionDataComponent;
import lol.sefort.seengine.registry.PacketRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class EditModeCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").requires(source -> source.method_9259(2))).executes(EditModeCommands::executeToggleEditMode)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ping").executes(EditModeCommands::ping)).then(class_2170.method_9247((String)"clear").executes(EditModeCommands::executePingClear)))).then(class_2170.method_9247((String)"name").then(EditModeCommands.key().then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(EditModeCommands::rename))))).then(class_2170.method_9247((String)"area").then(EditModeCommands.key().executes(EditModeCommands::editArea)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"flag").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(EditModeCommands::addFlag)))).then(class_2170.method_9247((String)"remove").then(EditModeCommands.flag(false).executes(EditModeCommands::removeFlag)))).then(class_2170.method_9247((String)"set").then(EditModeCommands.flag(false).then(class_2170.method_9244((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(EditModeCommands::setFlag))))).then(class_2170.method_9247((String)"bind").then(EditModeCommands.key().then(EditModeCommands.flag(true).executes(EditModeCommands::bindFlag)))))).then(class_2170.method_9247((String)"reparent").then(EditModeCommands.key().executes(EditModeCommands::rebindParent)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"flySpeed").then(class_2170.method_9244((String)"speed", (ArgumentType)FloatArgumentType.floatArg()).executes(EditModeCommands::setFlySpeed)))).then(class_2170.method_9247((String)"noClip").executes(EditModeCommands::executeToggleNoClip))).then(class_2170.method_9247((String)"showAreaOwner").executes(EditModeCommands::executeToggleShowAreaOwner))).then(class_2170.method_9247((String)"ghost").executes(EditModeCommands::executeToggleGhost))).then(class_2170.method_9247((String)"recursiveRooms").executes(EditModeCommands::executeToggleRecursiveRooms))).then(class_2170.method_9247((String)"showRelations").executes(EditModeCommands::executeToggleShowRelations)))).then(class_2170.method_9247((String)"attribute").then(class_2170.method_9247((String)"set").then(EditModeCommands.key().then(class_2170.method_9244((String)"attribute", (ArgumentType)StringArgumentType.string()).suggests(EditModeCommands::suggestAttibutes).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(EditModeCommands::setAttribute)))))));
    }

    private static int executeToggleEditMode(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        editor.toggleEditMode();
        editor.sync();
        boolean b = editor.isActive();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)(b ? "command.seengine.edit.enable" : "command.seengine.edit.disable"), (Object[])new Object[]{player.method_5477().getString()}), true);
        return 1;
    }

    private static int ping(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        ArrayList<class_2338> roomBlocks = new ArrayList<class_2338>();
        ArrayList<class_2338> orphans = new ArrayList<class_2338>();
        class_2338 center = player.method_24515();
        class_1937 world = player.method_37908();
        for (int x = -64; x < 64; ++x) {
            for (int y = -64; y < 64; ++y) {
                for (int z = -64; z < 64; ++z) {
                    AbstractMappingBlockEntity block;
                    class_2338 pos = center.method_10069(x, y, z);
                    class_2586 blockEntity = world.method_8321(pos);
                    if (blockEntity instanceof RoomBlockEntity) {
                        RoomBlockEntity room = (RoomBlockEntity)blockEntity;
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.ping.room-found", (Object[])new Object[]{room.getID(), x, y, z}));
                        roomBlocks.add(pos);
                        continue;
                    }
                    if (!(blockEntity instanceof AbstractMappingBlockEntity) || (block = (AbstractMappingBlockEntity)blockEntity).getParent() != null && world.method_8321(block.getParent()) instanceof RoomBlockEntity) continue;
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.ping.orphan-found", (Object[])new Object[]{block.getFocusKey(), block.getID(), x, y, z}));
                    orphans.add(pos);
                }
            }
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(roomBlocks.size());
        for (class_2338 pos : roomBlocks) {
            buf.method_10807(pos);
        }
        buf.writeInt(orphans.size());
        for (class_2338 pos : orphans) {
            buf.method_10807(pos);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketRegistry.EDIT_PING_PACKET_ID, (class_2540)buf);
        if (roomBlocks.isEmpty()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.ping.no-results"));
        }
        if (!orphans.isEmpty()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.ping.orphan-count", (Object[])new Object[]{orphans.size()}));
        }
        return 1;
    }

    private static int executePingClear(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(0);
        buf.writeInt(0);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketRegistry.EDIT_PING_PACKET_ID, (class_2540)buf);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.ping.clear"));
        return 1;
    }

    private static int rename(CommandContext<class_2168> context) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        String key = (String)context.getArgument("key", String.class);
        String name = (String)context.getArgument("name", String.class);
        class_2338 pos = ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof AbstractMappingBlockEntity) {
            AbstractMappingBlockEntity e = (AbstractMappingBlockEntity)class_25862;
            e.setID(name);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.name.success"));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.nothing-focused", (Object[])new Object[]{key}));
        }
        return 1;
    }

    private static int editArea(CommandContext<class_2168> context) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        String key = (String)context.getArgument("key", String.class);
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        class_2338 pos = editor.getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof AbstractMappingBlockEntity) {
            AbstractMappingBlockEntity block = (AbstractMappingBlockEntity)class_25862;
            if (!block.isAreaModifiable()) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.area.not-resizeable", (Object[])new Object[]{key}));
                return 1;
            }
            editor.setEditAreaStep(2);
            editor.setEditAreaCore(pos);
            editor.sync();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.area.begin"));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.nothing-focused", (Object[])new Object[]{key}));
        }
        return 1;
    }

    private static class_2338 getSelectedRoom(class_1657 player) {
        return ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus("room");
    }

    private static int addFlag(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        class_2338 roomPos = EditModeCommands.getSelectedRoom((class_1657)player);
        if (roomPos == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-room"));
            return 1;
        }
        String id = (String)context.getArgument("id", String.class);
        class_2586 class_25862 = player.method_37908().method_8321(roomPos);
        if (class_25862 instanceof RoomBlockEntity) {
            RoomBlockEntity room = (RoomBlockEntity)class_25862;
            room.registerFlag(id);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.flag.add", (Object[])new Object[]{id}));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.room-but-no-room"));
        }
        return 1;
    }

    private static int removeFlag(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        class_2338 roomPos = EditModeCommands.getSelectedRoom((class_1657)player);
        if (roomPos == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-room"));
            return 1;
        }
        String flag = (String)context.getArgument("flag", String.class);
        class_2586 class_25862 = player.method_37908().method_8321(roomPos);
        if (class_25862 instanceof RoomBlockEntity) {
            RoomBlockEntity room = (RoomBlockEntity)class_25862;
            room.removeFlag(flag);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.flag.remove", (Object[])new Object[]{flag}));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.room-but-no-room"));
        }
        return 1;
    }

    private static int setFlag(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        class_2338 roomPos = EditModeCommands.getSelectedRoom((class_1657)player);
        if (roomPos == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-room"));
            return 1;
        }
        String flag = (String)context.getArgument("flag", String.class);
        boolean state = (Boolean)context.getArgument("state", Boolean.class);
        class_2586 class_25862 = player.method_37908().method_8321(roomPos);
        if (class_25862 instanceof RoomBlockEntity) {
            RoomBlockEntity room = (RoomBlockEntity)class_25862;
            if (room.hasFlag(flag)) {
                room.setFlag(flag, state);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.flag.set", (Object[])new Object[]{flag, state}));
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.flag.not-found", (Object[])new Object[]{flag}));
            }
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.room-but-no-room"));
        }
        return 1;
    }

    private static int bindFlag(CommandContext<class_2168> context) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        String key = (String)context.getArgument("key", String.class);
        String flag = (String)context.getArgument("flag", String.class);
        class_2338 pos = ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof FlagBindable) {
            FlagBindable e = (FlagBindable)class_25862;
            e.bindFlag(flag);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.flag.bind", (Object[])new Object[]{flag, key}));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.nothing-focused", (Object[])new Object[]{key}));
        }
        return 1;
    }

    private static int rebindParent(CommandContext<class_2168> context) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        String key = (String)context.getArgument("key", String.class);
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        if (key.equals("room") && !editor.isAllowRecursiveRooms()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.rebind.room"));
            return 1;
        }
        class_2338 pos = editor.getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof AbstractMappingBlockEntity) {
            class_2586 class_25863;
            AbstractMappingBlockEntity entity = (AbstractMappingBlockEntity)class_25862;
            editor.setRebindingParent(pos);
            editor.sync();
            class_2338 lastParent = entity.getParent();
            entity.setParent(null);
            if (lastParent != null && (class_25863 = player.method_37908().method_8321(lastParent)) instanceof RoomBlockEntity) {
                RoomBlockEntity room = (RoomBlockEntity)class_25863;
                room.removeChild(pos);
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.rebind.start", (Object[])new Object[]{key}));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.nothing-focused", (Object[])new Object[]{key}));
        }
        return 1;
    }

    private static int setFlySpeed(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        float speed = ((Float)context.getArgument("speed", Float.class)).floatValue();
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        editor.setFlySpeed(speed);
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.config.speed", (Object[])new Object[]{Float.valueOf(speed)}));
        return 1;
    }

    private static int executeToggleNoClip(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        boolean b = editor.toggleNoClip();
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)(b ? "command.seengine.edit.config.no-clip.on" : "command.seengine.edit.config.no-clip.off")));
        return 1;
    }

    private static int executeToggleShowAreaOwner(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        boolean b = editor.toggleShowAreaOwner();
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)(b ? "command.seengine.edit.config.show-area-owner.on" : "command.seengine.edit.config.show-area-owner.off")));
        return 1;
    }

    private static int executeToggleGhost(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        boolean b = editor.toggleGhost();
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)(b ? "command.seengine.edit.config.ghost.on" : "command.seengine.edit.config.ghost.off")));
        return 1;
    }

    private static int executeToggleRecursiveRooms(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        boolean b = editor.toggleRecursiveRooms();
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)(b ? "command.seengine.edit.config.recursive-rooms.on" : "command.seengine.edit.config.recursive-rooms.off")));
        return 1;
    }

    private static int executeToggleShowRelations(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        boolean b = editor.toggleShowRelations();
        editor.sync();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)(b ? "command.seengine.edit.config.relations.on" : "command.seengine.edit.config.relations.off")));
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestAttibutes(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return builder.buildFuture();
        }
        String key = (String)context.getArgument("key", String.class);
        class_2338 pos = ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof AbstractMappingBlockEntity) {
            AbstractMappingBlockEntity e = (AbstractMappingBlockEntity)class_25862;
            e.getAttributes().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    private static int setAttribute(CommandContext<class_2168> context) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.no-player"));
            return 1;
        }
        String key = (String)context.getArgument("key", String.class);
        String attribute = (String)context.getArgument("attribute", String.class);
        String value = (String)context.getArgument("value", String.class);
        class_2338 pos = ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus(key);
        if (pos != null && (class_25862 = player.method_37908().method_8321(pos)) instanceof AbstractMappingBlockEntity) {
            AbstractMappingBlockEntity e = (AbstractMappingBlockEntity)class_25862;
            List<String> attributes = e.getAttributes();
            if (!attributes.contains(attribute)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.attribute.not-found", (Object[])new Object[]{attribute, key}));
                return 1;
            }
            try {
                e.setAttribute(attribute, value);
            }
            catch (AbstractMappingBlockEntity.AttributeParseException exception) {
                if (exception.getExpectedDataType().equals("identifier")) {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.attribute.identifier-parse-failed"));
                } else {
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.attribute.parse-failed", (Object[])new Object[]{exception.getExpectedDataType()}));
                }
                return 1;
            }
            catch (NumberFormatException exception) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"command.seengine.edit.attribute.number-parse-failed"));
                return 1;
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.attribute.set", (Object[])new Object[]{attribute, value, key}));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.seengine.edit.nothing-focused", (Object[])new Object[]{key}));
        }
        return 1;
    }

    private static RequiredArgumentBuilder<class_2168, String> key() {
        return class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).suggests(EditModeCommands::suggestKeys);
    }

    private static CompletableFuture<Suggestions> suggestKeys(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return builder.buildFuture();
        }
        ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).getEditFocus().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static RequiredArgumentBuilder<class_2168, String> flag(boolean allowGlobal) {
        return class_2170.method_9244((String)"flag", (ArgumentType)StringArgumentType.string()).suggests(allowGlobal ? EditModeCommands::suggestLocalOrGlobalFlags : EditModeCommands::suggestLocalFlags);
    }

    private static CompletableFuture<Suggestions> suggestLocalOrGlobalFlags(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        FlagBindable flagged;
        class_2586 class_25862;
        boolean global;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return builder.buildFuture();
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        class_1937 world = player.method_37908();
        class_2338 targetPos = editor.getEditFocus((String)context.getArgument("key", String.class));
        boolean bl = global = targetPos != null && (class_25862 = world.method_8321(targetPos)) instanceof FlagBindable && (flagged = (FlagBindable)class_25862).isGlobal();
        if (!global) {
            class_2586 class_25863;
            class_2338 pos = editor.getEditFocus("room");
            if (pos != null && (class_25863 = world.method_8321(pos)) instanceof RoomBlockEntity) {
                RoomBlockEntity e = (RoomBlockEntity)class_25863;
                e.getFlags().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
        } else {
            ((IDimensionDataComponent)EngineComponents.DIMENSION_DATA.get((Object)world)).getAllFlags().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestLocalFlags(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        class_2586 class_25862;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return builder.buildFuture();
        }
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        class_1937 world = player.method_37908();
        class_2338 pos = editor.getEditFocus("room");
        if (pos != null && (class_25862 = world.method_8321(pos)) instanceof RoomBlockEntity) {
            RoomBlockEntity e = (RoomBlockEntity)class_25862;
            e.getFlags().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }
}

