/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractListenerBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class MusicListenerBlockEntity
extends AbstractListenerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    String namespace = "minecraft";
    String soundName = "music.game";
    float volume = 1.0f;
    float pitch = 1.0f;
    boolean stopAllMusic = true;
    boolean repeat = false;
    private int repeatTicks = 0;
    private int musicDuration = 0;

    public MusicListenerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.MAP_MUSIC_LISTENER, pos, state);
        this.id = "musicListener";
        this.namespace = "minecraft";
        this.soundName = "music.game";
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.stopAllMusic = true;
        this.repeat = false;
        this.musicDuration = 100;
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.8f, 0.4f, 0.9f, 0.75f).lerp((Vector4fc)new Vector4f(0.5f, 1.0f, 0.5f, 1.0f), (float)this.pulseRenderTime / 10.0f);
    }

    @Override
    public String getTexture() {
        return "music_listener";
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("ML-" + this.id));
    }

    @Override
    public float getAreaLabelSize() {
        return 0.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236 && this.repeat && this.state) {
            ++this.repeatTicks;
            if (this.repeatTicks >= this.musicDuration) {
                this.repeatTicks = 0;
                this.playMusic();
            }
        }
    }

    @Override
    protected void onStateChanged(boolean newState) {
        super.onStateChanged(newState);
        if (!this.field_11863.field_9236 && newState) {
            this.repeatTicks = 0;
            this.playMusic();
        } else if (!newState) {
            this.repeatTicks = 0;
        }
    }

    private void playMusic() {
        class_2960 soundId = new class_2960(this.namespace, this.soundName);
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
        if (soundEvent == null || soundEvent.method_14833().equals((Object)class_3414.method_47908((class_2960)soundId).method_14833())) {
            soundEvent = class_3414.method_47908((class_2960)soundId);
        }
        for (class_3222 player : this.field_11863.method_8503().method_3760().method_14571()) {
            if (player.method_37908() != this.field_11863) continue;
            if (this.stopAllMusic) {
                this.stopAllMusicForPlayer(player);
            }
            player.method_17356(soundEvent, class_3419.field_15253, this.volume, this.pitch);
            player.field_13987.method_14364((class_2596)new class_2770(null, class_3419.field_15253));
        }
    }

    private void stopAllMusicForPlayer(class_3222 player) {
        class_2770 stopPacket = new class_2770(null, class_3419.field_15253);
        player.field_13987.method_14364((class_2596)stopPacket);
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        switch (s) {
            case "namespace": {
                this.namespace = value;
                this.method_5431();
                break;
            }
            case "soundId": {
                this.soundName = value;
                this.method_5431();
                break;
            }
            case "volume": {
                this.volume = Math.max(0.0f, Float.parseFloat(value));
                this.method_5431();
                break;
            }
            case "pitch": {
                this.pitch = Math.max(0.1f, Math.min(2.0f, Float.parseFloat(value)));
                this.method_5431();
                break;
            }
            case "delay": {
                this.activationDelay = Math.max(0, Integer.parseInt(value));
                this.method_5431();
                break;
            }
            case "stopAllMusic": {
                this.stopAllMusic = Boolean.parseBoolean(value);
                this.method_5431();
                break;
            }
            case "repeat": {
                this.repeat = Boolean.parseBoolean(value);
                this.method_5431();
                break;
            }
            case "musicDuration": {
                this.musicDuration = Math.max(20, Integer.parseInt(value));
                this.method_5431();
            }
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        if (this.namespace == null) {
            this.namespace = "minecraft";
        }
        if (this.soundName == null) {
            this.soundName = "music.game";
        }
        return switch (attribute) {
            case "namespace" -> this.namespace;
            case "soundId" -> this.soundName;
            case "volume" -> String.valueOf(this.volume);
            case "pitch" -> String.valueOf(this.pitch);
            case "delay" -> String.valueOf(this.activationDelay);
            case "stopAllMusic" -> String.valueOf(this.stopAllMusic);
            case "repeat" -> String.valueOf(this.repeat);
            case "musicDuration" -> String.valueOf(this.musicDuration);
            default -> null;
        };
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.namespace = nbt.method_10573("namespace", 8) ? nbt.method_10558("namespace") : "minecraft";
        this.soundName = nbt.method_10573("soundName", 8) ? nbt.method_10558("soundName") : "music.game";
        this.volume = nbt.method_10573("volume", 5) ? nbt.method_10583("volume") : 1.0f;
        this.pitch = nbt.method_10573("pitch", 5) ? nbt.method_10583("pitch") : 1.0f;
        this.stopAllMusic = nbt.method_10573("stopAllMusic", 1) ? nbt.method_10577("stopAllMusic") : true;
        this.repeat = nbt.method_10573("repeat", 1) ? nbt.method_10577("repeat") : false;
        this.musicDuration = nbt.method_10573("musicDuration", 3) ? nbt.method_10550("musicDuration") : 100;
        this.repeatTicks = nbt.method_10573("repeatTicks", 3) ? nbt.method_10550("repeatTicks") : 0;
        if (this.namespace == null || this.namespace.isEmpty()) {
            this.namespace = "minecraft";
        }
        if (this.soundName == null || this.soundName.isEmpty()) {
            this.soundName = "music.game";
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("namespace", this.namespace);
        nbt.method_10582("soundName", this.soundName);
        nbt.method_10548("volume", this.volume);
        nbt.method_10548("pitch", this.pitch);
        nbt.method_10556("stopAllMusic", this.stopAllMusic);
        nbt.method_10556("repeat", this.repeat);
        nbt.method_10569("musicDuration", this.musicDuration);
        nbt.method_10569("repeatTicks", this.repeatTicks);
    }

    static {
        attributes.add("namespace");
        attributes.add("soundId");
        attributes.add("volume");
        attributes.add("pitch");
        attributes.add("delay");
        attributes.add("stopAllMusic");
        attributes.add("repeat");
        attributes.add("musicDuration");
    }
}

