/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.RoomBlockEntity;
import lol.sefort.seengine.components.EngineComponents;
import lol.sefort.seengine.components.player.IEditorComponent;
import lol.sefort.seengine.util.ColorUtil;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class EditModeRenderer {
    public static EditModeRenderer Instance;
    public List<class_2338> newRoomBlocks;
    public List<class_2338> newOrphans;
    public List<class_2338> resolvedOrphans = new ArrayList<class_2338>();
    private List<class_2338> roomBlocks = new ArrayList<class_2338>();
    private List<class_2338> orphans = new ArrayList<class_2338>();
    float pingTime;
    float pulseTime;
    List<class_2338> drawn = new ArrayList<class_2338>();

    public EditModeRenderer() {
        Instance = this;
    }

    public void addKnownRoom(class_2338 pos) {
        this.roomBlocks.add(pos);
    }

    public boolean isKnown(class_2338 pos) {
        return this.roomBlocks.contains(pos);
    }

    public void render(class_4587 matrices, class_4184 cam, float delta) {
        Object object;
        class_746 player = class_310.method_1551().field_1724;
        IEditorComponent editor = (IEditorComponent)EngineComponents.EDITOR.get((Object)player);
        if (!editor.isActive()) {
            return;
        }
        this.pulseTime = (this.pulseTime + delta / 10.0f) % 4.0f;
        float pulse = Math.max((float)Math.sin(this.pulseTime), 0.0f);
        if (this.newRoomBlocks != null) {
            this.roomBlocks = this.newRoomBlocks;
            this.newRoomBlocks = null;
            this.pingTime = 10.0f;
        }
        if (this.newOrphans != null) {
            this.orphans = this.newOrphans;
            this.newOrphans = null;
            this.pingTime = 10.0f;
        }
        if (!this.resolvedOrphans.isEmpty()) {
            this.orphans.removeAll(this.resolvedOrphans);
            this.resolvedOrphans.clear();
            this.pingTime = 1.0f;
        }
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23001();
        class_4597.class_4598 textImmediate = class_310.method_1551().method_22940().method_23000();
        class_4588 lines = immediate.getBuffer((class_1921)class_1921.field_21695);
        class_327 textRenderer = class_310.method_1551().field_1772;
        RenderSystem.disableDepthTest();
        ArrayList<class_2338> blocks = new ArrayList<class_2338>(this.roomBlocks);
        class_2338 focusRoomPos = editor.getEditFocus("room");
        RoomBlockEntity focusRoomEntity = null;
        if (focusRoomPos != null && (object = player.method_37908().method_8321(focusRoomPos)) instanceof RoomBlockEntity) {
            class_2586 class_25862;
            RoomBlockEntity room = (RoomBlockEntity)((Object)object);
            blocks.addAll(room.getChildren());
            if (!blocks.contains(focusRoomPos)) {
                blocks.add(focusRoomPos);
            }
            RoomBlockEntity cur = focusRoomEntity = room;
            while (cur.getParent() != null && (class_25862 = player.method_37908().method_8321(cur.getParent())) instanceof RoomBlockEntity) {
                RoomBlockEntity parent = (RoomBlockEntity)class_25862;
                blocks.remove(cur.getParent());
                cur = parent;
            }
        }
        if (focusRoomEntity != null) {
            this.drawn.clear();
            this.drawRecursively(editor, matrices, textRenderer, textImmediate, lines, cam, focusRoomPos, pulse, 0);
        }
        for (class_2338 pos : blocks) {
            if (this.drawn.contains(pos)) continue;
            this.drawMappingBlock(editor, matrices, textRenderer, textImmediate, lines, cam, pos, pulse, 0, false);
        }
        class_243 camPos = cam.method_19326();
        blocks = new ArrayList<class_2338>(this.orphans);
        for (class_2338 pos : blocks) {
            class_243 targetPos = pos.method_46558();
            class_2586 class_25863 = player.method_37908().method_8321(pos);
            if (!(class_25863 instanceof AbstractMappingBlockEntity)) continue;
            AbstractMappingBlockEntity blockEntity = (AbstractMappingBlockEntity)class_25863;
            if (blockEntity.getParent() != null && player.method_37908().method_8321(blockEntity.getParent()) instanceof RoomBlockEntity) {
                this.resolvedOrphans.add(pos);
                continue;
            }
            matrices.method_22903();
            matrices.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
            matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
            float alpha = Math.max(Math.min(this.pingTime, 1.0f), 0.5f);
            Vector4f col = new Vector4f(0.2f, 0.0f, 0.0f, alpha);
            col = col.lerp((Vector4fc)new Vector4f(1.0f, 0.0f, 0.0f, alpha), pulse);
            class_761.method_22982((class_4587)matrices, (class_4588)lines, (class_238)new class_238(new class_2338(0, 0, 0)).method_1014(-0.01).method_989(-0.5, -0.5, -0.5), (float)col.x, (float)col.y, (float)col.z, (float)col.w);
            matrices.method_22903();
            matrices.method_46416(0.0f, 1.0f, 0.0f);
            this.drawFloatingText(textRenderer, matrices, textImmediate, new Vector3f(), 1.0f, blockEntity.getAreaLabel(), -1, cam);
            matrices.method_22909();
            this.drawSprite(matrices, new Vector3f(0.0f, 0.0f, 0.0f), (class_4597)textImmediate, blockEntity, cam);
            matrices.method_22909();
            this.drawLineToCam(lines, matrices, targetPos.method_46409(), cam, col);
        }
        if (this.pingTime > 0.0f) {
            this.pingTime -= delta / 30.0f;
        }
        RenderSystem.enableDepthTest();
    }

    void drawRecursively(IEditorComponent editor, class_4587 matrices, class_327 tRenderer, class_4597.class_4598 textImmediate, class_4588 lines, class_4184 cam, class_2338 pos, float pulse, int depth) {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(pos);
        if (!(class_25862 instanceof RoomBlockEntity)) {
            return;
        }
        RoomBlockEntity entity = (RoomBlockEntity)class_25862;
        this.drawRecursivelyDown(editor, matrices, tRenderer, textImmediate, lines, cam, pos, pulse, depth - 1);
        if (entity.getParent() != null) {
            this.drawRecursivelyUp(editor, matrices, tRenderer, textImmediate, lines, cam, entity.getParent(), pulse, depth + 1);
        }
        this.drawMappingBlock(editor, matrices, tRenderer, textImmediate, lines, cam, pos, pulse, depth, entity.getParent() != null);
    }

    void drawRecursivelyDown(IEditorComponent editor, class_4587 matrices, class_327 tRenderer, class_4597.class_4598 textImmediate, class_4588 lines, class_4184 cam, class_2338 pos, float pulse, int depth) {
        class_2586 class_25862;
        class_638 world = class_310.method_1551().field_1687;
        if (this.drawn.contains(pos) || !((class_25862 = world.method_8321(pos)) instanceof RoomBlockEntity)) {
            return;
        }
        RoomBlockEntity room = (RoomBlockEntity)class_25862;
        ArrayDeque<class_2338> node = new ArrayDeque<class_2338>(room.getChildren());
        while (!node.isEmpty()) {
            class_2338 block = (class_2338)node.remove();
            if (this.drawn.contains(block)) continue;
            boolean isRoom = world.method_8321(block) instanceof RoomBlockEntity;
            if (isRoom) {
                this.drawRecursivelyDown(editor, matrices, tRenderer, textImmediate, lines, cam, block, pulse, depth - 1);
            }
            this.drawn.add(block);
            this.drawMappingBlock(editor, matrices, tRenderer, textImmediate, lines, cam, block, pulse, isRoom ? depth : depth + 1, true);
        }
    }

    void drawRecursivelyUp(IEditorComponent editor, class_4587 matrices, class_327 tRenderer, class_4597.class_4598 textImmediate, class_4588 lines, class_4184 cam, class_2338 pos, float pulse, int depth) {
        class_2586 class_25862;
        class_638 world = class_310.method_1551().field_1687;
        if (this.drawn.contains(pos) || !((class_25862 = world.method_8321(pos)) instanceof RoomBlockEntity)) {
            return;
        }
        RoomBlockEntity room = (RoomBlockEntity)class_25862;
        if (room.getParent() != null && world.method_8321(room.getParent()) instanceof RoomBlockEntity && !this.drawn.contains(room.getParent())) {
            this.drawRecursivelyUp(editor, matrices, tRenderer, textImmediate, lines, cam, room.getParent(), pulse, depth + 1);
        } else {
            this.drawRecursivelyDown(editor, matrices, tRenderer, textImmediate, lines, cam, pos, pulse, depth - 1);
            this.drawMappingBlock(editor, matrices, tRenderer, textImmediate, lines, cam, pos, pulse, depth, false);
        }
        ArrayDeque<class_2338> node = new ArrayDeque<class_2338>(room.getChildren());
        while (!node.isEmpty()) {
            class_2338 block = (class_2338)node.remove();
            if (this.drawn.contains(block)) continue;
            this.drawn.add(block);
            this.drawMappingBlock(editor, matrices, tRenderer, textImmediate, lines, cam, block, pulse, depth, true);
        }
    }

    void drawMappingBlock(IEditorComponent editor, class_4587 matrices, class_327 tRenderer, class_4597.class_4598 textImmediate, class_4588 lines, class_4184 cam, class_2338 pos, float pulse, int depth, boolean connectToParent) {
        boolean focused;
        class_2561 label;
        class_243 targetPos = pos.method_46558();
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(pos);
        if (!(class_25862 instanceof AbstractMappingBlockEntity)) {
            return;
        }
        AbstractMappingBlockEntity entity = (AbstractMappingBlockEntity)class_25862;
        float alpha = 1.0f / (float)(Math.abs(depth) + 1);
        if (editor.getEditFocus("room") != null && !editor.getEditFocus("room").equals((Object)entity.getParent())) {
            alpha *= 0.66f;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_2561 class_25612 = label = entity instanceof RoomBlockEntity && depth > 0 ? class_2561.method_30163((String)("SuperRoom-" + entity.getID())) : entity.getAreaLabel();
        if (entity instanceof RoomBlockEntity && depth == 0 && editor.getEditFocus("room") != null && !editor.getEditFocus("room").equals((Object)pos)) {
            label = class_2561.method_30163((String)("SiblingRoom-" + entity.getID()));
        }
        matrices.method_22903();
        matrices.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        class_243 camPos = cam.method_19326();
        matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        Vector4f col = new Vector4f((Vector4fc)entity.getColor()).mul(1.0f, 1.0f, 1.0f, alpha);
        if (this.pingTime > col.w) {
            col.set(Math.min(this.pingTime, 1.0f));
        }
        if (((focused = pos.equals((Object)editor.getEditFocus(entity.getFocusKey()))) || entity.alwaysShowArea()) && entity.getMin() != null && entity.getMax() != null) {
            class_238 box = entity.getAreaBox().method_989((double)(-pos.method_10263()) - 0.5, (double)(-pos.method_10264()) - 0.5, (double)(-pos.method_10260()) - 0.5);
            Vector4f areaColor = entity.getAreaColor().mul(1.0f, 1.0f, 1.0f, 1.0f / (float)Math.abs(depth));
            class_761.method_22982((class_4587)matrices, (class_4588)lines, (class_238)box, (float)areaColor.x, (float)areaColor.y, (float)areaColor.z, (float)areaColor.w);
            if (focused && editor.isShowAreaOwner()) {
                this.drawLinesBetweenBoxes(lines, matrices, new class_238(new class_2338(0, 0, 0)).method_989(-0.5, -0.5, -0.5), box, new Vector4f((Vector4fc)areaColor).mul(1.0f, 1.0f, 1.0f, 0.5f));
            }
            this.drawFloatingText(tRenderer, matrices, textImmediate, box.method_1005().method_46409().add(0.0f, 0.25f, 0.0f), entity.getAreaLabelSize(), label, -1, cam);
        }
        if (focused) {
            col = col.lerp((Vector4fc)new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), pulse);
        }
        class_761.method_22982((class_4587)matrices, (class_4588)lines, (class_238)new class_238(new class_2338(0, 0, 0)).method_1014(-0.01).method_989(-0.5, -0.5, -0.5), (float)col.x, (float)col.y, (float)col.z, (float)col.w);
        matrices.method_22903();
        matrices.method_46416(0.0f, 1.0f, 0.0f);
        this.drawFloatingText(tRenderer, matrices, textImmediate, new Vector3f(), 1.0f, label, -1, cam);
        matrices.method_22909();
        this.drawSprite(matrices, new Vector3f(0.0f, 0.0f, 0.0f), (class_4597)textImmediate, entity, cam);
        class_2338 parent = entity.getParent();
        if (editor.isShowRelations() && parent != null && !parent.equals((Object)pos) && connectToParent) {
            matrices.method_22904(-0.5, -0.5, -0.5);
            col = new Vector4f((Vector3fc)ColorUtil.hsv2rgb(new Vector3f((float)(parent.method_10263() + parent.method_10264() + parent.method_10260()) / 16.0f % 1.0f, 1.0f, 1.0f)), 1.0f / (float)Math.abs(depth));
            this.drawLineBetween(lines, matrices, new Vector3f(0.5f), parent.method_10059((class_2382)pos).method_46558().method_46409(), col);
        }
        matrices.method_22909();
        if (entity.showCamLine()) {
            col = new Vector4f((Vector3fc)ColorUtil.hsv2rgb(new Vector3f((float)(pos.method_10263() + pos.method_10264() + pos.method_10260()) / 16.0f % 1.0f, 1.0f, 1.0f)), alpha);
            this.drawLineToCam(lines, matrices, targetPos.method_46409(), cam, col);
        }
    }

    void drawFloatingText(class_327 renderer, class_4587 matrices, class_4597.class_4598 immediate, Vector3f tPos, float size, class_2561 text, int col, class_4184 cam) {
        matrices.method_22903();
        matrices.method_46416(tPos.x, tPos.y, tPos.z);
        matrices.method_22907(cam.method_23767());
        matrices.method_22905(-size / 50.0f, -size / 50.0f, size / 50.0f);
        renderer.method_30882(text, (float)(-renderer.method_27525((class_5348)text)) / 2.0f, 0.0f, col, false, matrices.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33993, 0x44000000, 0xF000F0);
        matrices.method_22909();
    }

    void drawSprite(class_4587 matrices, Vector3f tPos, class_4597 consumerProvider, AbstractMappingBlockEntity entity, class_4184 cam) {
        matrices.method_22903();
        matrices.method_46416(tPos.x, tPos.y, tPos.z);
        matrices.method_22907(cam.method_23767());
        matrices.method_22905(1.0f, 1.0f, -1.0f);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_4588 consumer = consumerProvider.getBuffer(class_1921.method_23576((class_2960)new class_2960(entity.getTextureNamespace(), "textures/item/editor/" + entity.getTexture() + ".png")));
        consumer.method_22918(matrix, -0.5f, -0.5f, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, -0.5f, 0.5f, 0.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, 0.5f, 0.5f, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, 0.5f, -0.5f, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        matrices.method_22909();
    }

    void drawLineToCam(class_4588 lines, class_4587 matrices, Vector3f targetPos, class_4184 cam, Vector4f col) {
        Vector3f camPos = cam.method_19326().method_46409();
        Vector3f p = new Vector3f(0.0f, 0.0f, 0.25f).rotateX((float)Math.toRadians(cam.method_19329())).rotateY(-((float)Math.toRadians(cam.method_19330())));
        this.drawLineBetween(lines, matrices, p, targetPos.sub((Vector3fc)camPos), col);
    }

    void drawLinesBetweenBoxes(class_4588 lines, class_4587 matrices, class_238 start, class_238 end, Vector4f col) {
        this.drawLineBetween(lines, matrices, new class_243(start.field_1323, start.field_1322, start.field_1321).method_46409(), new class_243(end.field_1323, end.field_1322, end.field_1321).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1320, start.field_1322, start.field_1321).method_46409(), new class_243(end.field_1320, end.field_1322, end.field_1321).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1323, start.field_1325, start.field_1321).method_46409(), new class_243(end.field_1323, end.field_1325, end.field_1321).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1320, start.field_1325, start.field_1321).method_46409(), new class_243(end.field_1320, end.field_1325, end.field_1321).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1323, start.field_1322, start.field_1324).method_46409(), new class_243(end.field_1323, end.field_1322, end.field_1324).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1320, start.field_1322, start.field_1324).method_46409(), new class_243(end.field_1320, end.field_1322, end.field_1324).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1323, start.field_1325, start.field_1324).method_46409(), new class_243(end.field_1323, end.field_1325, end.field_1324).method_46409(), col);
        this.drawLineBetween(lines, matrices, new class_243(start.field_1320, start.field_1325, start.field_1324).method_46409(), new class_243(end.field_1320, end.field_1325, end.field_1324).method_46409(), col);
    }

    void drawLineBetween(class_4588 lines, class_4587 matrices, Vector3f startPos, Vector3f targetPos, Vector4f col) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        lines.method_22918(matrix, startPos.x, startPos.y, startPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        lines.method_22918(matrix, targetPos.x, targetPos.y, targetPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 1.0f, 0.0f, 0.0f).method_1344();
        lines.method_22918(matrix, startPos.x, startPos.y, startPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        lines.method_22918(matrix, targetPos.x, targetPos.y, targetPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        lines.method_22918(matrix, startPos.x, startPos.y, startPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
        lines.method_22918(matrix, targetPos.x, targetPos.y, targetPos.z).method_22915(col.x, col.y, col.z, col.w).method_23763(normal, 0.0f, 0.0f, 1.0f).method_1344();
    }
}

