/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.client.rendering.block.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import lol.sefort.seengine.SEEngine;
import lol.sefort.seengine.block.mapping.CheckpointBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CheckpointRenderer
implements class_827<CheckpointBlockEntity> {
    final class_2960 TEXTURE = SEEngine.texIdentifier("textures/block/checkpoint");

    public CheckpointRenderer(class_5614.class_5615 context) {
    }

    public void render(CheckpointBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        boolean isLoopable;
        if (entity.getAttribute("invisible") != null && Boolean.parseBoolean(entity.getAttribute("invisible"))) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        entity.progressTime(class_310.method_1551().method_1534() / 120.0f);
        boolean bl = isLoopable = entity.getAttribute("loopable") != null && Boolean.parseBoolean(entity.getAttribute("loopable"));
        if (isLoopable) {
            this.renderLoopableCheckpoint(entity, matrices, vertexConsumers, light, overlay);
        } else {
            this.renderNormalCheckpoint(entity, matrices, vertexConsumers, light, overlay);
        }
    }

    private void renderNormalCheckpoint(CheckpointBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        float uSpan;
        Vector3f max;
        Vector3f min;
        float rotationDegrees = 0.0f;
        if (entity.getAttribute("rotation") != null) {
            try {
                rotationDegrees = Float.parseFloat(entity.getAttribute("rotation"));
            }
            catch (NumberFormatException e) {
                rotationDegrees = 0.0f;
            }
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        class_238 box = entity.getAreaBox().method_996(entity.method_11016().method_35830(-1));
        class_243 center = box.method_1005();
        float xSize = (float)Math.abs(box.field_1323 - box.field_1320);
        float zSize = (float)Math.abs(box.field_1321 - box.field_1324);
        if (xSize > zSize) {
            min = new Vector3f((float)box.field_1323, (float)(center.field_1351 - 0.5), (float)center.field_1350);
            max = new Vector3f((float)box.field_1320, (float)(center.field_1351 + 0.5), (float)center.field_1350);
            uSpan = xSize / 6.0f;
        } else {
            min = new Vector3f((float)center.field_1352, (float)(center.field_1351 - 0.5), (float)box.field_1321);
            max = new Vector3f((float)center.field_1352, (float)(center.field_1351 + 0.5), (float)box.field_1324);
            uSpan = zSize / 6.0f;
        }
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23689((class_2960)this.TEXTURE));
        Matrix4f matrix = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        float minU = (float)entity.getTime();
        float maxU = minU + uSpan;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE);
        consumer.method_22918(matrix, min.x, min.y, min.z).method_39415(-1).method_22913(maxU, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, min.x, max.y, min.z).method_39415(-1).method_22913(maxU, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, max.x, max.y, max.z).method_39415(-1).method_22913(minU, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, max.x, min.y, max.z).method_39415(-1).method_22913(minU, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, max.x, min.y, max.z).method_39415(-1).method_22913(maxU, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, max.x, max.y, max.z).method_39415(-1).method_22913(maxU, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, min.x, max.y, min.z).method_39415(-1).method_22913(minU, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, min.x, min.y, min.z).method_39415(-1).method_22913(minU, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
        matrices.method_22909();
    }

    private void renderLoopableCheckpoint(CheckpointBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        float rotationDegrees = 0.0f;
        if (entity.getAttribute("rotation") != null) {
            try {
                rotationDegrees = Float.parseFloat(entity.getAttribute("rotation"));
            }
            catch (NumberFormatException e) {
                rotationDegrees = 0.0f;
            }
        }
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        float timeRotation = (float)(entity.getTime() * 0.5);
        float totalRotationDegrees = (float)Math.toDegrees(timeRotation) + rotationDegrees;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(totalRotationDegrees));
        class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23689((class_2960)this.TEXTURE));
        Matrix4f matrix = matrices.method_23760().method_23761();
        Matrix3f normal = matrices.method_23760().method_23762();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE);
        int sides = 8;
        float radius = 1.5f;
        float height = 1.0f;
        float halfHeight = height / 2.0f;
        for (int i = 0; i < sides; ++i) {
            float angle1 = (float)(Math.PI * 2 * (double)i / (double)sides);
            float angle2 = (float)(Math.PI * 2 * (double)(i + 1) / (double)sides);
            float x1 = (float)(Math.cos(angle1) * (double)radius);
            float z1 = (float)(Math.sin(angle1) * (double)radius);
            float x2 = (float)(Math.cos(angle2) * (double)radius);
            float z2 = (float)(Math.sin(angle2) * (double)radius);
            float u1 = (float)i / (float)sides;
            float u2 = (float)(i + 1) / (float)sides;
            consumer.method_22918(matrix, x1, -halfHeight, z1).method_39415(-1).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, x1, 0.0f, z1).method_1344();
            consumer.method_22918(matrix, x1, halfHeight, z1).method_39415(-1).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, x1, 0.0f, z1).method_1344();
            consumer.method_22918(matrix, x2, halfHeight, z2).method_39415(-1).method_22913(u2, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, x2, 0.0f, z2).method_1344();
            consumer.method_22918(matrix, x2, -halfHeight, z2).method_39415(-1).method_22913(u2, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, x2, 0.0f, z2).method_1344();
            consumer.method_22918(matrix, x2, -halfHeight, z2).method_39415(-1).method_22913(u2, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, -x2, 0.0f, -z2).method_1344();
            consumer.method_22918(matrix, x2, halfHeight, z2).method_39415(-1).method_22913(u2, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, -x2, 0.0f, -z2).method_1344();
            consumer.method_22918(matrix, x1, halfHeight, z1).method_39415(-1).method_22913(u1, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, -x1, 0.0f, -z1).method_1344();
            consumer.method_22918(matrix, x1, -halfHeight, z1).method_39415(-1).method_22913(u1, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normal, -x1, 0.0f, -z1).method_1344();
        }
        matrices.method_22909();
    }

    public boolean rendersOutsideBoundingBox(CheckpointBlockEntity blockEntity) {
        return true;
    }
}

