/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.components.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lol.sefort.seengine.block.mapping.RoomBlockEntity;
import lol.sefort.seengine.components.EngineComponents;
import lol.sefort.seengine.components.player.IEditorComponent;
import lol.sefort.seengine.components.world.IDimensionDataComponent;
import lol.sefort.seengine.dimension.UltraDimensions;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class DimensionDataComponent
implements IDimensionDataComponent {
    final class_1937 provider;
    final List<class_2338> mappingRooms = new ArrayList<class_2338>();
    final List<class_2338> invalidRooms = new ArrayList<class_2338>();
    Map<String, Integer> flags = new HashMap<String, Integer>();
    boolean fixedStructuresPlaced;

    public DimensionDataComponent(class_1937 provider) {
        this.provider = provider;
    }

    @Override
    public boolean isFixedStructuresPlaced() {
        return this.fixedStructuresPlaced;
    }

    @Override
    public void setFixedStructuresPlaced(boolean b) {
        this.fixedStructuresPlaced = b;
    }

    @Override
    public Map<String, Integer> getAllFlags() {
        return this.flags;
    }

    @Override
    public int getFlag(String id) {
        return this.flags.getOrDefault(id, -1);
    }

    @Override
    public void setFlag(String id, int value) {
        this.flags.put(id, value);
    }

    @Override
    public void registerRoomMappingBlock(class_2338 pos) {
        if (!this.mappingRooms.contains(pos)) {
            this.mappingRooms.add(pos);
            EngineComponents.DIMENSION_DATA.sync((Object)this.provider);
        }
    }

    @Override
    public void removeRoomMappingBlock(class_2338 pos) {
        if (this.mappingRooms.remove(pos)) {
            EngineComponents.DIMENSION_DATA.sync((Object)this.provider);
        }
    }

    @Override
    public List<class_2338> getAllMappingRooms() {
        return this.mappingRooms;
    }

    @Override
    public void markRoomInvalid(class_2338 pos) {
        if (!this.invalidRooms.contains(pos)) {
            this.invalidRooms.add(pos);
        }
    }

    @Override
    public void clearInvalidRooms() {
        this.invalidRooms.forEach(this.mappingRooms::remove);
        this.invalidRooms.clear();
        EngineComponents.DIMENSION_DATA.sync((Object)this.provider);
    }

    @Override
    public boolean isPosNotModifiable(class_1657 player, class_2338 pos) {
        if (player == null || player.method_7338() || ((IEditorComponent)EngineComponents.EDITOR.get((Object)player)).isActive()) {
            return false;
        }
        IDimensionDataComponent data = (IDimensionDataComponent)EngineComponents.DIMENSION_DATA.get((Object)this.provider);
        for (class_2338 roomPos : data.getAllMappingRooms()) {
            if (!this.provider.method_22340(roomPos)) continue;
            class_2586 class_25862 = this.provider.method_8321(roomPos);
            if (!(class_25862 instanceof RoomBlockEntity)) {
                data.markRoomInvalid(pos);
                continue;
            }
            RoomBlockEntity room = (RoomBlockEntity)class_25862;
            if (!room.isSuppressModifications() || !room.getAreaBox().method_1006(pos.method_46558()) || !this.provider.equals(room.method_10997())) continue;
            if (UltraDimensions.Instance != null) {
                UltraDimensions.Instance.onSuppressedModification(player);
            }
            return true;
        }
        data.clearInvalidRooms();
        return !this.provider.method_8505(player, pos);
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10573("fixedStructuresPlaced", 1)) {
            this.fixedStructuresPlaced = tag.method_10577("fixedStructuresPlaced");
        }
        if (tag.method_10573("flags", 10)) {
            class_2487 flagCompound = tag.method_10562("flags");
            for (String id : flagCompound.method_10541()) {
                if (!flagCompound.method_10573(id, 3)) continue;
                this.flags.put(id, flagCompound.method_10550(id));
            }
        }
        if (tag.method_10573("rooms", 9)) {
            class_2499 list = tag.method_10554("", 10);
            list.forEach(i -> {
                if (i instanceof class_2503) {
                    class_2503 packed = (class_2503)i;
                    this.mappingRooms.add(class_2338.method_10092((long)packed.method_10699()));
                }
            });
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("fixedStructuresPlaced", this.fixedStructuresPlaced);
        class_2487 flagCompound = new class_2487();
        for (String id : this.flags.keySet()) {
            flagCompound.method_10569(id, this.flags.get(id).intValue());
        }
        tag.method_10566("flags", (class_2520)flagCompound);
        class_2499 rooms = new class_2499();
        this.mappingRooms.forEach(pos -> rooms.add((Object)class_2503.method_23251((long)pos.method_10063())));
        tag.method_10566("rooms", (class_2520)rooms);
    }
}

