/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractTriggerBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.joml.Vector4f;

public class MusicTriggerBlockEntity
extends AbstractTriggerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    List<? extends class_1309> lastContained = new ArrayList<class_1309>();
    String namespace = "minecraft";
    String soundName = "music.game";
    float volume = 1.0f;
    float pitch = 1.0f;
    boolean stopAllMusic = true;
    boolean isSelfReset = true;
    boolean repeat = false;
    int musicDuration = 5;
    List<String> triggeredPlayers;

    public MusicTriggerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends AbstractTriggerBlockEntity>)BlockEntityRegistry.MAP_MUSIC, pos, state);
        this.id = "musicTrigger";
        this.triggeredPlayers = new ArrayList<String>();
        this.selfResetting = true;
        this.activateDelay = 1;
        this.targetThreshold = 0;
        this.inverted = false;
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.9f, 0.3f, 0.8f, 1.0f);
    }

    @Override
    public String getTexture() {
        return "music_trigger";
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("M-" + this.id));
    }

    @Override
    Class<? extends class_1309> getTargetClass() {
        return class_1657.class;
    }

    @Override
    void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            String playerUuid;
            class_3222 player;
            ArrayList<class_1309> entered = new ArrayList<class_1309>();
            for (class_1309 entity : this.containedEntities) {
                if (this.lastContained.contains(entity) || !(entity instanceof class_3222)) continue;
                player = (class_3222)entity;
                playerUuid = player.method_5845();
                if (!this.isSelfReset && this.triggeredPlayers.contains(playerUuid)) continue;
                entered.add(entity);
            }
            if (!entered.isEmpty()) {
                for (class_1309 entity : entered) {
                    if (!(entity instanceof class_3222)) continue;
                    player = (class_3222)entity;
                    this.playMusic(player);
                    playerUuid = player.method_5845();
                    if (!this.isSelfReset && !this.triggeredPlayers.contains(playerUuid)) {
                        this.triggeredPlayers.add(playerUuid);
                        this.method_5431();
                    }
                    if (!this.repeat || this.musicDuration <= 0) continue;
                    this.scheduleRepeat(player);
                    this.startMusicBlocker(player);
                }
            }
            this.lastContained = new ArrayList<class_1309>(this.containedEntities);
        }
    }

    private void playMusic(class_3222 player) {
        class_2960 soundId = new class_2960(this.namespace, this.soundName);
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
        if (soundEvent == null) {
            soundEvent = class_3414.method_47908((class_2960)soundId);
        }
        if (this.stopAllMusic) {
            class_2770 stopPacket = new class_2770(null, class_3419.field_15253);
            player.field_13987.method_14364((class_2596)stopPacket);
        }
        player.method_17356(soundEvent, class_3419.field_15253, this.volume, this.pitch);
    }

    private void scheduleRepeat(final class_3222 player) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MusicTriggerBlockEntity.this.field_11863.method_8503().execute(() -> {
                    if (MusicTriggerBlockEntity.this.repeat) {
                        MusicTriggerBlockEntity.this.playMusic(player);
                        MusicTriggerBlockEntity.this.scheduleRepeat(player);
                    }
                });
            }
        }, (long)this.musicDuration * 1000L);
    }

    private void startMusicBlocker(final class_3222 player) {
        Timer blocker = new Timer();
        blocker.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MusicTriggerBlockEntity.this.field_11863.method_8503().execute(() -> {
                    if (MusicTriggerBlockEntity.this.repeat) {
                        String[] vanillaTracks;
                        for (String track : vanillaTracks = new String[]{"minecraft:music.creative", "minecraft:music.credits", "minecraft:music.dragon", "minecraft:music.end", "minecraft:music.game", "minecraft:music.menu", "minecraft:music.nether.basalt_deltas", "minecraft:music.nether.crimson_forest", "minecraft:music.nether.nether_wastes", "minecraft:music.nether.soul_sand_valley", "minecraft:music.nether.warped_forest", "minecraft:music.overworld.deep_dark", "minecraft:music.overworld.dripstone_caves", "minecraft:music.overworld.frozen_peaks", "minecraft:music.overworld.grove", "minecraft:music.overworld.jagged_peaks", "minecraft:music.overworld.lush_caves", "minecraft:music.overworld.meadow", "minecraft:music.overworld.old_growth_taiga", "minecraft:music.overworld.snowy_slopes", "minecraft:music.overworld.stony_peaks", "minecraft:music.overworld.swamp", "minecraft:music.overworld.jungle_and_forest", "minecraft:music.overworld.sparse_jungle", "minecraft:music.overworld.flower_forest", "minecraft:music.overworld.cherry_grove", "minecraft:music.overworld.desert", "minecraft:music.overworld.badlands", "minecraft:music.overworld.water", "minecraft:music_disc.11", "minecraft:music_disc.13", "minecraft:music_disc.blocks", "minecraft:music_disc.cat", "minecraft:music_disc.chirp", "minecraft:music_disc.far", "minecraft:music_disc.mall", "minecraft:music_disc.mellohi", "minecraft:music_disc.pigstep", "minecraft:music_disc.stal", "minecraft:music_disc.strd", "minecraft:music_disc.wait", "minecraft:music_disc.ward", "minecraft:music_disc.otherside", "minecraft:music_disc.5", "minecraft:music_disc.relic"}) {
                            class_2960 trackId = new class_2960(track);
                            class_2770 stopPacket = new class_2770(trackId, class_3419.field_15253);
                            player2.field_13987.method_14364((class_2596)stopPacket);
                        }
                    } else {
                        this.cancel();
                    }
                });
            }
        }, 0L, 1000L);
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        switch (s) {
            case "namespace": {
                this.namespace = value;
                this.method_5431();
                break;
            }
            case "soundId": {
                this.soundName = value;
                this.method_5431();
                break;
            }
            case "volume": {
                this.volume = Math.max(0.0f, Float.parseFloat(value));
                this.method_5431();
                break;
            }
            case "pitch": {
                this.pitch = Math.max(0.1f, Math.min(2.0f, Float.parseFloat(value)));
                this.method_5431();
                break;
            }
            case "stopAllMusic": {
                this.stopAllMusic = Boolean.parseBoolean(value);
                this.method_5431();
                break;
            }
            case "isSelfReset": {
                this.isSelfReset = Boolean.parseBoolean(value);
                if (this.isSelfReset && this.triggeredPlayers != null) {
                    this.triggeredPlayers.clear();
                }
                this.method_5431();
                break;
            }
            case "repeat": {
                this.repeat = Boolean.parseBoolean(value);
                this.method_5431();
                break;
            }
            case "musicDuration": {
                this.musicDuration = Math.max(1, Integer.parseInt(value));
                this.method_5431();
            }
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        if (this.namespace == null) {
            this.namespace = "minecraft";
        }
        if (this.soundName == null) {
            this.soundName = "music.game";
        }
        switch (attribute) {
            case "namespace": {
                return this.namespace;
            }
            case "soundId": {
                return this.soundName;
            }
            case "volume": {
                return String.valueOf(this.volume);
            }
            case "pitch": {
                return String.valueOf(this.pitch);
            }
            case "stopAllMusic": {
                return String.valueOf(this.stopAllMusic);
            }
            case "isSelfReset": {
                return String.valueOf(this.isSelfReset);
            }
            case "repeat": {
                return String.valueOf(this.repeat);
            }
            case "musicDuration": {
                return String.valueOf(this.musicDuration);
            }
        }
        return null;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (this.triggeredPlayers == null) {
            this.triggeredPlayers = new ArrayList<String>();
        }
        this.namespace = nbt.method_10573("namespace", 8) ? nbt.method_10558("namespace") : "minecraft";
        this.soundName = nbt.method_10573("soundName", 8) ? nbt.method_10558("soundName") : "music.game";
        this.volume = nbt.method_10573("volume", 5) ? nbt.method_10583("volume") : 1.0f;
        this.pitch = nbt.method_10573("pitch", 5) ? nbt.method_10583("pitch") : 1.0f;
        this.stopAllMusic = nbt.method_10573("stopAllMusic", 1) ? nbt.method_10577("stopAllMusic") : true;
        this.isSelfReset = nbt.method_10573("isSelfReset", 1) ? nbt.method_10577("isSelfReset") : true;
        this.repeat = nbt.method_10573("repeat", 1) ? nbt.method_10577("repeat") : false;
        this.musicDuration = nbt.method_10573("musicDuration", 3) ? nbt.method_10550("musicDuration") : 5;
        this.triggeredPlayers.clear();
        if (nbt.method_10573("triggeredPlayers", 10)) {
            class_2487 playersNbt = nbt.method_10562("triggeredPlayers");
            int count = playersNbt.method_10550("count");
            for (int i = 0; i < count; ++i) {
                String playerUuid = playersNbt.method_10558("player_" + i);
                if (playerUuid.isEmpty()) continue;
                this.triggeredPlayers.add(playerUuid);
            }
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.triggeredPlayers == null) {
            this.triggeredPlayers = new ArrayList<String>();
        }
        nbt.method_10582("namespace", this.namespace);
        nbt.method_10582("soundName", this.soundName);
        nbt.method_10548("volume", this.volume);
        nbt.method_10548("pitch", this.pitch);
        nbt.method_10556("stopAllMusic", this.stopAllMusic);
        nbt.method_10556("isSelfReset", this.isSelfReset);
        nbt.method_10556("repeat", this.repeat);
        nbt.method_10569("musicDuration", this.musicDuration);
        if (!this.triggeredPlayers.isEmpty()) {
            class_2487 playersNbt = new class_2487();
            playersNbt.method_10569("count", this.triggeredPlayers.size());
            for (int i = 0; i < this.triggeredPlayers.size(); ++i) {
                playersNbt.method_10582("player_" + i, this.triggeredPlayers.get(i));
            }
            nbt.method_10566("triggeredPlayers", (class_2520)playersNbt);
        }
    }

    @Override
    public void reset() {
        if (this.triggeredPlayers != null) {
            this.triggeredPlayers.clear();
        }
        super.reset();
    }

    static {
        attributes.add("namespace");
        attributes.add("soundId");
        attributes.add("volume");
        attributes.add("pitch");
        attributes.add("stopAllMusic");
        attributes.add("isSelfReset");
        attributes.add("repeat");
        attributes.add("musicDuration");
    }
}

