/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.FlagBindable;
import lol.sefort.seengine.block.mapping.RoomBlockEntity;
import lol.sefort.seengine.components.EngineComponents;
import lol.sefort.seengine.components.player.IEditorComponent;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public abstract class AbstractTriggerBlockEntity
extends AbstractMappingBlockEntity
implements FlagBindable {
    int active;
    int activateDelay = 1;
    int targetThreshold = 0;
    String flag;
    boolean selfResetting = true;
    boolean inverted;
    protected List<? extends class_1309> containedEntities = new ArrayList<class_1309>();
    boolean justReset = this.inverted;

    public AbstractTriggerBlockEntity(class_2591<? extends AbstractTriggerBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.id = "trigger";
    }

    @Override
    public String getFocusKey() {
        return "trigger";
    }

    @Override
    public Vector4f getAreaColor() {
        Vector4f col = new Vector4f(1.0f, 0.0f, 0.0f, 0.5f).lerp((Vector4fc)new Vector4f(0.0f, 1.0f, 0.0f, 0.5f), Math.min((float)this.active / (float)this.activateDelay, 1.0f));
        return col.lerp((Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), this.activateDelay > 1 ? Math.max(1.0f - (float)Math.abs(this.active - this.activateDelay) / 2.0f, 0.0f) : 0.0f);
    }

    @Override
    public float getAreaLabelSize() {
        return 2.0f;
    }

    @Override
    public boolean showCamLine() {
        return false;
    }

    @Override
    public boolean alwaysShowArea() {
        return true;
    }

    public boolean isActive() {
        return this.active > this.activateDelay;
    }

    @Override
    public void bindFlag(String flag) {
        this.flag = flag;
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    @Override
    void tick() {
        class_2586 class_25862;
        boolean condition;
        this.containedEntities = this.field_11863.method_18023(class_5575.method_31795(this.getTargetClass()), this.getAreaBox(), this::isValidTarget);
        boolean bl = condition = this.containedEntities.size() > this.targetThreshold;
        if (this.inverted) {
            condition = !condition;
        }
        boolean wasActive = this.isActive();
        if (!condition && this.active > 0 && (this.selfResetting || this.active < this.activateDelay || this.justReset && this.inverted)) {
            --this.active;
        }
        if (condition && this.active < this.activateDelay * 2) {
            ++this.active;
        }
        this.active = class_3532.method_15340((int)this.active, (int)0, (int)(this.activateDelay * 2));
        if (this.flag != null && this.getParent() != null && (class_25862 = this.field_11863.method_8321(this.getParent())) instanceof RoomBlockEntity) {
            RoomBlockEntity room = (RoomBlockEntity)class_25862;
            if (this.isActive() != wasActive) {
                this.justReset = false;
                room.setFlag(this.flag, this.isActive());
            }
        }
    }

    boolean isValidTarget(class_1309 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && ((IEditorComponent)EngineComponents.EDITOR.get((Object)(player = (class_1657)entity))).isGhost()) {
            return false;
        }
        return entity.method_5805() && !entity.method_7325();
    }

    @Override
    public void reset() {
        this.active = this.inverted ? this.activateDelay * 2 : 0;
        this.justReset = true;
    }

    public abstract Class<? extends class_1309> getTargetClass();

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("flag", 8)) {
            this.flag = nbt.method_10558("flag");
        }
        if (nbt.method_10573("activateDelay", 3)) {
            this.activateDelay = nbt.method_10550("activateDelay");
        }
        if (nbt.method_10573("selfReset", 1)) {
            this.selfResetting = nbt.method_10577("selfReset");
        }
        if (nbt.method_10573("targetThreshold", 3)) {
            this.targetThreshold = nbt.method_10550("targetThreshold");
        }
        if (nbt.method_10573("invert", 1)) {
            this.inverted = nbt.method_10577("invert");
            this.active = this.inverted ? this.activateDelay * 2 : 0;
        }
        this.justReset = nbt.method_10573("justReset", 1) ? nbt.method_10577("justReset") : this.inverted;
        if (nbt.method_10573("active", 3)) {
            this.active = nbt.method_10550("active");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.flag != null) {
            nbt.method_10582("flag", this.flag);
        }
        nbt.method_10569("activateDelay", this.activateDelay);
        nbt.method_10556("selfReset", this.selfResetting);
        nbt.method_10569("targetThreshold", this.targetThreshold);
        nbt.method_10556("invert", this.inverted);
        nbt.method_10556("justReset", this.justReset);
        nbt.method_10569("active", this.active);
    }

    protected void onActivate() {
    }
}

