/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractTriggerBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.joml.Vector4f;

public class AbyssBlockEntity
extends AbstractTriggerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    List<? extends class_1309> lastContained = new ArrayList<class_1309>();
    boolean canKill = false;
    class_2960 damagetype = new class_2960("out_of_world");
    float amount = 1.0f;

    public AbyssBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends AbstractTriggerBlockEntity>)BlockEntityRegistry.MAP_ABYSS, pos, state);
        this.id = "abyss";
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.2f, 0.05f, 0.25f, 1.0f);
    }

    @Override
    public String getTexture() {
        return "abyss";
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("ABYSS-" + this.id));
    }

    @Override
    public Class<? extends class_1309> getTargetClass() {
        return class_1657.class;
    }

    @Override
    void tick() {
        super.tick();
        class_2378 registry = this.field_11863.method_30349().method_30530(class_7924.field_42534);
        class_8110 damageType = (class_8110)registry.method_10223(this.damagetype);
        Optional damageTypeKey = registry.method_29113((Object)damageType);
        if (damageTypeKey.isEmpty()) {
            return;
        }
        for (class_1309 living : this.containedEntities) {
            class_1657 player;
            if (living instanceof class_1657 && ((player = (class_1657)living).method_7325() || player.method_7337()) || this.lastContained.contains(living)) continue;
            class_1282 damageSource = new class_1282((class_6880)registry.method_40290((class_5321)damageTypeKey.get()));
            float damageAmount = this.canKill ? this.amount : Math.min(living.method_6032() - 1.0f, this.amount);
            living.method_5643(damageSource, damageAmount);
            class_2338 pos = this.method_11016();
            class_3965 bHit = this.field_11863.method_17742(new class_3959(pos.method_46558(), pos.method_10087(16).method_46558(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)living));
            if (bHit.method_17783().equals((Object)class_239.class_240.field_1333)) {
                living.method_20620((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                continue;
            }
            class_243 hitPos = bHit.method_17784();
            living.method_20620(hitPos.field_1352, hitPos.field_1351, hitPos.field_1350);
        }
        this.lastContained = this.containedEntities;
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        super.setAttribute(s, value);
        switch (s) {
            case "damagetype": {
                this.damagetype = AbyssBlockEntity.parseIdentifier(value);
                break;
            }
            case "amount": {
                this.amount = Float.parseFloat(value);
                break;
            }
            case "canKill": {
                this.canKill = Boolean.parseBoolean(value);
            }
        }
    }

    @Override
    public String getAttribute(String attribute) {
        return switch (attribute) {
            case "damagetype" -> this.damagetype.toString();
            case "amount" -> String.valueOf(this.amount);
            case "canKill" -> String.valueOf(this.canKill);
            default -> null;
        };
    }

    @Override
    public float getAreaLabelSize() {
        return 0.0f;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("damageType", 8)) {
            this.damagetype = class_2960.method_12829((String)nbt.method_10558("damageType"));
        }
        if (nbt.method_10573("amount", 5)) {
            this.amount = nbt.method_10583("amount");
        }
        if (nbt.method_10573("canKill", 1)) {
            this.canKill = nbt.method_10577("canKill");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("damageType", this.damagetype.toString());
        nbt.method_10548("amount", this.amount);
        nbt.method_10556("canKill", this.canKill);
    }

    static {
        attributes.add("damagetype");
        attributes.add("amount");
        attributes.add("canKill");
    }
}

