/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.AbstractTriggerBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.joml.Vector4f;

public class CheckpointBlockEntity
extends AbstractTriggerBlockEntity {
    static List<String> attributes = new ArrayList<String>();
    double time;
    boolean invisible;
    boolean loopable = false;
    float rotation = 0.0f;
    private final Set<UUID> triggeredPlayers = new HashSet<UUID>();
    private final Set<UUID> activatedPlayers = new HashSet<UUID>();

    public CheckpointBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends AbstractTriggerBlockEntity>)BlockEntityRegistry.MAP_CHECKPOINT, pos, state);
        this.id = "checkpoint";
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.2f, 1.0f, 0.6f, 0.75f);
    }

    @Override
    public String getTexture() {
        return "checkpoint";
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public String getAttribute(String attribute) {
        if (attribute.equals("invisible")) {
            return String.valueOf(this.invisible);
        }
        if (attribute.equals("loopable")) {
            return String.valueOf(this.loopable);
        }
        if (attribute.equals("rotation")) {
            return String.valueOf(this.rotation);
        }
        return null;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        if (s.equals("invisible")) {
            this.invisible = Boolean.parseBoolean(value);
        } else if (s.equals("loopable")) {
            this.loopable = Boolean.parseBoolean(value);
        } else if (s.equals("rotation")) {
            this.rotation = Float.parseFloat(value);
        }
        super.setAttribute(s, value);
    }

    @Override
    public Class<? extends class_1309> getTargetClass() {
        return class_1657.class;
    }

    public void onRespawn() {
        this.time = 0.0;
    }

    @Override
    boolean selfTicking() {
        return true;
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 blockPos, class_2680 state, T t) {
        class_2586 class_25862 = world.method_8321(blockPos);
        if (class_25862 instanceof CheckpointBlockEntity) {
            CheckpointBlockEntity checkpoint = (CheckpointBlockEntity)class_25862;
            checkpoint.tick();
        }
    }

    @Override
    public float getAreaLabelSize() {
        return 0.0f;
    }

    @Override
    void tick() {
        super.tick();
        HashSet currentPlayers = new HashSet();
        this.containedEntities.forEach(e -> {
            if (e instanceof class_1657) {
                class_1657 player = (class_1657)e;
                currentPlayers.add(player.method_5667());
                if (this.loopable) {
                    if (!this.triggeredPlayers.contains(player.method_5667())) {
                        this.triggerCheckpoint(player);
                        this.triggeredPlayers.add(player.method_5667());
                    }
                } else if (!this.activatedPlayers.contains(player.method_5667()) && !this.triggeredPlayers.contains(player.method_5667())) {
                    this.triggerCheckpoint(player);
                    this.triggeredPlayers.add(player.method_5667());
                    this.activatedPlayers.add(player.method_5667());
                }
            }
        });
        if (this.loopable) {
            this.triggeredPlayers.removeIf(uuid -> !currentPlayers.contains(uuid));
        } else {
            this.triggeredPlayers.removeIf(uuid -> !currentPlayers.contains(uuid));
        }
    }

    private void triggerCheckpoint(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_26284(this.field_11863.method_27983(), this.field_11867, 0.0f, true, false);
            if (!this.invisible) {
                player.method_17356((class_3414)class_3417.field_14725.comp_349(), class_3419.field_15245, 1.0f, 2.0f);
            }
            if (!this.invisible && !this.field_11863.field_9236) {
                class_243 centerPos = this.field_11867.method_46558();
                for (int i = 0; i < 20; ++i) {
                    double velX = (player.method_6051().method_43058() - 0.5) * 0.3;
                    double velY = (player.method_6051().method_43058() - 0.5) * 0.3;
                    double velZ = (player.method_6051().method_43058() - 0.5) * 0.3;
                    class_1937 class_19372 = this.field_11863;
                    if (!(class_19372 instanceof class_3218)) continue;
                    class_3218 serverWorld = (class_3218)class_19372;
                    serverWorld.method_14199((class_2394)class_2398.field_11207, centerPos.field_1352, centerPos.field_1351, centerPos.field_1350, 1, velX, velY, velZ, 0.1);
                }
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void progressTime(double amount) {
        this.time += amount;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10549("time", this.time);
        nbt.method_10556("invisible", this.invisible);
        nbt.method_10556("loopable", this.loopable);
        nbt.method_10548("rotation", this.rotation);
        if (!this.activatedPlayers.isEmpty()) {
            class_2487 activatedNbt = new class_2487();
            int i = 0;
            for (UUID uuid : this.activatedPlayers) {
                activatedNbt.method_10582("player_" + i, uuid.toString());
                ++i;
            }
            activatedNbt.method_10569("count", i);
            nbt.method_10566("activatedPlayers", (class_2520)activatedNbt);
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.time = nbt.method_10574("time");
        if (nbt.method_10573("invisible", 1)) {
            this.invisible = nbt.method_10577("invisible");
        }
        if (nbt.method_10573("loopable", 1)) {
            this.loopable = nbt.method_10577("loopable");
        }
        if (nbt.method_10573("rotation", 5)) {
            this.rotation = nbt.method_10583("rotation");
        }
        this.activatedPlayers.clear();
        if (nbt.method_10573("activatedPlayers", 10)) {
            class_2487 activatedNbt = nbt.method_10562("activatedPlayers");
            int count = activatedNbt.method_10550("count");
            for (int i = 0; i < count; ++i) {
                String uuidStr = activatedNbt.method_10558("player_" + i);
                try {
                    this.activatedPlayers.add(UUID.fromString(uuidStr));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        attributes.add("invisible");
        attributes.add("loopable");
        attributes.add("rotation");
    }
}

