/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.block.mapping;

import java.util.ArrayList;
import java.util.List;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.block.mapping.FlagBindable;
import lol.sefort.seengine.block.mapping.RoomBlockEntity;
import lol.sefort.seengine.registry.BlockEntityRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.joml.Vector4f;

public class RedstoneReceiverBlockEntity
extends AbstractMappingBlockEntity
implements FlagBindable {
    static List<String> attributes = new ArrayList<String>();
    String flag;
    boolean lastPowered = false;
    boolean inverted = false;
    int threshold = 1;

    public static <T extends class_2586> void tick(class_1937 world, class_2338 blockPos, class_2680 state, T t) {
        class_2586 class_25862 = world.method_8321(blockPos);
        if (class_25862 instanceof RedstoneReceiverBlockEntity) {
            RedstoneReceiverBlockEntity receiver = (RedstoneReceiverBlockEntity)class_25862;
            receiver.tick();
        }
    }

    public RedstoneReceiverBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.MAP_RECEIVER, pos, state);
        this.id = "redstoneReceiver";
    }

    @Override
    public String getFocusKey() {
        return "receiver";
    }

    @Override
    public Vector4f getColor() {
        return new Vector4f(0.3f, 0.8f, 0.3f, 1.0f);
    }

    @Override
    public boolean showCamLine() {
        return false;
    }

    @Override
    public class_2561 getAreaLabel() {
        return class_2561.method_30163((String)("RR-" + this.id + " -> " + this.flag));
    }

    @Override
    void tick() {
        boolean powered;
        int receivedPower = this.field_11863.method_49804(this.field_11867);
        boolean bl = powered = receivedPower >= this.threshold;
        if (this.inverted) {
            boolean bl2 = powered = !powered;
        }
        if (powered != this.lastPowered) {
            class_2586 class_25862;
            this.lastPowered = powered;
            if (this.flag != null && this.getParent() != null && (class_25862 = this.field_11863.method_8321(this.getParent())) instanceof RoomBlockEntity) {
                RoomBlockEntity room = (RoomBlockEntity)class_25862;
                room.setFlag(this.flag, powered);
            }
        }
    }

    @Override
    public void bindFlag(String flag) {
        this.flag = flag;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
        }
    }

    @Override
    public String getFlag() {
        return this.flag;
    }

    @Override
    public String getTexture() {
        return "redstone_receiver";
    }

    @Override
    public List<String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttribute(String s, String value) throws AbstractMappingBlockEntity.AttributeParseException, NumberFormatException {
        switch (s) {
            case "invert": {
                this.inverted = Boolean.parseBoolean(value);
                break;
            }
            case "threshold": {
                this.threshold = Math.max(0, Math.min(15, Integer.parseInt(value)));
            }
        }
        super.setAttribute(s, value);
    }

    @Override
    public String getAttribute(String attribute) {
        return switch (attribute) {
            case "invert" -> String.valueOf(this.inverted);
            case "threshold" -> String.valueOf(this.threshold);
            default -> null;
        };
    }

    @Override
    public void reset() {
        this.lastPowered = false;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("flag", 8)) {
            this.flag = nbt.method_10558("flag");
        }
        if (nbt.method_10573("lastPowered", 1)) {
            this.lastPowered = nbt.method_10577("lastPowered");
        }
        if (nbt.method_10573("invert", 1)) {
            this.inverted = nbt.method_10577("invert");
        }
        if (nbt.method_10573("threshold", 3)) {
            this.threshold = nbt.method_10550("threshold");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.flag != null) {
            nbt.method_10582("flag", this.flag);
        }
        nbt.method_10556("lastPowered", this.lastPowered);
        nbt.method_10556("invert", this.inverted);
        nbt.method_10569("threshold", this.threshold);
    }

    static {
        attributes.add("invert");
        attributes.add("threshold");
    }
}

