/*
 * Decompiled with CFR 0.152.
 */
package lol.sefort.seengine.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import lol.sefort.seengine.SEEngine;
import lol.sefort.seengine.block.mapping.AbstractMappingBlockEntity;
import lol.sefort.seengine.dimension.DimensionManager;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3545;
import net.minecraft.class_3829;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelManager
extends DimensionManager {
    public static LevelManager Instance;
    public static final class_2960 ID;
    public static final class_5321<class_1937> WORLD_KEY;
    class_3218 world;
    static final Map<class_2960, LevelInstancePool> instances;
    static final Map<String, class_2960> levelIdForInstanceId;
    static int nextLevelBaseX;

    public LevelManager() {
        Instance = this;
    }

    public void init(class_3218 world) {
        if (this.world == null) {
            this.world = world;
        }
    }

    public void onServerStop() {
        this.destroyAllInstances();
        this.world = null;
    }

    public LevelInstance getInstance(String id) {
        class_2960 level = levelIdForInstanceId.get(id);
        if (level == null) {
            return null;
        }
        LevelInstancePool pool = instances.get(level);
        return pool.get(id);
    }

    public void removeInstance(String id) {
        LevelInstance instance = this.getInstance(id);
        if (instance == null) {
            return;
        }
        this.destroyInstance(id);
        instances.get(levelIdForInstanceId.get(id)).remove(id);
        levelIdForInstanceId.remove(id);
    }

    public static class_2338 getSpawnPos(String instanceId) {
        class_2960 levelId = levelIdForInstanceId.getOrDefault(instanceId, new class_2960(""));
        if (!instances.containsKey(levelId)) {
            SEEngine.LOGGER.warn("Getting spawnpoint for level '{}' failed; Level wasn't instantiated!", (Object)instanceId);
            return null;
        }
        return LevelManager.instances.get((Object)levelId).get((String)instanceId).pos.method_10069(0, 1, 0);
    }

    public class_3545<String, LevelInstance> instantiateLevel(class_2960 levelId, boolean privat) {
        LevelInstancePool pool = instances.get(levelId);
        return this.instantiateLevel(levelId, pool == null ? new class_2338(nextLevelBaseX, 0, 0) : pool.getFirstFreePos(), privat);
    }

    public class_3545<String, LevelInstance> instantiateLevel(class_2960 levelId, class_2338 pos, boolean privat) {
        SEEngine.LOGGER.info("Placing Level Structure {} at {}", (Object)levelId, (Object)pos.toString());
        AtomicReference<class_3545> inst = new AtomicReference<class_3545>();
        class_3341 box = new class_3341(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 64, pos.method_10264() + 32, pos.method_10260() + 64);
        Iterable blocks = class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(64, 32, 64));
        blocks.forEach(p -> {
            class_2586 block = this.world.method_8321(p);
            if (block instanceof AbstractMappingBlockEntity) {
                AbstractMappingBlockEntity mapBlock = (AbstractMappingBlockEntity)block;
                mapBlock.reset();
            }
        });
        List list = this.world.method_8335(null, new class_238((double)box.method_35415(), (double)box.method_35416(), (double)box.method_35417(), (double)box.method_35418(), (double)box.method_35419(), (double)box.method_35420()));
        list.forEach(e -> {
            if (!(e instanceof class_1657) && !(e instanceof class_8113) && !(e instanceof class_1530) || e.method_5752().contains("levelEntity") && e.field_6012 > 10) {
                e.method_5650(class_1297.class_5529.field_26999);
            } else if (!(e instanceof class_1657)) {
                e.method_5780("levelEntity");
            }
        });
        LevelInstancePool pool = instances.computeIfAbsent(levelId, k -> {
            nextLevelBaseX += box.method_35414() + 128;
            return new LevelInstancePool(pos, box);
        });
        int idx = pool.getFirstFreeIndex();
        LevelInstance newInstance = new LevelInstance(pos, idx);
        if (privat) {
            newInstance.setPrivate();
        }
        String newId = levelId.toString() + "_" + idx;
        levelIdForInstanceId.put(newId, levelId);
        SEEngine.LOGGER.info("New Level Instance ID: {}", (Object)newId);
        inst.set(new class_3545((Object)newId, (Object)newInstance));
        pool.put(newId, newInstance);
        for (int x = 0; x < box.method_35414(); x += 16) {
            for (int z = 0; z < box.method_14663(); z += 16) {
                this.world.method_14178().method_12124(new class_1923(new class_2338(x + box.method_35415(), 0, z + box.method_35417())), true);
            }
        }
        SEEngine.LOGGER.info("Level Structure {} placed successfully.", (Object)levelId);
        return (class_3545)inst.get();
    }

    public void destroyAllInstances() {
        for (LevelInstancePool pool : instances.values()) {
            for (String id : new ArrayList<String>(pool.instances.keySet())) {
                this.destroyInstance(id);
            }
        }
        instances.clear();
        levelIdForInstanceId.clear();
        nextLevelBaseX = 0;
    }

    public void destroyIfEmpty(@Nullable class_1657 except, String id) {
        if (!this.isLevelEmpty(except, id)) {
            return;
        }
        this.removeInstance(id);
    }

    public void destroyInstance(String id) {
        this.destroyInstance(id, false);
    }

    public void destroyInstance(String instanceId, boolean reload) {
        class_2960 levelId = levelIdForInstanceId.get(instanceId);
        if (levelId == null) {
            return;
        }
        LevelInstancePool pool = instances.get(levelId);
        if (pool == null) {
            return;
        }
        LevelInstance instance = pool.get(instanceId);
        if (instance == null) {
            SEEngine.LOGGER.warn("Level Structure {} destruction failed; level instance not found!", (Object)instanceId);
            return;
        }
        if (!reload) {
            ArrayList<class_3222> needsRescue = new ArrayList<class_3222>(instance.players);
            needsRescue.forEach(p -> this.rescue((class_3222)p, RescueReason.INSTANCE_DESTROYED));
        }
        SEEngine.LOGGER.info("Destroying Level Instance {}", (Object)instanceId);
        class_2338 pos = instance.pos;
        class_3341 box = pool.bounds;
        Iterable blocks = class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(box.method_35414(), box.method_14660(), box.method_14663()));
        ArrayList replaced = new ArrayList();
        boolean prevTileDrops = this.world.method_8450().method_8355(class_1928.field_19392);
        ((class_1928.class_4310)this.world.method_8450().method_20746(class_1928.field_19392)).method_20758(false, this.world.method_8503());
        blocks.forEach(block -> {
            class_3829.method_16825((Object)this.world.method_8321(block));
            if (this.world.method_8652(block, class_2246.field_10124.method_9564(), 2)) {
                replaced.add(block);
            }
        });
        ((class_1928.class_4310)this.world.method_8450().method_20746(class_1928.field_19392)).method_20758(prevTileDrops, this.world.method_8503());
        replaced.forEach(p -> this.world.method_8408(p, this.world.method_8320(p).method_26204()));
        List list = this.world.method_8335(null, class_238.method_19316((class_3341)box).method_996(pos));
        list.forEach(e -> {
            if (!(e instanceof class_1657)) {
                e.method_5650(class_1297.class_5529.field_26999);
            }
        });
        instances.get(levelId).remove(instanceId);
        SEEngine.LOGGER.info("Finished Destroying Level Instance {}", (Object)instanceId);
        for (int x = 0; x < box.method_35414(); x += 16) {
            for (int z = 0; z < box.method_14663(); z += 16) {
                this.world.method_14178().method_12124(new class_1923(new class_2338(x + box.method_35415(), 0, z + box.method_35417())), false);
            }
        }
    }

    void rescue(class_3222 player, RescueReason reason) {
        class_2338 spawnPoint = player.method_26280();
        class_5321 spawnDimension = player.method_26281();
        if (spawnPoint == null || spawnDimension == null || spawnDimension.method_29177().equals((Object)ID)) {
            class_3218 overworld = this.world.method_8503().method_30002();
            FabricDimensions.teleport((class_1297)player, (class_3218)overworld, (class_5454)new class_5454(overworld.method_43126().method_46558(), class_243.field_1353, player.method_36454(), player.method_36455()));
        } else {
            FabricDimensions.teleport((class_1297)player, (class_3218)this.world.method_8503().method_3847(spawnDimension), (class_5454)new class_5454(spawnPoint.method_46558(), class_243.field_1353, player.method_36454(), player.method_36455()));
        }
    }

    public void reloadInstance(String id, boolean privat) {
        SEEngine.LOGGER.info("Re-Placing Level Instance {}", (Object)id);
        LevelInstance old = this.getInstance(id);
        if (old == null) {
            SEEngine.LOGGER.info("Tried reloading a level instance that didn't exist: ({})", (Object)id);
            return;
        }
        class_3545<String, LevelInstance> newInstance = this.instantiateLevel(levelIdForInstanceId.get(id), privat);
        for (class_3222 p : new ArrayList<class_3222>(old.players)) {
            this.joinInstance(p, (String)newInstance.method_15442());
        }
    }

    public void joinInstance(class_3222 player, String id) {
        LevelInstance instance = this.getInstance(id);
        if (instance == null) {
            this.rescue(player, RescueReason.INSTANCE_NULL);
        } else {
            if (!instance.players.contains(player)) {
                instance.players.add(player);
            }
            if (instance.getOwner() == null) {
                instance.setOwner(player);
            }
        }
        class_3218 world = this.getWorld().method_8503().method_3847(WORLD_KEY);
        class_2338 spawnPos = LevelManager.getSpawnPos(id);
        FabricDimensions.teleport((class_1297)player, (class_3218)world, (class_5454)new class_5454(spawnPos.method_46558(), class_243.field_1353, 0.0f, 0.0f));
        class_3965 groundScan = player.method_37908().method_17742(new class_3959(player.method_19538(), player.method_19538().method_1023(0.0, 32.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
    }

    public void leaveInstance(class_3222 player, String id) {
        LevelInstance instance = this.getInstance(id);
        if (instance == null) {
            this.rescue(player, RescueReason.INSTANCE_NULL);
            return;
        }
        instance.players.remove(player);
        this.destroyIfEmpty((class_1657)player, id);
    }

    boolean isLevelEmpty(@Nullable class_1657 except, String id) {
        LevelInstance instance = this.getInstance(id);
        if (instance == null) {
            return true;
        }
        for (class_1657 class_16572 : instance.players) {
            if (class_16572.equals((Object)except)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void tick() {
        for (class_3222 player : new ArrayList(this.world.method_18456())) {
            if (!(player.method_23318() < (double)(this.world.method_31607() - 10))) continue;
            this.rescue(player, RescueReason.VOID);
        }
    }

    @Override
    public class_3218 getWorld() {
        return this.world;
    }

    @Override
    public void onWorldLoad() {
    }

    @Override
    class_2561 getModifyFailText() {
        return class_2561.method_43473();
    }

    public boolean isInstanceExistant(String instanceId) {
        return levelIdForInstanceId.containsKey(instanceId);
    }

    public class_2487 serializePool(class_2960 levelId) {
        class_2487 nbt = new class_2487();
        LevelInstancePool pool = instances.get(levelId);
        if (pool == null) {
            return nbt;
        }
        for (Map.Entry<String, LevelInstance> entry : pool.getAll().entrySet()) {
            LevelInstance val = entry.getValue();
            if (val.isPrivate()) continue;
            class_2487 instance = new class_2487();
            instance.method_25927("owner", val.getOwner() == null ? UUID.randomUUID() : val.getOwner().method_5667());
            nbt.method_10566(entry.getKey(), (class_2520)instance);
        }
        return nbt;
    }

    static {
        ID = SEEngine.identifier("levels");
        WORLD_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ID);
        instances = new HashMap<class_2960, LevelInstancePool>();
        levelIdForInstanceId = new HashMap<String, class_2960>();
        nextLevelBaseX = 0;
    }

    public static class LevelInstancePool {
        static final int separation = 128;
        public final HashMap<String, LevelInstance> instances = new HashMap();
        public final class_2338 basePos;
        public final class_3341 bounds;

        public LevelInstancePool(class_2338 basePos, class_3341 bounds) {
            this.basePos = basePos;
            this.bounds = bounds;
        }

        int getFirstFreeIndex() {
            List<LevelInstance> instance = this.instances.values().stream().sorted().toList();
            for (int i = 0; i < this.instances.size(); ++i) {
                if (instance.get((int)i).index == i) continue;
                return i;
            }
            return instance.size();
        }

        class_2338 getFirstFreePos() {
            return this.basePos.method_10069(0, 0, this.getFirstFreeIndex() * (this.bounds.method_14663() + 128));
        }

        public LevelInstance get(String id) {
            return this.instances.get(id);
        }

        public LevelInstance remove(String id) {
            return this.instances.remove(id);
        }

        public LevelInstance put(String id, LevelInstance instance) {
            return this.instances.put(id, instance);
        }

        public HashMap<String, LevelInstance> getAll() {
            return this.instances;
        }
    }

    public static class LevelInstance
    implements Comparable<LevelInstance> {
        public final List<class_3222> players = new ArrayList<class_3222>();
        public final class_2338 pos;
        public final int index;
        public class_3222 owner;
        public boolean privat;
        public int kills;
        public int lastCheckpointKills;

        public LevelInstance(class_2338 pos, int index) {
            this.pos = pos;
            this.index = index;
        }

        public class_3222 getOwner() {
            return this.owner;
        }

        public void setOwner(class_3222 owner) {
            this.owner = owner;
            this.addPlayer(owner);
        }

        public void addPlayer(class_3222 player) {
            if (!this.players.contains(player)) {
                this.players.add(player);
            }
        }

        public void setPrivate() {
            this.privat = true;
        }

        public boolean isPrivate() {
            return this.privat;
        }

        @Override
        public int compareTo(@NotNull LevelInstance o) {
            return this.index - o.index;
        }

        public void onCheckpoint() {
            if (!LevelManager.Instance.world.field_9236 || LevelManager.Instance.world.method_8503().method_3860()) {
                this.lastCheckpointKills = this.kills;
            }
        }

        public void restoreLastCheckpointKills() {
            if (!LevelManager.Instance.world.field_9236 || LevelManager.Instance.world.method_8503().method_3860()) {
                this.setKills(this.lastCheckpointKills);
            }
        }

        public void onKill() {
            if (!LevelManager.Instance.world.field_9236 || LevelManager.Instance.world.method_8503().method_3860()) {
                this.setKills(this.kills + 1);
            }
        }

        public int getKills() {
            return this.kills;
        }

        void setKills(int i) {
            this.kills = i;
        }
    }

    static enum RescueReason {
        INSTANCE_DESTROYED("message.ultracraft.rescue.level-destroyed"),
        VOID("message.ultracraft.rescue.void"),
        INSTANCE_NULL("message.ultracraft.rescue.null");

        public final String message;

        private RescueReason(String message) {
            this.message = message;
        }
    }
}

