/*
 * Decompiled with CFR 0.152.
 */
package net.fyrxlab.advancement;

import net.fyrxlab.item.ModItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModAdvancements {
    public static void registerAdvancements() {
        MinecraftForge.EVENT_BUS.register((Object)new ModAdvancements());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        int timesLeft;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (timesLeft = (player = (ServerPlayer)player2).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_))) == 0) {
            ModAdvancements.grantAdvancement(player, "lazy:notch_blessing");
        }
    }

    @SubscribeEvent
    public void onEnderDragonDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity() instanceof EnderDragon && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModAdvancements.grantAdvancement(player, "lazy:lazy_winner");
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ModAdvancements.hasFullLazyArmor(player = (ServerPlayer)livingEntity)) {
            ModAdvancements.grantAdvancement(player, "lazy:lazy_of_the_year");
        }
    }

    private static boolean hasFullLazyArmor(ServerPlayer player) {
        ItemStack helmet = player.m_150109_().m_36052_(3);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack boots = player.m_150109_().m_36052_(0);
        return helmet.m_41720_() == ModItems.LAZY_HELMET.get() && chestplate.m_41720_() == ModItems.LAZY_CHESTPLATE.get() && leggings.m_41720_() == ModItems.LAZY_LEGGINGS.get() && boots.m_41720_() == ModItems.LAZY_BOOTS.get();
    }

    private static void grantAdvancement(ServerPlayer player, String advancementId) {
        AdvancementProgress progress;
        if (player.m_20194_() == null) {
            return;
        }
        ResourceLocation id = new ResourceLocation(advancementId);
        Advancement advancement = player.m_20194_().m_129889_().m_136041_(id);
        if (advancement != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }
}

