/*
 * Decompiled with CFR 0.152.
 */
package net.fyrxlab.event;

import net.fyrxlab.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModEvents {
    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        int timesLeft;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (timesLeft = (player = (ServerPlayer)player2).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_))) == 0) {
            ModEvents.giveStarterKit(player);
            ModEvents.generateEndPortal(player);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity() instanceof EnderDragon && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModEvents.giveDragonRewards(player);
        }
    }

    private static void giveStarterKit(ServerPlayer player) {
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_SWORD.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_BOW.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42412_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_PICKAXE.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_AXE.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_HELMET.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_CHESTPLATE.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_LEGGINGS.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.LAZY_BOOTS.get(), 1));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42545_, 20));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42584_, 32));
    }

    private static void generateEndPortal(ServerPlayer player) {
        int dz;
        int dx;
        int i;
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int x = playerPos.m_123341_() + 5;
        int z = playerPos.m_123343_();
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos centerPos = new BlockPos(x, y, z);
        BlockState frameState = (BlockState)((BlockState)Blocks.f_50258_.m_49966_().m_61124_((Property)EndPortalFrameBlock.f_53043_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EndPortalFrameBlock.f_53042_, (Comparable)Direction.SOUTH);
        for (i = -1; i <= 1; ++i) {
            level.m_46597_(centerPos.m_7918_(i, 0, 2), (BlockState)frameState.m_61124_((Property)EndPortalFrameBlock.f_53042_, (Comparable)Direction.NORTH));
        }
        for (i = -1; i <= 1; ++i) {
            level.m_46597_(centerPos.m_7918_(i, 0, -2), (BlockState)frameState.m_61124_((Property)EndPortalFrameBlock.f_53042_, (Comparable)Direction.SOUTH));
        }
        for (i = -1; i <= 1; ++i) {
            level.m_46597_(centerPos.m_7918_(2, 0, i), (BlockState)frameState.m_61124_((Property)EndPortalFrameBlock.f_53042_, (Comparable)Direction.WEST));
        }
        for (i = -1; i <= 1; ++i) {
            level.m_46597_(centerPos.m_7918_(-2, 0, i), (BlockState)frameState.m_61124_((Property)EndPortalFrameBlock.f_53042_, (Comparable)Direction.EAST));
        }
        BlockState portalState = Blocks.f_50257_.m_49966_();
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                level.m_46597_(centerPos.m_7918_(dx, 0, dz), portalState);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 3; ++dy) {
                    level.m_46597_(centerPos.m_7918_(dx, dy, dz), Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private static void giveDragonRewards(ServerPlayer player) {
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42729_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42729_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42729_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42679_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42049_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42049_, 64));
        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42049_, 64));
    }
}

