/*
 * Decompiled with CFR 0.152.
 */
package net.fyrxlab.item;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fyrxlab.item.ModItems;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LazyArmorItem
extends ArmorItem {
    private static final Map<UUID, Map<ArmorItem.Type, Boolean>> PLAYER_ARMOR_STATE = new HashMap<UUID, Map<ArmorItem.Type, Boolean>>();

    public LazyArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && entity instanceof Player) {
            boolean bootsEquipped;
            ArmorItem armorItem;
            Player player = (Player)entity;
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_266204_() != ArmorItem.Type.HELMET) {
                return;
            }
            UUID playerId = player.m_20148_();
            PLAYER_ARMOR_STATE.putIfAbsent(playerId, new HashMap());
            Map<ArmorItem.Type, Boolean> armorState = PLAYER_ARMOR_STATE.get(playerId);
            ItemStack helmetSlot = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chestSlot = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack legsSlot = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack bootsSlot = player.m_6844_(EquipmentSlot.FEET);
            boolean helmetEquipped = helmetSlot.m_41720_() == ModItems.LAZY_HELMET.get();
            boolean chestplateEquipped = chestSlot.m_41720_() == ModItems.LAZY_CHESTPLATE.get();
            boolean leggingsEquipped = legsSlot.m_41720_() == ModItems.LAZY_LEGGINGS.get();
            boolean bl = bootsEquipped = bootsSlot.m_41720_() == ModItems.LAZY_BOOTS.get();
            if (armorState.getOrDefault(ArmorItem.Type.HELMET, false).booleanValue() && !helmetEquipped) {
                this.removeHelmetEffects(player);
            }
            if (armorState.getOrDefault(ArmorItem.Type.CHESTPLATE, false).booleanValue() && !chestplateEquipped) {
                this.removeChestplateEffects(player);
            }
            if (armorState.getOrDefault(ArmorItem.Type.LEGGINGS, false).booleanValue() && !leggingsEquipped) {
                this.removeLeggingsEffects(player);
            }
            if (armorState.getOrDefault(ArmorItem.Type.BOOTS, false).booleanValue() && !bootsEquipped) {
                this.removeBootsEffects(player);
            }
            if (helmetEquipped) {
                this.applyHelmetEffects(player);
            }
            if (chestplateEquipped) {
                this.applyChestplateEffects(player);
            }
            if (leggingsEquipped) {
                this.applyLeggingsEffects(player);
            }
            if (bootsEquipped) {
                this.applyBootsEffects(player);
            }
            if ((helmetEquipped || chestplateEquipped || leggingsEquipped || bootsEquipped) && player.m_6060_()) {
                player.m_20095_();
            }
            armorState.put(ArmorItem.Type.HELMET, helmetEquipped);
            armorState.put(ArmorItem.Type.CHESTPLATE, chestplateEquipped);
            armorState.put(ArmorItem.Type.LEGGINGS, leggingsEquipped);
            armorState.put(ArmorItem.Type.BOOTS, bootsEquipped);
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    private static void ensureEffect(Player player, MobEffect effect, int minDuration, int amplifier) {
        MobEffectInstance current = player.m_21124_(effect);
        if (current == null || current.m_19557_() < minDuration || current.m_19564_() != amplifier) {
            player.m_7292_(new MobEffectInstance(effect, 400, amplifier, false, false, false));
        }
    }

    private void applyHelmetEffects(Player player) {
        LazyArmorItem.ensureEffect(player, MobEffects.f_19611_, 120, 0);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19608_, 120, 0);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19616_, 120, 4);
        player.m_20301_(player.m_6062_());
    }

    private void applyChestplateEffects(Player player) {
        LazyArmorItem.ensureEffect(player, MobEffects.f_19606_, 120, 4);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19607_, 120, 0);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19617_, 120, 4);
        if (player.m_6103_() < 20.0f) {
            player.m_7911_(20.0f);
        }
    }

    private void applyLeggingsEffects(Player player) {
        LazyArmorItem.ensureEffect(player, MobEffects.f_19596_, 120, 2);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19603_, 120, 2);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19621_, 120, 2);
    }

    private void applyBootsEffects(Player player) {
        LazyArmorItem.ensureEffect(player, MobEffects.f_19600_, 120, 4);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19598_, 120, 4);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19605_, 120, 2);
        LazyArmorItem.ensureEffect(player, MobEffects.f_19618_, 120, 2);
    }

    private void removeHelmetEffects(Player player) {
        player.m_21195_(MobEffects.f_19611_);
        player.m_21195_(MobEffects.f_19608_);
        player.m_21195_(MobEffects.f_19616_);
    }

    private void removeChestplateEffects(Player player) {
        player.m_21195_(MobEffects.f_19606_);
        player.m_21195_(MobEffects.f_19607_);
        player.m_21195_(MobEffects.f_19617_);
        player.m_7911_(0.0f);
    }

    private void removeLeggingsEffects(Player player) {
        player.m_21195_(MobEffects.f_19596_);
        player.m_21195_(MobEffects.f_19603_);
        player.m_21195_(MobEffects.f_19621_);
    }

    private void removeBootsEffects(Player player) {
        player.m_21195_(MobEffects.f_19600_);
        player.m_21195_(MobEffects.f_19598_);
        player.m_21195_(MobEffects.f_19605_);
        player.m_21195_(MobEffects.f_19618_);
    }
}

