/*
 * Decompiled with CFR 0.152.
 */
package net.fyrxlab.item;

import java.util.HashSet;
import java.util.LinkedList;
import net.fyrxlab.item.LazyToolMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LazyAxeItem
extends AxeItem {
    private static final int MAX_BLOCKS_TO_BREAK = 1000;

    public LazyAxeItem(Item.Properties settings) {
        super((Tier)LazyToolMaterial.LAZY, 10000.0f, 1000.0f, settings);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!world.f_46443_ && this.isLog(state.m_60734_())) {
            this.breakTree(world, pos, miner);
        }
        return super.m_6813_(stack, world, state, pos, miner);
    }

    private void breakTree(Level world, BlockPos startPos, LivingEntity miner) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        visited.add(startPos);
        for (BlockPos neighbor : this.getNeighbors(startPos)) {
            BlockState neighborState = world.m_8055_(neighbor);
            Block neighborBlock = neighborState.m_60734_();
            if (!this.isLog(neighborBlock) && !this.isLeaf(neighborBlock) || visited.contains(neighbor)) continue;
            visited.add(neighbor);
            toProcess.add(neighbor);
        }
        int blocksProcessed = 0;
        while (!toProcess.isEmpty() && blocksProcessed < 1000) {
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockState currentState = world.m_8055_(currentPos);
            Block currentBlock = currentState.m_60734_();
            if (!this.isLog(currentBlock) && !this.isLeaf(currentBlock)) continue;
            world.m_46961_(currentPos, true);
            ++blocksProcessed;
            for (BlockPos neighbor : this.getNeighbors(currentPos)) {
                BlockState neighborState;
                Block neighborBlock;
                if (visited.contains(neighbor) || !this.isLog(neighborBlock = (neighborState = world.m_8055_(neighbor)).m_60734_()) && !this.isLeaf(neighborBlock)) continue;
                visited.add(neighbor);
                toProcess.add(neighbor);
            }
        }
    }

    private boolean isLog(Block block) {
        return block == Blocks.f_49999_ || block == Blocks.f_50000_ || block == Blocks.f_50001_ || block == Blocks.f_50002_ || block == Blocks.f_50003_ || block == Blocks.f_50004_ || block == Blocks.f_220832_ || block == Blocks.f_271170_ || block == Blocks.f_50011_ || block == Blocks.f_50012_ || block == Blocks.f_50013_ || block == Blocks.f_50014_ || block == Blocks.f_50015_ || block == Blocks.f_50043_ || block == Blocks.f_220836_ || block == Blocks.f_271348_ || block == Blocks.f_50010_ || block == Blocks.f_50005_ || block == Blocks.f_50006_ || block == Blocks.f_50007_ || block == Blocks.f_50008_ || block == Blocks.f_50009_ || block == Blocks.f_220835_ || block == Blocks.f_271326_ || block == Blocks.f_50044_ || block == Blocks.f_50045_ || block == Blocks.f_50046_ || block == Blocks.f_50047_ || block == Blocks.f_50048_ || block == Blocks.f_50049_ || block == Blocks.f_220837_ || block == Blocks.f_271145_ || block == Blocks.f_50695_ || block == Blocks.f_50686_ || block == Blocks.f_50697_ || block == Blocks.f_50688_ || block == Blocks.f_50696_ || block == Blocks.f_50687_ || block == Blocks.f_50698_ || block == Blocks.f_50689_;
    }

    private boolean isLeaf(Block block) {
        return block == Blocks.f_50050_ || block == Blocks.f_50051_ || block == Blocks.f_50052_ || block == Blocks.f_50053_ || block == Blocks.f_50054_ || block == Blocks.f_50055_ || block == Blocks.f_220838_ || block == Blocks.f_271115_ || block == Blocks.f_152470_ || block == Blocks.f_152471_ || block == Blocks.f_50451_ || block == Blocks.f_50692_;
    }

    private Iterable<BlockPos> getNeighbors(BlockPos pos) {
        HashSet<BlockPos> neighbors = new HashSet<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    neighbors.add(pos.m_7918_(x, y, z));
                }
            }
        }
        return neighbors;
    }
}

