/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.woolplates;

import bl4ckscor3.mod.woolplates.Configuration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;

public class WoolPlateBlock
extends PressurePlateBlock {
    private BlockSetType blockSetType;

    public WoolPlateBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(blockSetType, properties);
        this.blockSetType = blockSetType;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, double fallDistance) {
        super.fallOn(level, state, pos, entity, fallDistance * 0.8);
    }

    public void checkPressed(Entity entity, Level level, BlockPos pos, BlockState state, int currentSignal) {
        boolean shouldHaveSignal;
        int signalStrength = this.getSignalStrength(level, pos);
        boolean hasSignal = currentSignal > 0;
        boolean bl = shouldHaveSignal = signalStrength > 0;
        if (currentSignal != signalStrength) {
            BlockState newState = this.setSignalForState(state, signalStrength);
            level.setBlock(pos, newState, 2);
            this.updateNeighbours(level, pos);
            level.setBlocksDirty(pos, state, newState);
        }
        if (!shouldHaveSignal && hasSignal) {
            if (((Boolean)Configuration.CONFIG.enableSound.get()).booleanValue()) {
                level.playSound(null, pos, this.blockSetType.pressurePlateClickOff(), SoundSource.BLOCKS);
            }
            if (((Boolean)Configuration.CONFIG.triggerSculkSensors.get()).booleanValue()) {
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
            }
        } else if (shouldHaveSignal && !hasSignal) {
            if (((Boolean)Configuration.CONFIG.enableSound.get()).booleanValue()) {
                level.playSound(null, pos, this.blockSetType.pressurePlateClickOn(), SoundSource.BLOCKS);
            }
            if (((Boolean)Configuration.CONFIG.triggerSculkSensors.get()).booleanValue()) {
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
            }
        }
        if (shouldHaveSignal) {
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getPressedTime());
        }
    }
}

