/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.woolplates;

import bl4ckscor3.mod.woolplates.Configuration;
import bl4ckscor3.mod.woolplates.WoolPlateBlock;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="woolplates")
@EventBusSubscriber
public class WoolPlates {
    public static final String MODID = "woolplates";
    public static final BlockSetType WOOL_PLATES_BLOCK_SET_TYPE = BlockSetType.register((BlockSetType)new BlockSetType("woolplates:wool", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.WOOL, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.EMPTY, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_ON, SoundEvents.EMPTY, SoundEvents.EMPTY));
    public static final Map<Color, Block> BLOCKS = new EnumMap<Color, Block>(Color.class);
    public static final Map<Color, BlockItem> ITEMS = new EnumMap<Color, BlockItem>(Color.class);

    public WoolPlates(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configuration.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(Registries.BLOCK, helper -> {
            for (Color color : Color.values()) {
                ResourceLocation name = WoolPlates.getName(color);
                WoolPlateBlock block = new WoolPlateBlock(BlockBehaviour.Properties.of().noCollision().strength(0.5f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)name)), WOOL_PLATES_BLOCK_SET_TYPE);
                helper.register(name, (Object)block);
                BLOCKS.put(color, (Block)block);
            }
        });
        event.register(Registries.ITEM, helper -> {
            for (Color color : Color.values()) {
                ResourceLocation name = WoolPlates.getName(color);
                BuiltInRegistries.BLOCK.get(name).ifPresent(ref -> {
                    Block block = (Block)ref.value();
                    if (block != null) {
                        BlockItem blockItem = new BlockItem(block, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name)).useBlockDescriptionPrefix());
                        helper.register(name, (Object)blockItem);
                        ITEMS.put(color, blockItem);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.insertAfter(new ItemStack((ItemLike)Items.STONE_PRESSURE_PLATE), new ItemStack((ItemLike)ITEMS.get((Object)Color.WHITE)), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.acceptAll(ITEMS.values().stream().map(ItemStack::new).toList());
        }
    }

    public static ResourceLocation getName(Color color) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("wool_plate_" + color.name().toLowerCase()));
    }

    public static enum Color {
        WHITE,
        LIGHT_GRAY,
        GRAY,
        BLACK,
        BROWN,
        RED,
        ORANGE,
        YELLOW,
        LIME,
        GREEN,
        CYAN,
        LIGHT_BLUE,
        BLUE,
        PURPLE,
        MAGENTA,
        PINK;

    }
}

