/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.radio.RadioData;
import de.maxhenkel.radio.radio.RadioItem;
import de.maxhenkel.radio.radio.RadioManager;
import de.maxhenkel.radio.utils.IPossibleRadioBlock;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class RadioCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 environment) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"radio").requires(commandSource -> commandSource.method_9259(Radio.SERVER_CONFIG.commandPermissionLevel.get().intValue()));
        literalBuilder.then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"station_name", (ArgumentType)StringArgumentType.string()).executes(RadioCommands::runCreateWithoutRange)).then(class_2170.method_9244((String)"sound_radius", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(RadioCommands::runCreateWithRange)))));
        literalBuilder.then(class_2170.method_9247((String)"debug").then(class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).executes(RadioCommands::runDebugCommand)));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"change").then(class_2170.method_9247((String)"held_item").then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"sound_radius", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(RadioCommands::runChangeItemRadius))))).then(class_2170.method_9247((String)"block").then(class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"sound_radius", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(RadioCommands::runChangeBlockRadius))))));
        dispatcher.register(literalBuilder);
    }

    private static int runCreateWithRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        String url = StringArgumentType.getString(context, (String)"url");
        String stationName = StringArgumentType.getString(context, (String)"station_name");
        float soundRadius = FloatArgumentType.getFloat(context, (String)"sound_radius");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return RadioCommands.runCreate(url, stationName, player, soundRadius);
    }

    private static int runCreateWithoutRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        String url = StringArgumentType.getString(context, (String)"url");
        String stationName = StringArgumentType.getString(context, (String)"station_name");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return RadioCommands.runCreate(url, stationName, player, -1.0f);
    }

    private static int runCreate(String url, String stationName, class_3222 player, float range) {
        try {
            player.method_31548().method_7394(RadioItem.newRadio(url, stationName, false, range));
            player.method_64398((class_2561)class_2561.method_43470((String)"Provided you with a radio for '%s'.".formatted(stationName)));
            return 1;
        }
        catch (Exception ex) {
            player.method_64398((class_2561)class_2561.method_43470((String)"There was an error while providing you with a radio.").method_27692(class_124.field_1061));
            LogUtils.getLogger().error(ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    private static int runDebugCommand(CommandContext<class_2168> context) {
        IPossibleRadioBlock radioBlock;
        class_2338 blockPos = class_2262.method_48299(context, (String)"location");
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof IPossibleRadioBlock && (radioBlock = (IPossibleRadioBlock)blockEntity).radio$isRadio()) {
            RadioData rData = radioBlock.radio$getRadioData();
            class_5250 message = class_2561.method_43470((String)"");
            for (class_2561 component : rData.toMessage(blockPos)) {
                message.method_10852(component);
            }
            ((class_2168)context.getSource()).method_9226(() -> message, false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Block at [%s] is not a radio.".formatted(blockPos.method_23854())));
        return 0;
    }

    private static int runChangeItemRadius(CommandContext<class_2168> context) throws CommandSyntaxException {
        float soundRadius = FloatArgumentType.getFloat(context, (String)"sound_radius");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 heldItem = player.method_5998(class_1268.field_5808);
        Optional<RadioData> optRadioData = RadioItem.readRadioData(heldItem);
        try {
            if (optRadioData.isPresent()) {
                RadioData data = optRadioData.get();
                data.setRange(soundRadius);
                data.serialiseIntoItemStack(heldItem);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Changed radio sound radius to %.1f block(s)".formatted(Float.valueOf(soundRadius))), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"There is no radio in your main hand."));
            return 0;
        }
        catch (Exception ex) {
            player.method_64398((class_2561)class_2561.method_43470((String)"There was an error while editing your radio.").method_27692(class_124.field_1061));
            LogUtils.getLogger().error(ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    private static int runChangeBlockRadius(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 blockPos = class_2262.method_48299(context, (String)"location");
        float soundRadius = FloatArgumentType.getFloat(context, (String)"sound_radius");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        class_2586 blockEntity = level.method_8321(blockPos);
        try {
            IPossibleRadioBlock radioBlock;
            if (blockEntity instanceof IPossibleRadioBlock && (radioBlock = (IPossibleRadioBlock)blockEntity).radio$isRadio()) {
                RadioData data = radioBlock.radio$getRadioData();
                data.setRange(soundRadius);
                RadioManager.getInstance().updateRadioStream(data, level, blockEntity);
                blockEntity.method_5431();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Changed radio sound radius to %.1f block(s)".formatted(Float.valueOf(soundRadius))), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"There is no radio at that location."));
            return 0;
        }
        catch (Exception ex) {
            player.method_64398((class_2561)class_2561.method_43470((String)"There was an error while editing your radio.").method_27692(class_124.field_1061));
            LogUtils.getLogger().error(ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }
}

