/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.configbuilder;

import de.maxhenkel.radio.configbuilder.CommentedProperties;
import de.maxhenkel.radio.configbuilder.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CommentedPropertyConfig
implements Config {
    private static final Logger LOGGER = Logger.getLogger(CommentedPropertyConfig.class.getName());
    protected CommentedProperties properties;
    protected Path path;

    public CommentedPropertyConfig(Path path) {
        this.path = path;
        this.properties = new CommentedProperties();
        this.reload();
    }

    public String get(String key) {
        return this.properties.get(key);
    }

    public void set(String key, String value, String ... comments) {
        this.properties.set(key, value, comments);
    }

    public CommentedProperties getProperties() {
        return this.properties;
    }

    public void load() throws IOException {
        if (Files.exists(this.path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
                this.properties.load(inputStream);
            }
        }
    }

    public void reload() {
        this.properties.clear();
        try {
            this.load();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to reload config", e);
        }
    }

    public void saveSync() {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create parent directories of config", e);
        }
        try (OutputStream stream = Files.newOutputStream(this.path, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING);){
            this.properties.save(stream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to save config", e);
        }
    }

    public void save() {
        new Thread(() -> {
            CommentedPropertyConfig commentedPropertyConfig = this;
            synchronized (commentedPropertyConfig) {
                this.saveSync();
            }
        }).start();
    }

    @Override
    public Map<String, String> getEntries() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

