/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.radio.radio;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.radio.Radio;
import de.maxhenkel.radio.radio.RadioManager;
import de.maxhenkel.radio.radio.RadioStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class RadioData {
    public static final UUID RADIO_ID = UUID.fromString("e333ec57-548d-41a1-aa4a-05bce4cfd028");
    public static final String RADIO_NAME = "Radio";
    public static final String NBT_CATEGORY = "radio";
    public static final String ID_TAG = "id";
    public static final String STREAM_URL_TAG = "stream_url";
    public static final String STATION_NAME_TAG = "station_name";
    public static final String ON_TAG = "on";
    public static final String RANGE_TAG = "range";
    private UUID id;
    private String url;
    private String stationName;
    private boolean on;
    private float range;
    public static final Codec<RadioData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_4844.field_25122.fieldOf(ID_TAG).orElseGet(UUID::randomUUID).forGetter(RadioData::getId), (App)Codec.STRING.fieldOf(STREAM_URL_TAG).forGetter(RadioData::getUrl), (App)Codec.STRING.fieldOf("name").forGetter(RadioData::getStationName), (App)Codec.BOOL.fieldOf("active").forGetter(RadioData::isOn), (App)Codec.FLOAT.fieldOf(RANGE_TAG).forGetter(RadioData::getRange)).apply((Applicative)builder, RadioData::new));
    public static final Codec<RadioData> ITEM_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf(STREAM_URL_TAG).forGetter(RadioData::getUrl), (App)Codec.STRING.fieldOf("name").forGetter(RadioData::getStationName), (App)Codec.BOOL.fieldOf("active").forGetter(RadioData::isOn), (App)Codec.FLOAT.fieldOf(RANGE_TAG).forGetter(RadioData::getRange)).apply((Applicative)builder, RadioData::createAnonymousRadioData));

    public RadioData(UUID id, String url, String stationName, boolean on, float range) {
        this.id = id;
        this.url = url;
        this.stationName = stationName;
        this.on = on;
        this.range = range;
    }

    @Deprecated(since="2.0")
    private RadioData(UUID id) {
        this.id = id;
        this.range = -1.0f;
    }

    public boolean assignIdIfNil() {
        if (this.id == class_156.field_25140) {
            this.id = UUID.randomUUID();
            return true;
        }
        return false;
    }

    public void serialiseIntoItemStack(class_1799 item) {
        class_9279 data = (class_9279)item.method_58694(class_9334.field_49628);
        class_9279 newData = this.saveToNewItemData(data);
        item.method_57379(class_9334.field_49628, (Object)newData);
    }

    public class_9279 saveToNewItemData() {
        return this.saveToNewItemData(null);
    }

    public class_9279 saveToNewItemData(class_9279 mergeWith) {
        class_2487 workingTag = mergeWith == null ? new class_2487() : mergeWith.method_57461();
        workingTag.method_67494(NBT_CATEGORY, ITEM_CODEC, (Object)this);
        return class_9279.method_57456((class_2487)workingTag);
    }

    public void toggleOn() {
        this.on = !this.on;
    }

    public boolean isRangeDefault() {
        return this.range < 0.0f;
    }

    public UUID getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStationName() {
        return this.stationName;
    }

    public boolean isOn() {
        return this.on;
    }

    public float getRange() {
        return this.range;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public List<class_2561> toMessage(class_2338 blockPos) {
        class_124[] body = new class_124[]{class_124.field_1080, class_124.field_1056};
        class_124[] title = new class_124[]{class_124.field_1063, class_124.field_1073};
        String range = this.isRangeDefault() ? "<default>" : "%.1f block(s)".formatted(Float.valueOf(this.range));
        LinkedList<class_5250> message = new LinkedList<class_5250>(List.of(class_2561.method_43470((String)"-- Radio Block Data at [%s]:\n".formatted(blockPos.method_23854())).method_27695(title), class_2561.method_43470((String)"UUID:  %s\n".formatted(this.id)).method_27695(body), class_2561.method_43470((String)"Name:  '%s'\n".formatted(this.stationName)).method_27695(body), class_2561.method_43470((String)"URL:  '%s'\n".formatted(this.url)).method_27695(body), class_2561.method_43470((String)"Range:  %s\n".formatted(range)).method_27695(body), class_2561.method_43470((String)"On?  %s\n\n".formatted(this.isOn())).method_27695(body)));
        Optional<RadioStream> optStream = RadioManager.getInstance().getRadioStream(this);
        message.add(class_2561.method_43470((String)"-- Radio Stream Data:\n").method_27695(title));
        if (optStream.isPresent()) {
            RadioStream stream = optStream.get();
            message.addAll(List.of(class_2561.method_43470((String)"Channel Id:  %s\n".formatted(stream.getLastKnownChannelId())).method_27695(body), class_2561.method_43470((String)"State:  '%s'\n".formatted(new Object[]{stream.getState()})).method_27695(body), class_2561.method_43470((String)"Range:  %s".formatted(Float.valueOf(stream.getOutputChannelRange()))).method_27695(body)));
        } else {
            message.add(class_2561.method_43470((String)"...no radio stream found...").method_27695(body));
        }
        return message;
    }

    @Deprecated(since="2.0")
    @Nullable
    public static RadioData fromGameProfile(GameProfile gameProfile) {
        if (!RadioData.hasLegacyRadioData(gameProfile)) {
            return null;
        }
        UUID uuid = UUID.randomUUID();
        String value = RadioData.getValue(gameProfile, ID_TAG);
        if (value != null) {
            try {
                uuid = UUID.fromString(value);
            }
            catch (Exception e) {
                Radio.LOGGER.warn("Failed to parse UUID '{}'", (Object)value, (Object)e);
            }
        }
        RadioData radioData = new RadioData(uuid);
        radioData.url = RadioData.getValue(gameProfile, STREAM_URL_TAG);
        radioData.stationName = RadioData.getValue(gameProfile, STATION_NAME_TAG);
        radioData.on = Boolean.parseBoolean(RadioData.getValue(gameProfile, ON_TAG));
        radioData.range = RadioData.getFloatValueOrElse(gameProfile, RANGE_TAG, -1.0f);
        gameProfile.properties().removeAll((Object)STREAM_URL_TAG);
        gameProfile.properties().removeAll((Object)STATION_NAME_TAG);
        gameProfile.properties().removeAll((Object)ON_TAG);
        gameProfile.properties().removeAll((Object)RANGE_TAG);
        return radioData;
    }

    @Deprecated(since="2.0")
    @Nullable
    private static String getValue(GameProfile gameProfile, String key) {
        return gameProfile.properties().get((Object)key).stream().filter(Objects::nonNull).map(Property::value).findFirst().orElse(null);
    }

    @Deprecated(since="2.0")
    private static float getFloatValueOrElse(GameProfile gameProfile, String key, float orElse) {
        String value = RadioData.getValue(gameProfile, key);
        if (value == null) {
            return orElse;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException err) {
            Radio.LOGGER.warn("Malformed radio data: %s".formatted(err.getMessage()));
            return orElse;
        }
    }

    public static boolean hasLegacyRadioData(GameProfile profile) {
        if (profile == null) {
            return false;
        }
        return profile.id().equals(RADIO_ID);
    }

    public static RadioData createAnonymousRadioData(String url, String stationName, boolean on, float range) {
        return new RadioData(class_156.field_25140, url, stationName, on, range);
    }
}

